package cusanalytic_sc_online

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchPersonByImg invokes the cusanalytic_sc_online.SearchPersonByImg API synchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/searchpersonbyimg.html
func (client *Client) SearchPersonByImg(request *SearchPersonByImgRequest) (response *SearchPersonByImgResponse, err error) {
	response = CreateSearchPersonByImgResponse()
	err = client.DoAction(request, response)
	return
}

// SearchPersonByImgWithChan invokes the cusanalytic_sc_online.SearchPersonByImg API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/searchpersonbyimg.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchPersonByImgWithChan(request *SearchPersonByImgRequest) (<-chan *SearchPersonByImgResponse, <-chan error) {
	responseChan := make(chan *SearchPersonByImgResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchPersonByImg(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchPersonByImgWithCallback invokes the cusanalytic_sc_online.SearchPersonByImg API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/searchpersonbyimg.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchPersonByImgWithCallback(request *SearchPersonByImgRequest, callback func(response *SearchPersonByImgResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchPersonByImgResponse
		var err error
		defer close(result)
		response, err = client.SearchPersonByImg(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchPersonByImgRequest is the request struct for api SearchPersonByImg
type SearchPersonByImgRequest struct {
	*requests.RpcRequest
	ImgUrl  string           `position:"Body" name:"ImgUrl"`
	StoreId requests.Integer `position:"Body" name:"StoreId"`
}

// SearchPersonByImgResponse is the response struct for api SearchPersonByImg
type SearchPersonByImgResponse struct {
	*responses.BaseResponse
	Success                 bool                    `json:"Success" xml:"Success"`
	Msg                     string                  `json:"Msg" xml:"Msg"`
	PersonSearchResultItems PersonSearchResultItems `json:"PersonSearchResultItems" xml:"PersonSearchResultItems"`
}

// CreateSearchPersonByImgRequest creates a request to invoke SearchPersonByImg API
func CreateSearchPersonByImgRequest() (request *SearchPersonByImgRequest) {
	request = &SearchPersonByImgRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cusanalytic_sc_online", "2019-05-24", "SearchPersonByImg", "", "")
	return
}

// CreateSearchPersonByImgResponse creates a response to parse from SearchPersonByImg response
func CreateSearchPersonByImgResponse() (response *SearchPersonByImgResponse) {
	response = &SearchPersonByImgResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
