package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EvaluateFailOverSwitch invokes the dds.EvaluateFailOverSwitch API synchronously
// api document: https://help.aliyun.com/api/dds/evaluatefailoverswitch.html
func (client *Client) EvaluateFailOverSwitch(request *EvaluateFailOverSwitchRequest) (response *EvaluateFailOverSwitchResponse, err error) {
	response = CreateEvaluateFailOverSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// EvaluateFailOverSwitchWithChan invokes the dds.EvaluateFailOverSwitch API asynchronously
// api document: https://help.aliyun.com/api/dds/evaluatefailoverswitch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EvaluateFailOverSwitchWithChan(request *EvaluateFailOverSwitchRequest) (<-chan *EvaluateFailOverSwitchResponse, <-chan error) {
	responseChan := make(chan *EvaluateFailOverSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EvaluateFailOverSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EvaluateFailOverSwitchWithCallback invokes the dds.EvaluateFailOverSwitch API asynchronously
// api document: https://help.aliyun.com/api/dds/evaluatefailoverswitch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EvaluateFailOverSwitchWithCallback(request *EvaluateFailOverSwitchRequest, callback func(response *EvaluateFailOverSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EvaluateFailOverSwitchResponse
		var err error
		defer close(result)
		response, err = client.EvaluateFailOverSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EvaluateFailOverSwitchRequest is the request struct for api EvaluateFailOverSwitch
type EvaluateFailOverSwitchRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	ReplicaId            string           `position:"Query" name:"ReplicaId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// EvaluateFailOverSwitchResponse is the response struct for api EvaluateFailOverSwitch
type EvaluateFailOverSwitchResponse struct {
	*responses.BaseResponse
	RequestId      string        `json:"RequestId" xml:"RequestId"`
	ReplicaId      string        `json:"ReplicaId" xml:"ReplicaId"`
	EvaluateResult string        `json:"EvaluateResult" xml:"EvaluateResult"`
	Items          []ItemsItem   `json:"Items" xml:"Items"`
	Reports        []ReportsItem `json:"Reports" xml:"Reports"`
}

// CreateEvaluateFailOverSwitchRequest creates a request to invoke EvaluateFailOverSwitch API
func CreateEvaluateFailOverSwitchRequest() (request *EvaluateFailOverSwitchRequest) {
	request = &EvaluateFailOverSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "EvaluateFailOverSwitch", "dds", "openAPI")
	return
}

// CreateEvaluateFailOverSwitchResponse creates a response to parse from EvaluateFailOverSwitch response
func CreateEvaluateFailOverSwitchResponse() (response *EvaluateFailOverSwitchResponse) {
	response = &EvaluateFailOverSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
