//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package eci

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeContainerGroupMetric invokes the eci.DescribeContainerGroupMetric API synchronously
// api document: https://help.aliyun.com/api/eci/describecontainergroupmetric.html
func (client *Client) DescribeContainerGroupMetric(request *DescribeContainerGroupMetricRequest) (response *DescribeContainerGroupMetricResponse, err error) {
	response = CreateDescribeContainerGroupMetricResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeContainerGroupMetricWithChan invokes the eci.DescribeContainerGroupMetric API asynchronously
// api document: https://help.aliyun.com/api/eci/describecontainergroupmetric.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeContainerGroupMetricWithChan(request *DescribeContainerGroupMetricRequest) (<-chan *DescribeContainerGroupMetricResponse, <-chan error) {
	responseChan := make(chan *DescribeContainerGroupMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeContainerGroupMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeContainerGroupMetricWithCallback invokes the eci.DescribeContainerGroupMetric API asynchronously
// api document: https://help.aliyun.com/api/eci/describecontainergroupmetric.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeContainerGroupMetricWithCallback(request *DescribeContainerGroupMetricRequest, callback func(response *DescribeContainerGroupMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeContainerGroupMetricResponse
		var err error
		defer close(result)
		response, err = client.DescribeContainerGroupMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeContainerGroupMetricRequest is the request struct for api DescribeContainerGroupMetric
type DescribeContainerGroupMetricRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RegionId             string           `position:"Query" name:"RegionId"`
	ContainerGroupId     string           `position:"Query" name:"ContainerGroupId"`
	StartTime            string           `position:"Query" name:"StartTime"`
	EndTime              string           `position:"Query" name:"EndTime"`
	Period               string           `position:"Query" name:"Period"`
}

// DescribeContainerGroupMetricResponse is the response struct for api DescribeContainerGroupMetric
type DescribeContainerGroupMetricResponse struct {
	*responses.BaseResponse
	RequestId        string                                 `json:"RequestId" xml:"RequestId"`
	ContainerGroupId string                                 `json:"ContainerGroupId" xml:"ContainerGroupId"`
	Records          []DescribeContainerGroupMetricRecords0 `json:"Records" xml:"Records"`
}

type DescribeContainerGroupMetricRecords0 struct {
	Record []DescribeContainerGroupMetricRecord1 `json:"Record" xml:"Record"`
}

type DescribeContainerGroupMetricRecord1 struct {
	Timestamp  string                                    `json:"Timestamp" xml:"Timestamp"`
	Containers []DescribeContainerGroupMetricContainers1 `json:"Containers" xml:"Containers"`
	CPU        DescribeContainerGroupMetricCPU1          `json:"CPU" xml:"CPU"`
	Memory     DescribeContainerGroupMetricMemory1       `json:"Memory" xml:"Memory"`
	Network    DescribeContainerGroupMetricNetwork1      `json:"Network" xml:"Network"`
}

type DescribeContainerGroupMetricContainers1 struct {
	Container []DescribeContainerGroupMetricContainer2 `json:"Container" xml:"Container"`
}

type DescribeContainerGroupMetricContainer2 struct {
	Name   string                              `json:"Name" xml:"Name"`
	CPU    DescribeContainerGroupMetricCPU2    `json:"CPU" xml:"CPU"`
	Memory DescribeContainerGroupMetricMemory2 `json:"Memory" xml:"Memory"`
}

type DescribeContainerGroupMetricCPU2 struct {
	UsageNanoCores       int64 `json:"UsageNanoCores" xml:"UsageNanoCores"`
	UsageCoreNanoSeconds int64 `json:"UsageCoreNanoSeconds" xml:"UsageCoreNanoSeconds"`
	Load                 int64 `json:"Load" xml:"Load"`
	Limit                int64 `json:"Limit" xml:"Limit"`
}

type DescribeContainerGroupMetricMemory2 struct {
	AvailableBytes int64 `json:"AvailableBytes" xml:"AvailableBytes"`
	UsageBytes     int64 `json:"UsageBytes" xml:"UsageBytes"`
	Cache          int64 `json:"Cache" xml:"Cache"`
	WorkingSet     int64 `json:"WorkingSet" xml:"WorkingSet"`
	Rss            int64 `json:"Rss" xml:"Rss"`
}

type DescribeContainerGroupMetricCPU1 struct {
	UsageNanoCores       int64 `json:"UsageNanoCores" xml:"UsageNanoCores"`
	UsageCoreNanoSeconds int64 `json:"UsageCoreNanoSeconds" xml:"UsageCoreNanoSeconds"`
	Load                 int64 `json:"Load" xml:"Load"`
	Limit                int64 `json:"Limit" xml:"Limit"`
}

type DescribeContainerGroupMetricMemory1 struct {
	AvailableBytes int64 `json:"AvailableBytes" xml:"AvailableBytes"`
	UsageBytes     int64 `json:"UsageBytes" xml:"UsageBytes"`
	Cache          int64 `json:"Cache" xml:"Cache"`
	WorkingSet     int64 `json:"WorkingSet" xml:"WorkingSet"`
	Rss            int64 `json:"Rss" xml:"Rss"`
}

type DescribeContainerGroupMetricNetwork1 struct {
	Interfaces []DescribeContainerGroupMetricInterfaces2 `json:"Interfaces" xml:"Interfaces"`
}

type DescribeContainerGroupMetricInterfaces2 struct {
	Interface []DescribeContainerGroupMetricInterface3 `json:"Interface" xml:"Interface"`
}

type DescribeContainerGroupMetricInterface3 struct {
	TxBytes  int64  `json:"TxBytes" xml:"TxBytes"`
	RxBytes  int64  `json:"RxBytes" xml:"RxBytes"`
	TxErrors int64  `json:"TxErrors" xml:"TxErrors"`
	RxErrors int64  `json:"RxErrors" xml:"RxErrors"`
	Name     string `json:"Name" xml:"Name"`
}

// CreateDescribeContainerGroupMetricRequest creates a request to invoke DescribeContainerGroupMetric API
func CreateDescribeContainerGroupMetricRequest() (request *DescribeContainerGroupMetricRequest) {
	request = &DescribeContainerGroupMetricRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eci", "2018-08-08", "DescribeContainerGroupMetric", "eci", "openAPI")
	return
}

// CreateDescribeContainerGroupMetricResponse creates a response to parse from DescribeContainerGroupMetric response
func CreateDescribeContainerGroupMetricResponse() (response *DescribeContainerGroupMetricResponse) {
	response = &DescribeContainerGroupMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
