package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImage invokes the ehpc.DescribeImage API synchronously
// api document: https://help.aliyun.com/api/ehpc/describeimage.html
func (client *Client) DescribeImage(request *DescribeImageRequest) (response *DescribeImageResponse, err error) {
	response = CreateDescribeImageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImageWithChan invokes the ehpc.DescribeImage API asynchronously
// api document: https://help.aliyun.com/api/ehpc/describeimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeImageWithChan(request *DescribeImageRequest) (<-chan *DescribeImageResponse, <-chan error) {
	responseChan := make(chan *DescribeImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImageWithCallback invokes the ehpc.DescribeImage API asynchronously
// api document: https://help.aliyun.com/api/ehpc/describeimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeImageWithCallback(request *DescribeImageRequest, callback func(response *DescribeImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImageResponse
		var err error
		defer close(result)
		response, err = client.DescribeImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImageRequest is the request struct for api DescribeImage
type DescribeImageRequest struct {
	*requests.RpcRequest
	ContainerType string `position:"Query" name:"ContainerType"`
	ClusterId     string `position:"Query" name:"ClusterId"`
	Repository    string `position:"Query" name:"Repository"`
	ImageTag      string `position:"Query" name:"ImageTag"`
}

// DescribeImageResponse is the response struct for api DescribeImage
type DescribeImageResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	ImageInfo ImageInfo `json:"ImageInfo" xml:"ImageInfo"`
}

// CreateDescribeImageRequest creates a request to invoke DescribeImage API
func CreateDescribeImageRequest() (request *DescribeImageRequest) {
	request = &DescribeImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "DescribeImage", "ehs", "openAPI")
	return
}

// CreateDescribeImageResponse creates a response to parse from DescribeImage response
func CreateDescribeImageResponse() (response *DescribeImageResponse) {
	response = &DescribeImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
