package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EditJobTemplate invokes the ehpc.EditJobTemplate API synchronously
// api document: https://help.aliyun.com/api/ehpc/editjobtemplate.html
func (client *Client) EditJobTemplate(request *EditJobTemplateRequest) (response *EditJobTemplateResponse, err error) {
	response = CreateEditJobTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// EditJobTemplateWithChan invokes the ehpc.EditJobTemplate API asynchronously
// api document: https://help.aliyun.com/api/ehpc/editjobtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EditJobTemplateWithChan(request *EditJobTemplateRequest) (<-chan *EditJobTemplateResponse, <-chan error) {
	responseChan := make(chan *EditJobTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EditJobTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EditJobTemplateWithCallback invokes the ehpc.EditJobTemplate API asynchronously
// api document: https://help.aliyun.com/api/ehpc/editjobtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EditJobTemplateWithCallback(request *EditJobTemplateRequest, callback func(response *EditJobTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EditJobTemplateResponse
		var err error
		defer close(result)
		response, err = client.EditJobTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EditJobTemplateRequest is the request struct for api EditJobTemplate
type EditJobTemplateRequest struct {
	*requests.RpcRequest
	StderrRedirectPath string           `position:"Query" name:"StderrRedirectPath"`
	Variables          string           `position:"Query" name:"Variables"`
	RunasUser          string           `position:"Query" name:"RunasUser"`
	ReRunable          requests.Boolean `position:"Query" name:"ReRunable"`
	TemplateId         string           `position:"Query" name:"TemplateId"`
	Priority           requests.Integer `position:"Query" name:"Priority"`
	CommandLine        string           `position:"Query" name:"CommandLine"`
	ArrayRequest       string           `position:"Query" name:"ArrayRequest"`
	PackagePath        string           `position:"Query" name:"PackagePath"`
	Name               string           `position:"Query" name:"Name"`
	StdoutRedirectPath string           `position:"Query" name:"StdoutRedirectPath"`
}

// EditJobTemplateResponse is the response struct for api EditJobTemplate
type EditJobTemplateResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TemplateId string `json:"TemplateId" xml:"TemplateId"`
}

// CreateEditJobTemplateRequest creates a request to invoke EditJobTemplate API
func CreateEditJobTemplateRequest() (request *EditJobTemplateRequest) {
	request = &EditJobTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "EditJobTemplate", "ehs", "openAPI")
	return
}

// CreateEditJobTemplateResponse creates a response to parse from EditJobTemplate response
func CreateEditJobTemplateResponse() (response *EditJobTemplateResponse) {
	response = &EditJobTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
