package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPlugins invokes the elasticsearch.ListPlugins API synchronously
// api document: https://help.aliyun.com/api/elasticsearch/listplugins.html
func (client *Client) ListPlugins(request *ListPluginsRequest) (response *ListPluginsResponse, err error) {
	response = CreateListPluginsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPluginsWithChan invokes the elasticsearch.ListPlugins API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/listplugins.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPluginsWithChan(request *ListPluginsRequest) (<-chan *ListPluginsResponse, <-chan error) {
	responseChan := make(chan *ListPluginsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPlugins(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPluginsWithCallback invokes the elasticsearch.ListPlugins API asynchronously
// api document: https://help.aliyun.com/api/elasticsearch/listplugins.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPluginsWithCallback(request *ListPluginsRequest, callback func(response *ListPluginsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPluginsResponse
		var err error
		defer close(result)
		response, err = client.ListPlugins(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPluginsRequest is the request struct for api ListPlugins
type ListPluginsRequest struct {
	*requests.RoaRequest
	InstanceId string           `position:"Path" name:"InstanceId"`
	Size       requests.Integer `position:"Query" name:"size"`
	Name       string           `position:"Query" name:"name"`
	Page       string           `position:"Query" name:"page"`
	Source     string           `position:"Query" name:"source"`
}

// ListPluginsResponse is the response struct for api ListPlugins
type ListPluginsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Headers   Headers      `json:"Headers" xml:"Headers"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListPluginsRequest creates a request to invoke ListPlugins API
func CreateListPluginsRequest() (request *ListPluginsRequest) {
	request = &ListPluginsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListPlugins", "/openapi/instances/[InstanceId]/plugins", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListPluginsResponse creates a response to parse from ListPlugins response
func CreateListPluginsResponse() (response *ListPluginsResponse) {
	response = &ListPluginsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
