package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreDescribeDataSource invokes the emr.MetastoreDescribeDataSource API synchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribedatasource.html
func (client *Client) MetastoreDescribeDataSource(request *MetastoreDescribeDataSourceRequest) (response *MetastoreDescribeDataSourceResponse, err error) {
	response = CreateMetastoreDescribeDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreDescribeDataSourceWithChan invokes the emr.MetastoreDescribeDataSource API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribedatasource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDescribeDataSourceWithChan(request *MetastoreDescribeDataSourceRequest) (<-chan *MetastoreDescribeDataSourceResponse, <-chan error) {
	responseChan := make(chan *MetastoreDescribeDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreDescribeDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreDescribeDataSourceWithCallback invokes the emr.MetastoreDescribeDataSource API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribedatasource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDescribeDataSourceWithCallback(request *MetastoreDescribeDataSourceRequest, callback func(response *MetastoreDescribeDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreDescribeDataSourceResponse
		var err error
		defer close(result)
		response, err = client.MetastoreDescribeDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreDescribeDataSourceRequest is the request struct for api MetastoreDescribeDataSource
type MetastoreDescribeDataSourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DataSourceId    string           `position:"Query" name:"DataSourceId"`
}

// MetastoreDescribeDataSourceResponse is the response struct for api MetastoreDescribeDataSource
type MetastoreDescribeDataSourceResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	DataSource DataSource `json:"DataSource" xml:"DataSource"`
}

// CreateMetastoreDescribeDataSourceRequest creates a request to invoke MetastoreDescribeDataSource API
func CreateMetastoreDescribeDataSourceRequest() (request *MetastoreDescribeDataSourceRequest) {
	request = &MetastoreDescribeDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreDescribeDataSource", "emr", "openAPI")
	return
}

// CreateMetastoreDescribeDataSourceResponse creates a response to parse from MetastoreDescribeDataSource response
func CreateMetastoreDescribeDataSourceResponse() (response *MetastoreDescribeDataSourceResponse) {
	response = &MetastoreDescribeDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
