package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreDescribeTable invokes the emr.MetastoreDescribeTable API synchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribetable.html
func (client *Client) MetastoreDescribeTable(request *MetastoreDescribeTableRequest) (response *MetastoreDescribeTableResponse, err error) {
	response = CreateMetastoreDescribeTableResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreDescribeTableWithChan invokes the emr.MetastoreDescribeTable API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribetable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDescribeTableWithChan(request *MetastoreDescribeTableRequest) (<-chan *MetastoreDescribeTableResponse, <-chan error) {
	responseChan := make(chan *MetastoreDescribeTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreDescribeTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreDescribeTableWithCallback invokes the emr.MetastoreDescribeTable API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredescribetable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDescribeTableWithCallback(request *MetastoreDescribeTableRequest, callback func(response *MetastoreDescribeTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreDescribeTableResponse
		var err error
		defer close(result)
		response, err = client.MetastoreDescribeTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreDescribeTableRequest is the request struct for api MetastoreDescribeTable
type MetastoreDescribeTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	Id              string           `position:"Query" name:"Id"`
	TableName       string           `position:"Query" name:"TableName"`
	DatabaseId      string           `position:"Query" name:"DatabaseId"`
}

// MetastoreDescribeTableResponse is the response struct for api MetastoreDescribeTable
type MetastoreDescribeTableResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	Id                    string                `json:"Id" xml:"Id"`
	DatabaseId            string                `json:"DatabaseId" xml:"DatabaseId"`
	ClusterBizId          string                `json:"ClusterBizId" xml:"ClusterBizId"`
	ClusterName           string                `json:"ClusterName" xml:"ClusterName"`
	CreateTime            int                   `json:"CreateTime" xml:"CreateTime"`
	LastAccessTime        int                   `json:"LastAccessTime" xml:"LastAccessTime"`
	LocationUri           string                `json:"LocationUri" xml:"LocationUri"`
	InputFormat           string                `json:"InputFormat" xml:"InputFormat"`
	OutputFormat          string                `json:"OutputFormat" xml:"OutputFormat"`
	Compressed            bool                  `json:"Compressed" xml:"Compressed"`
	SerializationLib      string                `json:"SerializationLib" xml:"SerializationLib"`
	TableName             string                `json:"TableName" xml:"TableName"`
	DbName                string                `json:"DbName" xml:"DbName"`
	Owner                 string                `json:"Owner" xml:"Owner"`
	TableComment          string                `json:"TableComment" xml:"TableComment"`
	TableType             string                `json:"TableType" xml:"TableType"`
	Creator               string                `json:"Creator" xml:"Creator"`
	FieldDelimiter        string                `json:"FieldDelimiter" xml:"FieldDelimiter"`
	Columns               Columns               `json:"Columns" xml:"Columns"`
	PartitionColumns      PartitionColumns      `json:"PartitionColumns" xml:"PartitionColumns"`
	SerdeParameters       SerdeParameters       `json:"SerdeParameters" xml:"SerdeParameters"`
	StorageDescParameters StorageDescParameters `json:"StorageDescParameters" xml:"StorageDescParameters"`
	TableParameters       TableParameters       `json:"TableParameters" xml:"TableParameters"`
}

// CreateMetastoreDescribeTableRequest creates a request to invoke MetastoreDescribeTable API
func CreateMetastoreDescribeTableRequest() (request *MetastoreDescribeTableRequest) {
	request = &MetastoreDescribeTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreDescribeTable", "emr", "openAPI")
	return
}

// CreateMetastoreDescribeTableResponse creates a response to parse from MetastoreDescribeTable response
func CreateMetastoreDescribeTableResponse() (response *MetastoreDescribeTableResponse) {
	response = &MetastoreDescribeTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
