package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetryExecutionPlanInstance invokes the emr.RetryExecutionPlanInstance API synchronously
// api document: https://help.aliyun.com/api/emr/retryexecutionplaninstance.html
func (client *Client) RetryExecutionPlanInstance(request *RetryExecutionPlanInstanceRequest) (response *RetryExecutionPlanInstanceResponse, err error) {
	response = CreateRetryExecutionPlanInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RetryExecutionPlanInstanceWithChan invokes the emr.RetryExecutionPlanInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/retryexecutionplaninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RetryExecutionPlanInstanceWithChan(request *RetryExecutionPlanInstanceRequest) (<-chan *RetryExecutionPlanInstanceResponse, <-chan error) {
	responseChan := make(chan *RetryExecutionPlanInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetryExecutionPlanInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetryExecutionPlanInstanceWithCallback invokes the emr.RetryExecutionPlanInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/retryexecutionplaninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RetryExecutionPlanInstanceWithCallback(request *RetryExecutionPlanInstanceRequest, callback func(response *RetryExecutionPlanInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetryExecutionPlanInstanceResponse
		var err error
		defer close(result)
		response, err = client.RetryExecutionPlanInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetryExecutionPlanInstanceRequest is the request struct for api RetryExecutionPlanInstance
type RetryExecutionPlanInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Arguments       string           `position:"Query" name:"Arguments"`
	Id              string           `position:"Query" name:"Id"`
	RerunFail       requests.Boolean `position:"Query" name:"RerunFail"`
}

// RetryExecutionPlanInstanceResponse is the response struct for api RetryExecutionPlanInstance
type RetryExecutionPlanInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRetryExecutionPlanInstanceRequest creates a request to invoke RetryExecutionPlanInstance API
func CreateRetryExecutionPlanInstanceRequest() (request *RetryExecutionPlanInstanceRequest) {
	request = &RetryExecutionPlanInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RetryExecutionPlanInstance", "emr", "openAPI")
	return
}

// CreateRetryExecutionPlanInstanceResponse creates a response to parse from RetryExecutionPlanInstance response
func CreateRetryExecutionPlanInstanceResponse() (response *RetryExecutionPlanInstanceResponse) {
	response = &RetryExecutionPlanInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
