package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SuspendExecutionPlanScheduler invokes the emr.SuspendExecutionPlanScheduler API synchronously
// api document: https://help.aliyun.com/api/emr/suspendexecutionplanscheduler.html
func (client *Client) SuspendExecutionPlanScheduler(request *SuspendExecutionPlanSchedulerRequest) (response *SuspendExecutionPlanSchedulerResponse, err error) {
	response = CreateSuspendExecutionPlanSchedulerResponse()
	err = client.DoAction(request, response)
	return
}

// SuspendExecutionPlanSchedulerWithChan invokes the emr.SuspendExecutionPlanScheduler API asynchronously
// api document: https://help.aliyun.com/api/emr/suspendexecutionplanscheduler.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SuspendExecutionPlanSchedulerWithChan(request *SuspendExecutionPlanSchedulerRequest) (<-chan *SuspendExecutionPlanSchedulerResponse, <-chan error) {
	responseChan := make(chan *SuspendExecutionPlanSchedulerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SuspendExecutionPlanScheduler(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SuspendExecutionPlanSchedulerWithCallback invokes the emr.SuspendExecutionPlanScheduler API asynchronously
// api document: https://help.aliyun.com/api/emr/suspendexecutionplanscheduler.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SuspendExecutionPlanSchedulerWithCallback(request *SuspendExecutionPlanSchedulerRequest, callback func(response *SuspendExecutionPlanSchedulerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SuspendExecutionPlanSchedulerResponse
		var err error
		defer close(result)
		response, err = client.SuspendExecutionPlanScheduler(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SuspendExecutionPlanSchedulerRequest is the request struct for api SuspendExecutionPlanScheduler
type SuspendExecutionPlanSchedulerRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// SuspendExecutionPlanSchedulerResponse is the response struct for api SuspendExecutionPlanScheduler
type SuspendExecutionPlanSchedulerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSuspendExecutionPlanSchedulerRequest creates a request to invoke SuspendExecutionPlanScheduler API
func CreateSuspendExecutionPlanSchedulerRequest() (request *SuspendExecutionPlanSchedulerRequest) {
	request = &SuspendExecutionPlanSchedulerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "SuspendExecutionPlanScheduler", "emr", "openAPI")
	return
}

// CreateSuspendExecutionPlanSchedulerResponse creates a response to parse from SuspendExecutionPlanScheduler response
func CreateSuspendExecutionPlanSchedulerResponse() (response *SuspendExecutionPlanSchedulerResponse) {
	response = &SuspendExecutionPlanSchedulerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
