package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFaceSearchUser invokes the imm.DeleteFaceSearchUser API synchronously
// api document: https://help.aliyun.com/api/imm/deletefacesearchuser.html
func (client *Client) DeleteFaceSearchUser(request *DeleteFaceSearchUserRequest) (response *DeleteFaceSearchUserResponse, err error) {
	response = CreateDeleteFaceSearchUserResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFaceSearchUserWithChan invokes the imm.DeleteFaceSearchUser API asynchronously
// api document: https://help.aliyun.com/api/imm/deletefacesearchuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFaceSearchUserWithChan(request *DeleteFaceSearchUserRequest) (<-chan *DeleteFaceSearchUserResponse, <-chan error) {
	responseChan := make(chan *DeleteFaceSearchUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFaceSearchUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFaceSearchUserWithCallback invokes the imm.DeleteFaceSearchUser API asynchronously
// api document: https://help.aliyun.com/api/imm/deletefacesearchuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFaceSearchUserWithCallback(request *DeleteFaceSearchUserRequest, callback func(response *DeleteFaceSearchUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFaceSearchUserResponse
		var err error
		defer close(result)
		response, err = client.DeleteFaceSearchUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFaceSearchUserRequest is the request struct for api DeleteFaceSearchUser
type DeleteFaceSearchUserRequest struct {
	*requests.RpcRequest
	Project   string `position:"Query" name:"Project"`
	GroupName string `position:"Query" name:"GroupName"`
	User      string `position:"Query" name:"User"`
}

// DeleteFaceSearchUserResponse is the response struct for api DeleteFaceSearchUser
type DeleteFaceSearchUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFaceSearchUserRequest creates a request to invoke DeleteFaceSearchUser API
func CreateDeleteFaceSearchUserRequest() (request *DeleteFaceSearchUserRequest) {
	request = &DeleteFaceSearchUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DeleteFaceSearchUser", "imm", "openAPI")
	return
}

// CreateDeleteFaceSearchUserResponse creates a response to parse from DeleteFaceSearchUser response
func CreateDeleteFaceSearchUserResponse() (response *DeleteFaceSearchUserResponse) {
	response = &DeleteFaceSearchUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
