package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectLogo invokes the imm.DetectLogo API synchronously
// api document: https://help.aliyun.com/api/imm/detectlogo.html
func (client *Client) DetectLogo(request *DetectLogoRequest) (response *DetectLogoResponse, err error) {
	response = CreateDetectLogoResponse()
	err = client.DoAction(request, response)
	return
}

// DetectLogoWithChan invokes the imm.DetectLogo API asynchronously
// api document: https://help.aliyun.com/api/imm/detectlogo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetectLogoWithChan(request *DetectLogoRequest) (<-chan *DetectLogoResponse, <-chan error) {
	responseChan := make(chan *DetectLogoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectLogo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectLogoWithCallback invokes the imm.DetectLogo API asynchronously
// api document: https://help.aliyun.com/api/imm/detectlogo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetectLogoWithCallback(request *DetectLogoRequest, callback func(response *DetectLogoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectLogoResponse
		var err error
		defer close(result)
		response, err = client.DetectLogo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectLogoRequest is the request struct for api DetectLogo
type DetectLogoRequest struct {
	*requests.RpcRequest
	SrcUris string `position:"Query" name:"SrcUris"`
	Project string `position:"Query" name:"Project"`
}

// DetectLogoResponse is the response struct for api DetectLogo
type DetectLogoResponse struct {
	*responses.BaseResponse
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	SrcUris        []string             `json:"SrcUris" xml:"SrcUris"`
	SuccessDetails []SuccessDetailsItem `json:"SuccessDetails" xml:"SuccessDetails"`
	FailDetails    []FailDetailsItem    `json:"FailDetails" xml:"FailDetails"`
}

// CreateDetectLogoRequest creates a request to invoke DetectLogo API
func CreateDetectLogoRequest() (request *DetectLogoRequest) {
	request = &DetectLogoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DetectLogo", "imm", "openAPI")
	return
}

// CreateDetectLogoResponse creates a response to parse from DetectLogo response
func CreateDetectLogoResponse() (response *DetectLogoResponse) {
	response = &DetectLogoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
