package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFaceSearchGroup invokes the imm.GetFaceSearchGroup API synchronously
// api document: https://help.aliyun.com/api/imm/getfacesearchgroup.html
func (client *Client) GetFaceSearchGroup(request *GetFaceSearchGroupRequest) (response *GetFaceSearchGroupResponse, err error) {
	response = CreateGetFaceSearchGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetFaceSearchGroupWithChan invokes the imm.GetFaceSearchGroup API asynchronously
// api document: https://help.aliyun.com/api/imm/getfacesearchgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetFaceSearchGroupWithChan(request *GetFaceSearchGroupRequest) (<-chan *GetFaceSearchGroupResponse, <-chan error) {
	responseChan := make(chan *GetFaceSearchGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFaceSearchGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFaceSearchGroupWithCallback invokes the imm.GetFaceSearchGroup API asynchronously
// api document: https://help.aliyun.com/api/imm/getfacesearchgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetFaceSearchGroupWithCallback(request *GetFaceSearchGroupRequest, callback func(response *GetFaceSearchGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFaceSearchGroupResponse
		var err error
		defer close(result)
		response, err = client.GetFaceSearchGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFaceSearchGroupRequest is the request struct for api GetFaceSearchGroup
type GetFaceSearchGroupRequest struct {
	*requests.RpcRequest
	Project   string `position:"Query" name:"Project"`
	GroupName string `position:"Query" name:"GroupName"`
}

// GetFaceSearchGroupResponse is the response struct for api GetFaceSearchGroup
type GetFaceSearchGroupResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	GroupName  string `json:"GroupName" xml:"GroupName"`
	Count      int    `json:"Count" xml:"Count"`
	Status     string `json:"Status" xml:"Status"`
	CreateTime string `json:"CreateTime" xml:"CreateTime"`
	ModifyTime string `json:"ModifyTime" xml:"ModifyTime"`
	GroupId    string `json:"GroupId" xml:"GroupId"`
}

// CreateGetFaceSearchGroupRequest creates a request to invoke GetFaceSearchGroup API
func CreateGetFaceSearchGroupRequest() (request *GetFaceSearchGroupRequest) {
	request = &GetFaceSearchGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "GetFaceSearchGroup", "imm", "openAPI")
	return
}

// CreateGetFaceSearchGroupResponse creates a response to parse from GetFaceSearchGroup response
func CreateGetFaceSearchGroupResponse() (response *GetFaceSearchGroupResponse) {
	response = &GetFaceSearchGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
