package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PhotoProcess invokes the imm.PhotoProcess API synchronously
// api document: https://help.aliyun.com/api/imm/photoprocess.html
func (client *Client) PhotoProcess(request *PhotoProcessRequest) (response *PhotoProcessResponse, err error) {
	response = CreatePhotoProcessResponse()
	err = client.DoAction(request, response)
	return
}

// PhotoProcessWithChan invokes the imm.PhotoProcess API asynchronously
// api document: https://help.aliyun.com/api/imm/photoprocess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PhotoProcessWithChan(request *PhotoProcessRequest) (<-chan *PhotoProcessResponse, <-chan error) {
	responseChan := make(chan *PhotoProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PhotoProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PhotoProcessWithCallback invokes the imm.PhotoProcess API asynchronously
// api document: https://help.aliyun.com/api/imm/photoprocess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PhotoProcessWithCallback(request *PhotoProcessRequest, callback func(response *PhotoProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PhotoProcessResponse
		var err error
		defer close(result)
		response, err = client.PhotoProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PhotoProcessRequest is the request struct for api PhotoProcess
type PhotoProcessRequest struct {
	*requests.RpcRequest
	NotifyTopicName string `position:"Query" name:"NotifyTopicName"`
	NotifyEndpoint  string `position:"Query" name:"NotifyEndpoint"`
	Project         string `position:"Query" name:"Project"`
	ExternalID      string `position:"Query" name:"ExternalID"`
	SrcUri          string `position:"Query" name:"SrcUri"`
	Style           string `position:"Query" name:"Style"`
	TgtUri          string `position:"Query" name:"TgtUri"`
}

// PhotoProcessResponse is the response struct for api PhotoProcess
type PhotoProcessResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TaskId     string `json:"TaskId" xml:"TaskId"`
	TgtLoc     string `json:"TgtLoc" xml:"TgtLoc"`
	Status     string `json:"Status" xml:"Status"`
	CreateTime string `json:"CreateTime" xml:"CreateTime"`
	Percent    int    `json:"Percent" xml:"Percent"`
}

// CreatePhotoProcessRequest creates a request to invoke PhotoProcess API
func CreatePhotoProcessRequest() (request *PhotoProcessRequest) {
	request = &PhotoProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "PhotoProcess", "imm", "openAPI")
	return
}

// CreatePhotoProcessResponse creates a response to parse from PhotoProcess response
func CreatePhotoProcessResponse() (response *PhotoProcessResponse) {
	response = &PhotoProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
