package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchAddDeviceGroupRelations invokes the iot.BatchAddDeviceGroupRelations API synchronously
// api document: https://help.aliyun.com/api/iot/batchadddevicegrouprelations.html
func (client *Client) BatchAddDeviceGroupRelations(request *BatchAddDeviceGroupRelationsRequest) (response *BatchAddDeviceGroupRelationsResponse, err error) {
	response = CreateBatchAddDeviceGroupRelationsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchAddDeviceGroupRelationsWithChan invokes the iot.BatchAddDeviceGroupRelations API asynchronously
// api document: https://help.aliyun.com/api/iot/batchadddevicegrouprelations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchAddDeviceGroupRelationsWithChan(request *BatchAddDeviceGroupRelationsRequest) (<-chan *BatchAddDeviceGroupRelationsResponse, <-chan error) {
	responseChan := make(chan *BatchAddDeviceGroupRelationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchAddDeviceGroupRelations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchAddDeviceGroupRelationsWithCallback invokes the iot.BatchAddDeviceGroupRelations API asynchronously
// api document: https://help.aliyun.com/api/iot/batchadddevicegrouprelations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchAddDeviceGroupRelationsWithCallback(request *BatchAddDeviceGroupRelationsRequest, callback func(response *BatchAddDeviceGroupRelationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchAddDeviceGroupRelationsResponse
		var err error
		defer close(result)
		response, err = client.BatchAddDeviceGroupRelations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchAddDeviceGroupRelationsRequest is the request struct for api BatchAddDeviceGroupRelations
type BatchAddDeviceGroupRelationsRequest struct {
	*requests.RpcRequest
	IotInstanceId string                                `position:"Query" name:"IotInstanceId"`
	GroupId       string                                `position:"Query" name:"GroupId"`
	Device        *[]BatchAddDeviceGroupRelationsDevice `position:"Query" name:"Device"  type:"Repeated"`
}

// BatchAddDeviceGroupRelationsDevice is a repeated param struct in BatchAddDeviceGroupRelationsRequest
type BatchAddDeviceGroupRelationsDevice struct {
	DeviceName string `name:"DeviceName"`
	ProductKey string `name:"ProductKey"`
}

// BatchAddDeviceGroupRelationsResponse is the response struct for api BatchAddDeviceGroupRelations
type BatchAddDeviceGroupRelationsResponse struct {
	*responses.BaseResponse
	RequestId                      string `json:"RequestId" xml:"RequestId"`
	Success                        bool   `json:"Success" xml:"Success"`
	Code                           string `json:"Code" xml:"Code"`
	ValidDeviceCount               int    `json:"ValidDeviceCount" xml:"ValidDeviceCount"`
	ExceedTenGroupDeviceCount      int    `json:"ExceedTenGroupDeviceCount" xml:"ExceedTenGroupDeviceCount"`
	AlreadyRelatedGroupDeviceCount int    `json:"AlreadyRelatedGroupDeviceCount" xml:"AlreadyRelatedGroupDeviceCount"`
	SuccessAddedDeviceCount        int    `json:"SuccessAddedDeviceCount" xml:"SuccessAddedDeviceCount"`
	ErrorMessage                   string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateBatchAddDeviceGroupRelationsRequest creates a request to invoke BatchAddDeviceGroupRelations API
func CreateBatchAddDeviceGroupRelationsRequest() (request *BatchAddDeviceGroupRelationsRequest) {
	request = &BatchAddDeviceGroupRelationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchAddDeviceGroupRelations", "iot", "openAPI")
	return
}

// CreateBatchAddDeviceGroupRelationsResponse creates a response to parse from BatchAddDeviceGroupRelations response
func CreateBatchAddDeviceGroupRelationsResponse() (response *BatchAddDeviceGroupRelationsResponse) {
	response = &BatchAddDeviceGroupRelationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
