package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTagAttribute invokes the ivision.ModifyTagAttribute API synchronously
// api document: https://help.aliyun.com/api/ivision/modifytagattribute.html
func (client *Client) ModifyTagAttribute(request *ModifyTagAttributeRequest) (response *ModifyTagAttributeResponse, err error) {
	response = CreateModifyTagAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTagAttributeWithChan invokes the ivision.ModifyTagAttribute API asynchronously
// api document: https://help.aliyun.com/api/ivision/modifytagattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyTagAttributeWithChan(request *ModifyTagAttributeRequest) (<-chan *ModifyTagAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyTagAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTagAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTagAttributeWithCallback invokes the ivision.ModifyTagAttribute API asynchronously
// api document: https://help.aliyun.com/api/ivision/modifytagattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyTagAttributeWithCallback(request *ModifyTagAttributeRequest, callback func(response *ModifyTagAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTagAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyTagAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTagAttributeRequest is the request struct for api ModifyTagAttribute
type ModifyTagAttributeRequest struct {
	*requests.RpcRequest
	Description string           `position:"Query" name:"Description"`
	ProjectId   string           `position:"Query" name:"ProjectId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	TagId       string           `position:"Query" name:"TagId"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	Name        string           `position:"Query" name:"Name"`
}

// ModifyTagAttributeResponse is the response struct for api ModifyTagAttribute
type ModifyTagAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Tag       Tag    `json:"Tag" xml:"Tag"`
}

// CreateModifyTagAttributeRequest creates a request to invoke ModifyTagAttribute API
func CreateModifyTagAttributeRequest() (request *ModifyTagAttributeRequest) {
	request = &ModifyTagAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "ModifyTagAttribute", "ivision", "openAPI")
	return
}

// CreateModifyTagAttributeResponse creates a response to parse from ModifyTagAttribute response
func CreateModifyTagAttributeResponse() (response *ModifyTagAttributeResponse) {
	response = &ModifyTagAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
