package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRecord invokes the live.DescribeRecord API synchronously
// api document: https://help.aliyun.com/api/live/describerecord.html
func (client *Client) DescribeRecord(request *DescribeRecordRequest) (response *DescribeRecordResponse, err error) {
	response = CreateDescribeRecordResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRecordWithChan invokes the live.DescribeRecord API asynchronously
// api document: https://help.aliyun.com/api/live/describerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRecordWithChan(request *DescribeRecordRequest) (<-chan *DescribeRecordResponse, <-chan error) {
	responseChan := make(chan *DescribeRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRecordWithCallback invokes the live.DescribeRecord API asynchronously
// api document: https://help.aliyun.com/api/live/describerecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeRecordWithCallback(request *DescribeRecordRequest, callback func(response *DescribeRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRecordResponse
		var err error
		defer close(result)
		response, err = client.DescribeRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRecordRequest is the request struct for api DescribeRecord
type DescribeRecordRequest struct {
	*requests.RpcRequest
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	RecordId string           `position:"Query" name:"RecordId"`
	AppId    string           `position:"Query" name:"AppId"`
}

// DescribeRecordResponse is the response struct for api DescribeRecord
type DescribeRecordResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	RecordId        string `json:"RecordId" xml:"RecordId"`
	AppId           string `json:"AppId" xml:"AppId"`
	BoardId         int    `json:"BoardId" xml:"BoardId"`
	RecordStartTime int64  `json:"RecordStartTime" xml:"RecordStartTime"`
	StartTime       int64  `json:"StartTime" xml:"StartTime"`
	EndTime         int64  `json:"EndTime" xml:"EndTime"`
	State           int    `json:"State" xml:"State"`
	OssPath         string `json:"OssPath" xml:"OssPath"`
	OssBucket       string `json:"OssBucket" xml:"OssBucket"`
	OssEndpoint     string `json:"OssEndpoint" xml:"OssEndpoint"`
}

// CreateDescribeRecordRequest creates a request to invoke DescribeRecord API
func CreateDescribeRecordRequest() (request *DescribeRecordRequest) {
	request = &DescribeRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeRecord", "live", "openAPI")
	return
}

// CreateDescribeRecordResponse creates a response to parse from DescribeRecord response
func CreateDescribeRecordResponse() (response *DescribeRecordResponse) {
	response = &DescribeRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
