package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EffectCasterVideoResource invokes the live.EffectCasterVideoResource API synchronously
// api document: https://help.aliyun.com/api/live/effectcastervideoresource.html
func (client *Client) EffectCasterVideoResource(request *EffectCasterVideoResourceRequest) (response *EffectCasterVideoResourceResponse, err error) {
	response = CreateEffectCasterVideoResourceResponse()
	err = client.DoAction(request, response)
	return
}

// EffectCasterVideoResourceWithChan invokes the live.EffectCasterVideoResource API asynchronously
// api document: https://help.aliyun.com/api/live/effectcastervideoresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EffectCasterVideoResourceWithChan(request *EffectCasterVideoResourceRequest) (<-chan *EffectCasterVideoResourceResponse, <-chan error) {
	responseChan := make(chan *EffectCasterVideoResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EffectCasterVideoResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EffectCasterVideoResourceWithCallback invokes the live.EffectCasterVideoResource API asynchronously
// api document: https://help.aliyun.com/api/live/effectcastervideoresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EffectCasterVideoResourceWithCallback(request *EffectCasterVideoResourceRequest, callback func(response *EffectCasterVideoResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EffectCasterVideoResourceResponse
		var err error
		defer close(result)
		response, err = client.EffectCasterVideoResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EffectCasterVideoResourceRequest is the request struct for api EffectCasterVideoResource
type EffectCasterVideoResourceRequest struct {
	*requests.RpcRequest
	ResourceId string           `position:"Query" name:"ResourceId"`
	CasterId   string           `position:"Query" name:"CasterId"`
	SceneId    string           `position:"Query" name:"SceneId"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// EffectCasterVideoResourceResponse is the response struct for api EffectCasterVideoResource
type EffectCasterVideoResourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEffectCasterVideoResourceRequest creates a request to invoke EffectCasterVideoResource API
func CreateEffectCasterVideoResourceRequest() (request *EffectCasterVideoResourceRequest) {
	request = &EffectCasterVideoResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "EffectCasterVideoResource", "live", "openAPI")
	return
}

// CreateEffectCasterVideoResourceResponse creates a response to parse from EffectCasterVideoResource response
func CreateEffectCasterVideoResourceResponse() (response *EffectCasterVideoResourceResponse) {
	response = &EffectCasterVideoResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
