package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ForbidPushStream invokes the live.ForbidPushStream API synchronously
// api document: https://help.aliyun.com/api/live/forbidpushstream.html
func (client *Client) ForbidPushStream(request *ForbidPushStreamRequest) (response *ForbidPushStreamResponse, err error) {
	response = CreateForbidPushStreamResponse()
	err = client.DoAction(request, response)
	return
}

// ForbidPushStreamWithChan invokes the live.ForbidPushStream API asynchronously
// api document: https://help.aliyun.com/api/live/forbidpushstream.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ForbidPushStreamWithChan(request *ForbidPushStreamRequest) (<-chan *ForbidPushStreamResponse, <-chan error) {
	responseChan := make(chan *ForbidPushStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ForbidPushStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ForbidPushStreamWithCallback invokes the live.ForbidPushStream API asynchronously
// api document: https://help.aliyun.com/api/live/forbidpushstream.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ForbidPushStreamWithCallback(request *ForbidPushStreamRequest, callback func(response *ForbidPushStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ForbidPushStreamResponse
		var err error
		defer close(result)
		response, err = client.ForbidPushStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ForbidPushStreamRequest is the request struct for api ForbidPushStream
type ForbidPushStreamRequest struct {
	*requests.RpcRequest
	UserData string           `position:"Query" name:"UserData"`
	EndTime  string           `position:"Query" name:"EndTime"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	RoomId   string           `position:"Query" name:"RoomId"`
	AppId    string           `position:"Query" name:"AppId"`
}

// ForbidPushStreamResponse is the response struct for api ForbidPushStream
type ForbidPushStreamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateForbidPushStreamRequest creates a request to invoke ForbidPushStream API
func CreateForbidPushStreamRequest() (request *ForbidPushStreamRequest) {
	request = &ForbidPushStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ForbidPushStream", "live", "openAPI")
	return
}

// CreateForbidPushStreamResponse creates a response to parse from ForbidPushStream response
func CreateForbidPushStreamResponse() (response *ForbidPushStreamResponse) {
	response = &ForbidPushStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
