package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetBoardCallback invokes the live.SetBoardCallback API synchronously
// api document: https://help.aliyun.com/api/live/setboardcallback.html
func (client *Client) SetBoardCallback(request *SetBoardCallbackRequest) (response *SetBoardCallbackResponse, err error) {
	response = CreateSetBoardCallbackResponse()
	err = client.DoAction(request, response)
	return
}

// SetBoardCallbackWithChan invokes the live.SetBoardCallback API asynchronously
// api document: https://help.aliyun.com/api/live/setboardcallback.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetBoardCallbackWithChan(request *SetBoardCallbackRequest) (<-chan *SetBoardCallbackResponse, <-chan error) {
	responseChan := make(chan *SetBoardCallbackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetBoardCallback(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetBoardCallbackWithCallback invokes the live.SetBoardCallback API asynchronously
// api document: https://help.aliyun.com/api/live/setboardcallback.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetBoardCallbackWithCallback(request *SetBoardCallbackRequest, callback func(response *SetBoardCallbackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetBoardCallbackResponse
		var err error
		defer close(result)
		response, err = client.SetBoardCallback(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetBoardCallbackRequest is the request struct for api SetBoardCallback
type SetBoardCallbackRequest struct {
	*requests.RpcRequest
	AuthKey        string           `position:"Query" name:"AuthKey"`
	CallbackEnable requests.Integer `position:"Query" name:"CallbackEnable"`
	CallbackEvents string           `position:"Query" name:"CallbackEvents"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	CallbackUri    string           `position:"Query" name:"CallbackUri"`
	AppId          string           `position:"Query" name:"AppId"`
	AuthSwitch     string           `position:"Query" name:"AuthSwitch"`
}

// SetBoardCallbackResponse is the response struct for api SetBoardCallback
type SetBoardCallbackResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetBoardCallbackRequest creates a request to invoke SetBoardCallback API
func CreateSetBoardCallbackRequest() (request *SetBoardCallbackRequest) {
	request = &SetBoardCallbackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SetBoardCallback", "live", "openAPI")
	return
}

// CreateSetBoardCallbackResponse creates a response to parse from SetBoardCallback response
func CreateSetBoardCallbackResponse() (response *SetBoardCallbackResponse) {
	response = &SetBoardCallbackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
