package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetLiveDomainCertificate invokes the live.SetLiveDomainCertificate API synchronously
// api document: https://help.aliyun.com/api/live/setlivedomaincertificate.html
func (client *Client) SetLiveDomainCertificate(request *SetLiveDomainCertificateRequest) (response *SetLiveDomainCertificateResponse, err error) {
	response = CreateSetLiveDomainCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// SetLiveDomainCertificateWithChan invokes the live.SetLiveDomainCertificate API asynchronously
// api document: https://help.aliyun.com/api/live/setlivedomaincertificate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetLiveDomainCertificateWithChan(request *SetLiveDomainCertificateRequest) (<-chan *SetLiveDomainCertificateResponse, <-chan error) {
	responseChan := make(chan *SetLiveDomainCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetLiveDomainCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetLiveDomainCertificateWithCallback invokes the live.SetLiveDomainCertificate API asynchronously
// api document: https://help.aliyun.com/api/live/setlivedomaincertificate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetLiveDomainCertificateWithCallback(request *SetLiveDomainCertificateRequest, callback func(response *SetLiveDomainCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetLiveDomainCertificateResponse
		var err error
		defer close(result)
		response, err = client.SetLiveDomainCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetLiveDomainCertificateRequest is the request struct for api SetLiveDomainCertificate
type SetLiveDomainCertificateRequest struct {
	*requests.RpcRequest
	ForceSet      string           `position:"Query" name:"ForceSet"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	CertType      string           `position:"Query" name:"CertType"`
	SSLPub        string           `position:"Query" name:"SSLPub"`
	CertName      string           `position:"Query" name:"CertName"`
	SSLProtocol   string           `position:"Query" name:"SSLProtocol"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SSLPri        string           `position:"Query" name:"SSLPri"`
}

// SetLiveDomainCertificateResponse is the response struct for api SetLiveDomainCertificate
type SetLiveDomainCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetLiveDomainCertificateRequest creates a request to invoke SetLiveDomainCertificate API
func CreateSetLiveDomainCertificateRequest() (request *SetLiveDomainCertificateRequest) {
	request = &SetLiveDomainCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SetLiveDomainCertificate", "live", "openAPI")
	return
}

// CreateSetLiveDomainCertificateResponse creates a response to parse from SetLiveDomainCertificate response
func CreateSetLiveDomainCertificateResponse() (response *SetLiveDomainCertificateResponse) {
	response = &SetLiveDomainCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
