package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFpCompareJobList invokes the mts.QueryFpCompareJobList API synchronously
// api document: https://help.aliyun.com/api/mts/queryfpcomparejoblist.html
func (client *Client) QueryFpCompareJobList(request *QueryFpCompareJobListRequest) (response *QueryFpCompareJobListResponse, err error) {
	response = CreateQueryFpCompareJobListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFpCompareJobListWithChan invokes the mts.QueryFpCompareJobList API asynchronously
// api document: https://help.aliyun.com/api/mts/queryfpcomparejoblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryFpCompareJobListWithChan(request *QueryFpCompareJobListRequest) (<-chan *QueryFpCompareJobListResponse, <-chan error) {
	responseChan := make(chan *QueryFpCompareJobListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFpCompareJobList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFpCompareJobListWithCallback invokes the mts.QueryFpCompareJobList API asynchronously
// api document: https://help.aliyun.com/api/mts/queryfpcomparejoblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryFpCompareJobListWithCallback(request *QueryFpCompareJobListRequest, callback func(response *QueryFpCompareJobListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFpCompareJobListResponse
		var err error
		defer close(result)
		response, err = client.QueryFpCompareJobList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFpCompareJobListRequest is the request struct for api QueryFpCompareJobList
type QueryFpCompareJobListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	JobIds               string           `position:"Query" name:"JobIds"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryFpCompareJobListResponse is the response struct for api QueryFpCompareJobList
type QueryFpCompareJobListResponse struct {
	*responses.BaseResponse
	RequestId        string                             `json:"RequestId" xml:"RequestId"`
	NonExistIds      NonExistIdsInQueryFpCompareJobList `json:"NonExistIds" xml:"NonExistIds"`
	FpCompareJobList FpCompareJobList                   `json:"FpCompareJobList" xml:"FpCompareJobList"`
}

// CreateQueryFpCompareJobListRequest creates a request to invoke QueryFpCompareJobList API
func CreateQueryFpCompareJobListRequest() (request *QueryFpCompareJobListRequest) {
	request = &QueryFpCompareJobListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryFpCompareJobList", "mts", "openAPI")
	return
}

// CreateQueryFpCompareJobListResponse creates a response to parse from QueryFpCompareJobList response
func CreateQueryFpCompareJobListResponse() (response *QueryFpCompareJobListResponse) {
	response = &QueryFpCompareJobListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
