package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTerrorismJobList invokes the mts.QueryTerrorismJobList API synchronously
// api document: https://help.aliyun.com/api/mts/queryterrorismjoblist.html
func (client *Client) QueryTerrorismJobList(request *QueryTerrorismJobListRequest) (response *QueryTerrorismJobListResponse, err error) {
	response = CreateQueryTerrorismJobListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTerrorismJobListWithChan invokes the mts.QueryTerrorismJobList API asynchronously
// api document: https://help.aliyun.com/api/mts/queryterrorismjoblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTerrorismJobListWithChan(request *QueryTerrorismJobListRequest) (<-chan *QueryTerrorismJobListResponse, <-chan error) {
	responseChan := make(chan *QueryTerrorismJobListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTerrorismJobList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTerrorismJobListWithCallback invokes the mts.QueryTerrorismJobList API asynchronously
// api document: https://help.aliyun.com/api/mts/queryterrorismjoblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTerrorismJobListWithCallback(request *QueryTerrorismJobListRequest, callback func(response *QueryTerrorismJobListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTerrorismJobListResponse
		var err error
		defer close(result)
		response, err = client.QueryTerrorismJobList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTerrorismJobListRequest is the request struct for api QueryTerrorismJobList
type QueryTerrorismJobListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	JobIds               string           `position:"Query" name:"JobIds"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryTerrorismJobListResponse is the response struct for api QueryTerrorismJobList
type QueryTerrorismJobListResponse struct {
	*responses.BaseResponse
	RequestId        string                             `json:"RequestId" xml:"RequestId"`
	NonExistIds      NonExistIdsInQueryTerrorismJobList `json:"NonExistIds" xml:"NonExistIds"`
	TerrorismJobList TerrorismJobList                   `json:"TerrorismJobList" xml:"TerrorismJobList"`
}

// CreateQueryTerrorismJobListRequest creates a request to invoke QueryTerrorismJobList API
func CreateQueryTerrorismJobListRequest() (request *QueryTerrorismJobListRequest) {
	request = &QueryTerrorismJobListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryTerrorismJobList", "mts", "openAPI")
	return
}

// CreateQueryTerrorismJobListResponse creates a response to parse from QueryTerrorismJobList response
func CreateQueryTerrorismJobListResponse() (response *QueryTerrorismJobListResponse) {
	response = &QueryTerrorismJobListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
