package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsDLQMessageResendById invokes the ons.OnsDLQMessageResendById API synchronously
// api document: https://help.aliyun.com/api/ons/onsdlqmessageresendbyid.html
func (client *Client) OnsDLQMessageResendById(request *OnsDLQMessageResendByIdRequest) (response *OnsDLQMessageResendByIdResponse, err error) {
	response = CreateOnsDLQMessageResendByIdResponse()
	err = client.DoAction(request, response)
	return
}

// OnsDLQMessageResendByIdWithChan invokes the ons.OnsDLQMessageResendById API asynchronously
// api document: https://help.aliyun.com/api/ons/onsdlqmessageresendbyid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsDLQMessageResendByIdWithChan(request *OnsDLQMessageResendByIdRequest) (<-chan *OnsDLQMessageResendByIdResponse, <-chan error) {
	responseChan := make(chan *OnsDLQMessageResendByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsDLQMessageResendById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsDLQMessageResendByIdWithCallback invokes the ons.OnsDLQMessageResendById API asynchronously
// api document: https://help.aliyun.com/api/ons/onsdlqmessageresendbyid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsDLQMessageResendByIdWithCallback(request *OnsDLQMessageResendByIdRequest, callback func(response *OnsDLQMessageResendByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsDLQMessageResendByIdResponse
		var err error
		defer close(result)
		response, err = client.OnsDLQMessageResendById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsDLQMessageResendByIdRequest is the request struct for api OnsDLQMessageResendById
type OnsDLQMessageResendByIdRequest struct {
	*requests.RpcRequest
	PreventCache requests.Integer `position:"Query" name:"PreventCache"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	GroupId      string           `position:"Query" name:"GroupId"`
	MsgId        string           `position:"Query" name:"MsgId"`
}

// OnsDLQMessageResendByIdResponse is the response struct for api OnsDLQMessageResendById
type OnsDLQMessageResendByIdResponse struct {
	*responses.BaseResponse
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	HelpUrl   string                        `json:"HelpUrl" xml:"HelpUrl"`
	Data      DataInOnsDLQMessageResendById `json:"Data" xml:"Data"`
}

// CreateOnsDLQMessageResendByIdRequest creates a request to invoke OnsDLQMessageResendById API
func CreateOnsDLQMessageResendByIdRequest() (request *OnsDLQMessageResendByIdRequest) {
	request = &OnsDLQMessageResendByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsDLQMessageResendById", "ons", "openAPI")
	return
}

// CreateOnsDLQMessageResendByIdResponse creates a response to parse from OnsDLQMessageResendById response
func CreateOnsDLQMessageResendByIdResponse() (response *OnsDLQMessageResendByIdResponse) {
	response = &OnsDLQMessageResendByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
