package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsMqttQueryClientByGroupId invokes the ons.OnsMqttQueryClientByGroupId API synchronously
// api document: https://help.aliyun.com/api/ons/onsmqttqueryclientbygroupid.html
func (client *Client) OnsMqttQueryClientByGroupId(request *OnsMqttQueryClientByGroupIdRequest) (response *OnsMqttQueryClientByGroupIdResponse, err error) {
	response = CreateOnsMqttQueryClientByGroupIdResponse()
	err = client.DoAction(request, response)
	return
}

// OnsMqttQueryClientByGroupIdWithChan invokes the ons.OnsMqttQueryClientByGroupId API asynchronously
// api document: https://help.aliyun.com/api/ons/onsmqttqueryclientbygroupid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsMqttQueryClientByGroupIdWithChan(request *OnsMqttQueryClientByGroupIdRequest) (<-chan *OnsMqttQueryClientByGroupIdResponse, <-chan error) {
	responseChan := make(chan *OnsMqttQueryClientByGroupIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsMqttQueryClientByGroupId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsMqttQueryClientByGroupIdWithCallback invokes the ons.OnsMqttQueryClientByGroupId API asynchronously
// api document: https://help.aliyun.com/api/ons/onsmqttqueryclientbygroupid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsMqttQueryClientByGroupIdWithCallback(request *OnsMqttQueryClientByGroupIdRequest, callback func(response *OnsMqttQueryClientByGroupIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsMqttQueryClientByGroupIdResponse
		var err error
		defer close(result)
		response, err = client.OnsMqttQueryClientByGroupId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsMqttQueryClientByGroupIdRequest is the request struct for api OnsMqttQueryClientByGroupId
type OnsMqttQueryClientByGroupIdRequest struct {
	*requests.RpcRequest
	PreventCache requests.Integer `position:"Query" name:"PreventCache"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	GroupId      string           `position:"Query" name:"GroupId"`
}

// OnsMqttQueryClientByGroupIdResponse is the response struct for api OnsMqttQueryClientByGroupId
type OnsMqttQueryClientByGroupIdResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	HelpUrl         string          `json:"HelpUrl" xml:"HelpUrl"`
	MqttClientSetDo MqttClientSetDo `json:"MqttClientSetDo" xml:"MqttClientSetDo"`
}

// CreateOnsMqttQueryClientByGroupIdRequest creates a request to invoke OnsMqttQueryClientByGroupId API
func CreateOnsMqttQueryClientByGroupIdRequest() (request *OnsMqttQueryClientByGroupIdRequest) {
	request = &OnsMqttQueryClientByGroupIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsMqttQueryClientByGroupId", "ons", "openAPI")
	return
}

// CreateOnsMqttQueryClientByGroupIdResponse creates a response to parse from OnsMqttQueryClientByGroupId response
func CreateOnsMqttQueryClientByGroupIdResponse() (response *OnsMqttQueryClientByGroupIdResponse) {
	response = &OnsMqttQueryClientByGroupIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
