package ros

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteStack invokes the ros.DeleteStack API synchronously
// api document: https://help.aliyun.com/api/ros/deletestack.html
func (client *Client) DeleteStack(request *DeleteStackRequest) (response *DeleteStackResponse, err error) {
	response = CreateDeleteStackResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteStackWithChan invokes the ros.DeleteStack API asynchronously
// api document: https://help.aliyun.com/api/ros/deletestack.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteStackWithChan(request *DeleteStackRequest) (<-chan *DeleteStackResponse, <-chan error) {
	responseChan := make(chan *DeleteStackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteStack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteStackWithCallback invokes the ros.DeleteStack API asynchronously
// api document: https://help.aliyun.com/api/ros/deletestack.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteStackWithCallback(request *DeleteStackRequest, callback func(response *DeleteStackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteStackResponse
		var err error
		defer close(result)
		response, err = client.DeleteStack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteStackRequest is the request struct for api DeleteStack
type DeleteStackRequest struct {
	*requests.RoaRequest
	StackId   string `position:"Path" name:"StackId"`
	StackName string `position:"Path" name:"StackName"`
}

// DeleteStackResponse is the response struct for api DeleteStack
type DeleteStackResponse struct {
	*responses.BaseResponse
}

// CreateDeleteStackRequest creates a request to invoke DeleteStack API
func CreateDeleteStackRequest() (request *DeleteStackRequest) {
	request = &DeleteStackRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ROS", "2015-09-01", "DeleteStack", "/stacks/[StackName]/[StackId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteStackResponse creates a response to parse from DeleteStack response
func CreateDeleteStackResponse() (response *DeleteStackResponse) {
	response = &DeleteStackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
