package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStatis invokes the rtc.DescribeStatis API synchronously
// api document: https://help.aliyun.com/api/rtc/describestatis.html
func (client *Client) DescribeStatis(request *DescribeStatisRequest) (response *DescribeStatisResponse, err error) {
	response = CreateDescribeStatisResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStatisWithChan invokes the rtc.DescribeStatis API asynchronously
// api document: https://help.aliyun.com/api/rtc/describestatis.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStatisWithChan(request *DescribeStatisRequest) (<-chan *DescribeStatisResponse, <-chan error) {
	responseChan := make(chan *DescribeStatisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStatis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStatisWithCallback invokes the rtc.DescribeStatis API asynchronously
// api document: https://help.aliyun.com/api/rtc/describestatis.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStatisWithCallback(request *DescribeStatisRequest, callback func(response *DescribeStatisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStatisResponse
		var err error
		defer close(result)
		response, err = client.DescribeStatis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStatisRequest is the request struct for api DescribeStatis
type DescribeStatisRequest struct {
	*requests.RpcRequest
	SortType    string           `position:"Query" name:"SortType"`
	StartTime   string           `position:"Query" name:"StartTime"`
	DataType    string           `position:"Query" name:"DataType"`
	ServiceArea string           `position:"Query" name:"ServiceArea"`
	EndTime     string           `position:"Query" name:"EndTime"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	AppId       string           `position:"Query" name:"AppId"`
	Interval    string           `position:"Query" name:"Interval"`
}

// DescribeStatisResponse is the response struct for api DescribeStatis
type DescribeStatisResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	StatisInfos StatisInfos `json:"StatisInfos" xml:"StatisInfos"`
}

// CreateDescribeStatisRequest creates a request to invoke DescribeStatis API
func CreateDescribeStatisRequest() (request *DescribeStatisRequest) {
	request = &DescribeStatisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeStatis", "rtc", "openAPI")
	return
}

// CreateDescribeStatisResponse creates a response to parse from DescribeStatis response
func CreateDescribeStatisResponse() (response *DescribeStatisResponse) {
	response = &DescribeStatisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
