package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMasterSlaveVServerGroupAttribute invokes the slb.DescribeMasterSlaveVServerGroupAttribute API synchronously
// api document: https://help.aliyun.com/api/slb/describemasterslavevservergroupattribute.html
func (client *Client) DescribeMasterSlaveVServerGroupAttribute(request *DescribeMasterSlaveVServerGroupAttributeRequest) (response *DescribeMasterSlaveVServerGroupAttributeResponse, err error) {
	response = CreateDescribeMasterSlaveVServerGroupAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMasterSlaveVServerGroupAttributeWithChan invokes the slb.DescribeMasterSlaveVServerGroupAttribute API asynchronously
// api document: https://help.aliyun.com/api/slb/describemasterslavevservergroupattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMasterSlaveVServerGroupAttributeWithChan(request *DescribeMasterSlaveVServerGroupAttributeRequest) (<-chan *DescribeMasterSlaveVServerGroupAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeMasterSlaveVServerGroupAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMasterSlaveVServerGroupAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMasterSlaveVServerGroupAttributeWithCallback invokes the slb.DescribeMasterSlaveVServerGroupAttribute API asynchronously
// api document: https://help.aliyun.com/api/slb/describemasterslavevservergroupattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMasterSlaveVServerGroupAttributeWithCallback(request *DescribeMasterSlaveVServerGroupAttributeRequest, callback func(response *DescribeMasterSlaveVServerGroupAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMasterSlaveVServerGroupAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeMasterSlaveVServerGroupAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMasterSlaveVServerGroupAttributeRequest is the request struct for api DescribeMasterSlaveVServerGroupAttribute
type DescribeMasterSlaveVServerGroupAttributeRequest struct {
	*requests.RpcRequest
	AccessKeyId               string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	MasterSlaveVServerGroupId string           `position:"Query" name:"MasterSlaveVServerGroupId"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	Tags                      string           `position:"Query" name:"Tags"`
}

// DescribeMasterSlaveVServerGroupAttributeResponse is the response struct for api DescribeMasterSlaveVServerGroupAttribute
type DescribeMasterSlaveVServerGroupAttributeResponse struct {
	*responses.BaseResponse
	RequestId                   string                                                              `json:"RequestId" xml:"RequestId"`
	MasterSlaveVServerGroupId   string                                                              `json:"MasterSlaveVServerGroupId" xml:"MasterSlaveVServerGroupId"`
	MasterSlaveVServerGroupName string                                                              `json:"MasterSlaveVServerGroupName" xml:"MasterSlaveVServerGroupName"`
	MasterSlaveBackendServers   MasterSlaveBackendServersInDescribeMasterSlaveVServerGroupAttribute `json:"MasterSlaveBackendServers" xml:"MasterSlaveBackendServers"`
}

// CreateDescribeMasterSlaveVServerGroupAttributeRequest creates a request to invoke DescribeMasterSlaveVServerGroupAttribute API
func CreateDescribeMasterSlaveVServerGroupAttributeRequest() (request *DescribeMasterSlaveVServerGroupAttributeRequest) {
	request = &DescribeMasterSlaveVServerGroupAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "DescribeMasterSlaveVServerGroupAttribute", "slb", "openAPI")
	return
}

// CreateDescribeMasterSlaveVServerGroupAttributeResponse creates a response to parse from DescribeMasterSlaveVServerGroupAttribute response
func CreateDescribeMasterSlaveVServerGroupAttributeResponse() (response *DescribeMasterSlaveVServerGroupAttributeResponse) {
	response = &DescribeMasterSlaveVServerGroupAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
