package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAreas invokes the uis.DescribeAreas API synchronously
// api document: https://help.aliyun.com/api/uis/describeareas.html
func (client *Client) DescribeAreas(request *DescribeAreasRequest) (response *DescribeAreasResponse, err error) {
	response = CreateDescribeAreasResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAreasWithChan invokes the uis.DescribeAreas API asynchronously
// api document: https://help.aliyun.com/api/uis/describeareas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAreasWithChan(request *DescribeAreasRequest) (<-chan *DescribeAreasResponse, <-chan error) {
	responseChan := make(chan *DescribeAreasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAreas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAreasWithCallback invokes the uis.DescribeAreas API asynchronously
// api document: https://help.aliyun.com/api/uis/describeareas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAreasWithCallback(request *DescribeAreasRequest, callback func(response *DescribeAreasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAreasResponse
		var err error
		defer close(result)
		response, err = client.DescribeAreas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAreasRequest is the request struct for api DescribeAreas
type DescribeAreasRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeAreasResponse is the response struct for api DescribeAreas
type DescribeAreasResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Areas     Areas  `json:"Areas" xml:"Areas"`
}

// CreateDescribeAreasRequest creates a request to invoke DescribeAreas API
func CreateDescribeAreasRequest() (request *DescribeAreasRequest) {
	request = &DescribeAreasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "DescribeAreas", "uis", "openAPI")
	return
}

// CreateDescribeAreasResponse creates a response to parse from DescribeAreas response
func CreateDescribeAreasResponse() (response *DescribeAreasResponse) {
	response = &DescribeAreasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
