package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAttachedMediaInfos invokes the vod.UpdateAttachedMediaInfos API synchronously
// api document: https://help.aliyun.com/api/vod/updateattachedmediainfos.html
func (client *Client) UpdateAttachedMediaInfos(request *UpdateAttachedMediaInfosRequest) (response *UpdateAttachedMediaInfosResponse, err error) {
	response = CreateUpdateAttachedMediaInfosResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAttachedMediaInfosWithChan invokes the vod.UpdateAttachedMediaInfos API asynchronously
// api document: https://help.aliyun.com/api/vod/updateattachedmediainfos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAttachedMediaInfosWithChan(request *UpdateAttachedMediaInfosRequest) (<-chan *UpdateAttachedMediaInfosResponse, <-chan error) {
	responseChan := make(chan *UpdateAttachedMediaInfosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAttachedMediaInfos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAttachedMediaInfosWithCallback invokes the vod.UpdateAttachedMediaInfos API asynchronously
// api document: https://help.aliyun.com/api/vod/updateattachedmediainfos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAttachedMediaInfosWithCallback(request *UpdateAttachedMediaInfosRequest, callback func(response *UpdateAttachedMediaInfosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAttachedMediaInfosResponse
		var err error
		defer close(result)
		response, err = client.UpdateAttachedMediaInfos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAttachedMediaInfosRequest is the request struct for api UpdateAttachedMediaInfos
type UpdateAttachedMediaInfosRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UpdateContent        string           `position:"Query" name:"UpdateContent"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceRealOwnerId  requests.Integer `position:"Query" name:"ResourceRealOwnerId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// UpdateAttachedMediaInfosResponse is the response struct for api UpdateAttachedMediaInfos
type UpdateAttachedMediaInfosResponse struct {
	*responses.BaseResponse
	RequestId        string   `json:"RequestId" xml:"RequestId"`
	NonExistMediaIds []string `json:"NonExistMediaIds" xml:"NonExistMediaIds"`
}

// CreateUpdateAttachedMediaInfosRequest creates a request to invoke UpdateAttachedMediaInfos API
func CreateUpdateAttachedMediaInfosRequest() (request *UpdateAttachedMediaInfosRequest) {
	request = &UpdateAttachedMediaInfosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "UpdateAttachedMediaInfos", "vod", "openAPI")
	return
}

// CreateUpdateAttachedMediaInfosResponse creates a response to parse from UpdateAttachedMediaInfos response
func CreateUpdateAttachedMediaInfosResponse() (response *UpdateAttachedMediaInfosResponse) {
	response = &UpdateAttachedMediaInfosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
