package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEditingProject invokes the vod.UpdateEditingProject API synchronously
// api document: https://help.aliyun.com/api/vod/updateeditingproject.html
func (client *Client) UpdateEditingProject(request *UpdateEditingProjectRequest) (response *UpdateEditingProjectResponse, err error) {
	response = CreateUpdateEditingProjectResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEditingProjectWithChan invokes the vod.UpdateEditingProject API asynchronously
// api document: https://help.aliyun.com/api/vod/updateeditingproject.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateEditingProjectWithChan(request *UpdateEditingProjectRequest) (<-chan *UpdateEditingProjectResponse, <-chan error) {
	responseChan := make(chan *UpdateEditingProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEditingProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEditingProjectWithCallback invokes the vod.UpdateEditingProject API asynchronously
// api document: https://help.aliyun.com/api/vod/updateeditingproject.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateEditingProjectWithCallback(request *UpdateEditingProjectRequest, callback func(response *UpdateEditingProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEditingProjectResponse
		var err error
		defer close(result)
		response, err = client.UpdateEditingProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEditingProjectRequest is the request struct for api UpdateEditingProject
type UpdateEditingProjectRequest struct {
	*requests.RpcRequest
	CoverURL             string `position:"Query" name:"CoverURL"`
	ResourceOwnerId      string `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string `position:"Query" name:"OwnerAccount"`
	Timeline             string `position:"Query" name:"Timeline"`
	Description          string `position:"Query" name:"Description"`
	OwnerId              string `position:"Query" name:"OwnerId"`
	Title                string `position:"Query" name:"Title"`
	ProjectId            string `position:"Query" name:"ProjectId"`
}

// UpdateEditingProjectResponse is the response struct for api UpdateEditingProject
type UpdateEditingProjectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateEditingProjectRequest creates a request to invoke UpdateEditingProject API
func CreateUpdateEditingProjectRequest() (request *UpdateEditingProjectRequest) {
	request = &UpdateEditingProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "UpdateEditingProject", "vod", "openAPI")
	return
}

// CreateUpdateEditingProjectResponse creates a response to parse from UpdateEditingProject response
func CreateUpdateEditingProjectResponse() (response *UpdateEditingProjectResponse) {
	response = &UpdateEditingProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
