package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNqa invokes the vpc.ModifyNqa API synchronously
// api document: https://help.aliyun.com/api/vpc/modifynqa.html
func (client *Client) ModifyNqa(request *ModifyNqaRequest) (response *ModifyNqaResponse, err error) {
	response = CreateModifyNqaResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNqaWithChan invokes the vpc.ModifyNqa API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifynqa.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyNqaWithChan(request *ModifyNqaRequest) (<-chan *ModifyNqaResponse, <-chan error) {
	responseChan := make(chan *ModifyNqaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNqa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNqaWithCallback invokes the vpc.ModifyNqa API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifynqa.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyNqaWithCallback(request *ModifyNqaRequest, callback func(response *ModifyNqaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNqaResponse
		var err error
		defer close(result)
		response, err = client.ModifyNqa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNqaRequest is the request struct for api ModifyNqa
type ModifyNqaRequest struct {
	*requests.RpcRequest
	DestinationIp        string           `position:"Query" name:"DestinationIp"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	NqaId                string           `position:"Query" name:"NqaId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyNqaResponse is the response struct for api ModifyNqa
type ModifyNqaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNqaRequest creates a request to invoke ModifyNqa API
func CreateModifyNqaRequest() (request *ModifyNqaRequest) {
	request = &ModifyNqaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyNqa", "vpc", "openAPI")
	return
}

// CreateModifyNqaResponse creates a response to parse from ModifyNqa response
func CreateModifyNqaResponse() (response *ModifyNqaResponse) {
	response = &ModifyNqaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
