package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateStorage invokes the webplus.CreateStorage API synchronously
// api document: https://help.aliyun.com/api/webplus/createstorage.html
func (client *Client) CreateStorage(request *CreateStorageRequest) (response *CreateStorageResponse, err error) {
	response = CreateCreateStorageResponse()
	err = client.DoAction(request, response)
	return
}

// CreateStorageWithChan invokes the webplus.CreateStorage API asynchronously
// api document: https://help.aliyun.com/api/webplus/createstorage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateStorageWithChan(request *CreateStorageRequest) (<-chan *CreateStorageResponse, <-chan error) {
	responseChan := make(chan *CreateStorageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateStorage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateStorageWithCallback invokes the webplus.CreateStorage API asynchronously
// api document: https://help.aliyun.com/api/webplus/createstorage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateStorageWithCallback(request *CreateStorageRequest, callback func(response *CreateStorageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateStorageResponse
		var err error
		defer close(result)
		response, err = client.CreateStorage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateStorageRequest is the request struct for api CreateStorage
type CreateStorageRequest struct {
	*requests.RoaRequest
}

// CreateStorageResponse is the response struct for api CreateStorage
type CreateStorageResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Code      string  `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	Storage   Storage `json:"Storage" xml:"Storage"`
}

// CreateCreateStorageRequest creates a request to invoke CreateStorage API
func CreateCreateStorageRequest() (request *CreateStorageRequest) {
	request = &CreateStorageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "CreateStorage", "/pop/v1/wam/storage", "webx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateStorageResponse creates a response to parse from CreateStorage response
func CreateCreateStorageResponse() (response *CreateStorageResponse) {
	response = &CreateStorageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
