package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateApplication invokes the webplus.UpdateApplication API synchronously
// api document: https://help.aliyun.com/api/webplus/updateapplication.html
func (client *Client) UpdateApplication(request *UpdateApplicationRequest) (response *UpdateApplicationResponse, err error) {
	response = CreateUpdateApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateApplicationWithChan invokes the webplus.UpdateApplication API asynchronously
// api document: https://help.aliyun.com/api/webplus/updateapplication.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateApplicationWithChan(request *UpdateApplicationRequest) (<-chan *UpdateApplicationResponse, <-chan error) {
	responseChan := make(chan *UpdateApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateApplicationWithCallback invokes the webplus.UpdateApplication API asynchronously
// api document: https://help.aliyun.com/api/webplus/updateapplication.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateApplicationWithCallback(request *UpdateApplicationRequest, callback func(response *UpdateApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateApplicationResponse
		var err error
		defer close(result)
		response, err = client.UpdateApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateApplicationRequest is the request struct for api UpdateApplication
type UpdateApplicationRequest struct {
	*requests.RoaRequest
	AppDescription string `position:"Body" name:"AppDescription"`
	AppId          string `position:"Body" name:"AppId"`
}

// UpdateApplicationResponse is the response struct for api UpdateApplication
type UpdateApplicationResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	Application Application `json:"Application" xml:"Application"`
}

// CreateUpdateApplicationRequest creates a request to invoke UpdateApplication API
func CreateUpdateApplicationRequest() (request *UpdateApplicationRequest) {
	request = &UpdateApplicationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "UpdateApplication", "/pop/v1/wam/application", "webx", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateApplicationResponse creates a response to parse from UpdateApplication response
func CreateUpdateApplicationResponse() (response *UpdateApplicationResponse) {
	response = &UpdateApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
