/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v2alpha1 "github.com/submariner-io/lighthouse/pkg/apis/lighthouse.submariner.io/v2alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeServiceImports implements ServiceImportInterface
type FakeServiceImports struct {
	Fake *FakeLighthouseV2alpha1
	ns   string
}

var serviceimportsResource = schema.GroupVersionResource{Group: "lighthouse.submariner.io", Version: "v2alpha1", Resource: "serviceimports"}

var serviceimportsKind = schema.GroupVersionKind{Group: "lighthouse.submariner.io", Version: "v2alpha1", Kind: "ServiceImport"}

// Get takes name of the serviceImport, and returns the corresponding serviceImport object, and an error if there is any.
func (c *FakeServiceImports) Get(name string, options v1.GetOptions) (result *v2alpha1.ServiceImport, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(serviceimportsResource, c.ns, name), &v2alpha1.ServiceImport{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2alpha1.ServiceImport), err
}

// List takes label and field selectors, and returns the list of ServiceImports that match those selectors.
func (c *FakeServiceImports) List(opts v1.ListOptions) (result *v2alpha1.ServiceImportList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(serviceimportsResource, serviceimportsKind, c.ns, opts), &v2alpha1.ServiceImportList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v2alpha1.ServiceImportList{ListMeta: obj.(*v2alpha1.ServiceImportList).ListMeta}
	for _, item := range obj.(*v2alpha1.ServiceImportList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested serviceImports.
func (c *FakeServiceImports) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(serviceimportsResource, c.ns, opts))

}

// Create takes the representation of a serviceImport and creates it.  Returns the server's representation of the serviceImport, and an error, if there is any.
func (c *FakeServiceImports) Create(serviceImport *v2alpha1.ServiceImport) (result *v2alpha1.ServiceImport, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(serviceimportsResource, c.ns, serviceImport), &v2alpha1.ServiceImport{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2alpha1.ServiceImport), err
}

// Update takes the representation of a serviceImport and updates it. Returns the server's representation of the serviceImport, and an error, if there is any.
func (c *FakeServiceImports) Update(serviceImport *v2alpha1.ServiceImport) (result *v2alpha1.ServiceImport, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(serviceimportsResource, c.ns, serviceImport), &v2alpha1.ServiceImport{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2alpha1.ServiceImport), err
}

// Delete takes name of the serviceImport and deletes it. Returns an error if one occurs.
func (c *FakeServiceImports) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(serviceimportsResource, c.ns, name), &v2alpha1.ServiceImport{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeServiceImports) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(serviceimportsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v2alpha1.ServiceImportList{})
	return err
}

// Patch applies the patch and returns the patched serviceImport.
func (c *FakeServiceImports) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v2alpha1.ServiceImport, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(serviceimportsResource, c.ns, name, pt, data, subresources...), &v2alpha1.ServiceImport{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v2alpha1.ServiceImport), err
}
