/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	scheme "github.com/submariner-io/lighthouse/pkg/mcs/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "sigs.k8s.io/mcs-api/pkg/apis/v1alpha1"
)

// ServiceImportsGetter has a method to return a ServiceImportInterface.
// A group's client should implement this interface.
type ServiceImportsGetter interface {
	ServiceImports(namespace string) ServiceImportInterface
}

// ServiceImportInterface has methods to work with ServiceImport resources.
type ServiceImportInterface interface {
	Create(*v1alpha1.ServiceImport) (*v1alpha1.ServiceImport, error)
	Update(*v1alpha1.ServiceImport) (*v1alpha1.ServiceImport, error)
	UpdateStatus(*v1alpha1.ServiceImport) (*v1alpha1.ServiceImport, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.ServiceImport, error)
	List(opts v1.ListOptions) (*v1alpha1.ServiceImportList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ServiceImport, err error)
	ServiceImportExpansion
}

// serviceImports implements ServiceImportInterface
type serviceImports struct {
	client rest.Interface
	ns     string
}

// newServiceImports returns a ServiceImports
func newServiceImports(c *MulticlusterV1alpha1Client, namespace string) *serviceImports {
	return &serviceImports{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the serviceImport, and returns the corresponding serviceImport object, and an error if there is any.
func (c *serviceImports) Get(name string, options v1.GetOptions) (result *v1alpha1.ServiceImport, err error) {
	result = &v1alpha1.ServiceImport{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("serviceimports").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ServiceImports that match those selectors.
func (c *serviceImports) List(opts v1.ListOptions) (result *v1alpha1.ServiceImportList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ServiceImportList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("serviceimports").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested serviceImports.
func (c *serviceImports) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("serviceimports").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a serviceImport and creates it.  Returns the server's representation of the serviceImport, and an error, if there is any.
func (c *serviceImports) Create(serviceImport *v1alpha1.ServiceImport) (result *v1alpha1.ServiceImport, err error) {
	result = &v1alpha1.ServiceImport{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("serviceimports").
		Body(serviceImport).
		Do().
		Into(result)
	return
}

// Update takes the representation of a serviceImport and updates it. Returns the server's representation of the serviceImport, and an error, if there is any.
func (c *serviceImports) Update(serviceImport *v1alpha1.ServiceImport) (result *v1alpha1.ServiceImport, err error) {
	result = &v1alpha1.ServiceImport{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("serviceimports").
		Name(serviceImport.Name).
		Body(serviceImport).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *serviceImports) UpdateStatus(serviceImport *v1alpha1.ServiceImport) (result *v1alpha1.ServiceImport, err error) {
	result = &v1alpha1.ServiceImport{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("serviceimports").
		Name(serviceImport.Name).
		SubResource("status").
		Body(serviceImport).
		Do().
		Into(result)
	return
}

// Delete takes name of the serviceImport and deletes it. Returns an error if one occurs.
func (c *serviceImports) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("serviceimports").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *serviceImports) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("serviceimports").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched serviceImport.
func (c *serviceImports) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ServiceImport, err error) {
	result = &v1alpha1.ServiceImport{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("serviceimports").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
