/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "sigs.k8s.io/mcs-api/pkg/apis/v1alpha1"
)

// ServiceImportLister helps list ServiceImports.
type ServiceImportLister interface {
	// List lists all ServiceImports in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.ServiceImport, err error)
	// ServiceImports returns an object that can list and get ServiceImports.
	ServiceImports(namespace string) ServiceImportNamespaceLister
	ServiceImportListerExpansion
}

// serviceImportLister implements the ServiceImportLister interface.
type serviceImportLister struct {
	indexer cache.Indexer
}

// NewServiceImportLister returns a new ServiceImportLister.
func NewServiceImportLister(indexer cache.Indexer) ServiceImportLister {
	return &serviceImportLister{indexer: indexer}
}

// List lists all ServiceImports in the indexer.
func (s *serviceImportLister) List(selector labels.Selector) (ret []*v1alpha1.ServiceImport, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ServiceImport))
	})
	return ret, err
}

// ServiceImports returns an object that can list and get ServiceImports.
func (s *serviceImportLister) ServiceImports(namespace string) ServiceImportNamespaceLister {
	return serviceImportNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ServiceImportNamespaceLister helps list and get ServiceImports.
type ServiceImportNamespaceLister interface {
	// List lists all ServiceImports in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.ServiceImport, err error)
	// Get retrieves the ServiceImport from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.ServiceImport, error)
	ServiceImportNamespaceListerExpansion
}

// serviceImportNamespaceLister implements the ServiceImportNamespaceLister
// interface.
type serviceImportNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ServiceImports in the indexer for a given namespace.
func (s serviceImportNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.ServiceImport, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ServiceImport))
	})
	return ret, err
}

// Get retrieves the ServiceImport from the indexer for a given namespace and name.
func (s serviceImportNamespaceLister) Get(name string) (*v1alpha1.ServiceImport, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("serviceimport"), name)
	}
	return obj.(*v1alpha1.ServiceImport), nil
}
