package api

/************************************************
  generated by IDE. for [BridgeAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件リセット
func (api *BridgeAPI) Reset() *BridgeAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *BridgeAPI) Offset(offset int) *BridgeAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *BridgeAPI) Limit(limit int) *BridgeAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *BridgeAPI) Include(key string) *BridgeAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *BridgeAPI) Exclude(key string) *BridgeAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *BridgeAPI) FilterBy(key string, value interface{}) *BridgeAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *BridgeAPI) FilterMultiBy(key string, value interface{}) *BridgeAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *BridgeAPI) WithNameLike(name string) *BridgeAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *BridgeAPI) WithTag(tag string) *BridgeAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *BridgeAPI) WithTags(tags []string) *BridgeAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *BridgeAPI) WithSizeGib(size int) *BridgeAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *BridgeAPI) WithSharedScope() *BridgeAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *BridgeAPI) WithUserScope() *BridgeAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *BridgeAPI) SortBy(key string, reverse bool) *BridgeAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *BridgeAPI) SortByName(reverse bool) *BridgeAPI {
	api.sortByName(reverse)
	return api
}

// func (api *BridgeAPI) SortBySize(reverse bool) *BridgeAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件リセット
func (api *BridgeAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *BridgeAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *BridgeAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *BridgeAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *BridgeAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *BridgeAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *BridgeAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *BridgeAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *BridgeAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *BridgeAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *BridgeAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *BridgeAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *BridgeAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *BridgeAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *BridgeAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *BridgeAPI) SortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// New 新規作成用パラメーター作成
func (api *BridgeAPI) New() *sacloud.Bridge {
	return &sacloud.Bridge{}
}

// Create 新規作成
func (api *BridgeAPI) Create(value *sacloud.Bridge) (*sacloud.Bridge, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.create(api.createRequest(value), res)
	})
}

// Read 読み取り
func (api *BridgeAPI) Read(id int64) (*sacloud.Bridge, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// Update 更新
func (api *BridgeAPI) Update(id int64, value *sacloud.Bridge) (*sacloud.Bridge, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.update(id, api.createRequest(value), res)
	})
}

// Delete 削除
func (api *BridgeAPI) Delete(id int64) (*sacloud.Bridge, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.delete(id, nil, res)
	})
}

/************************************************
  Inner functions
************************************************/

func (api *BridgeAPI) setStateValue(setFunc func(*sacloud.Request)) *BridgeAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *BridgeAPI) request(f func(*sacloud.Response) error) (*sacloud.Bridge, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.Bridge, nil
}

func (api *BridgeAPI) createRequest(value *sacloud.Bridge) *sacloud.Request {
	req := &sacloud.Request{}
	req.Bridge = value
	return req
}
