package api

/************************************************
  generated by IDE. for [IPv6AddrAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *IPv6AddrAPI) Reset() *IPv6AddrAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *IPv6AddrAPI) Offset(offset int) *IPv6AddrAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *IPv6AddrAPI) Limit(limit int) *IPv6AddrAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *IPv6AddrAPI) Include(key string) *IPv6AddrAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *IPv6AddrAPI) Exclude(key string) *IPv6AddrAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *IPv6AddrAPI) FilterBy(key string, value interface{}) *IPv6AddrAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *IPv6AddrAPI) FilterMultiBy(key string, value interface{}) *IPv6AddrAPI {
	api.filterBy(key, value, true)
	return api
}

//func (api *IPv6AddrAPI) WithNameLike(name string) *IPv6AddrAPI {
//	return api.FilterBy("Name", name)
//}

//func (api *IPv6AddrAPI) WithTag(tag string) *IPv6AddrAPI {
//	return api.FilterBy("Tags.Name", tag)
//}
//func (api *IPv6AddrAPI) WithTags(tags []string) *IPv6AddrAPI {
//	return api.FilterBy("Tags.Name", []interface{}{tags})
//}
//
//func (api *IPv6AddrAPI) WithSizeGib(size int) *IPv6AddrAPI {
//	api.FilterBy("SizeMB", size*1024)
//	return api
//}
//
//func (api *IPv6AddrAPI) WithSharedScope() *IPv6AddrAPI {
//	api.FilterBy("Scope", "shared")
//	return api
//}
//
//func (api *IPv6AddrAPI) WithUserScope() *IPv6AddrAPI {
//	api.FilterBy("Scope", "user")
//	return api
//}

// SortBy 指定キーでのソート
func (api *IPv6AddrAPI) SortBy(key string, reverse bool) *IPv6AddrAPI {
	api.sortBy(key, reverse)
	return api
}

//// SortByName
//func (api *IPv6AddrAPI) SortByName(reverse bool) *IPv6AddrAPI {
//	api.sortByName(reverse)
//	return api
//}

//func (api *IPv6AddrAPI) SortBySize(reverse bool) *IPv6AddrAPI {
//	api.sortBy("SizeMB", reverse)
//	return api
//}

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *IPv6AddrAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *IPv6AddrAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *IPv6AddrAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *IPv6AddrAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *IPv6AddrAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *IPv6AddrAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *IPv6AddrAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

//func (api *IPv6AddrAPI) SetNameLike(name string)  {
//}

//func (api *IPv6AddrAPI) SetTag(tag string)  {
//	api.FilterBy("Tags.Name", tag)
//}
//func (api *IPv6AddrAPI) SetTags(tags []string)  {
//	api.FilterBy("Tags.Name", []interface{}{tags})
//}
//
//func (api *IPv6AddrAPI) SetSizeGib(size int)  {
//	api.FilterBy("SizeMB", size*1024)
//}
//
//func (api *IPv6AddrAPI) SetSharedScope()  {
//	api.FilterBy("Scope", "shared")
//}
//
//func (api *IPv6AddrAPI) SetUserScope()  {
//	api.FilterBy("Scope", "user")
//}

// SetSortBy 指定キーでのソート
func (api *IPv6AddrAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

//// SetSortByName
//func (api *IPv6AddrAPI) SetSortByName(reverse bool)  {
//	api.sortByName(reverse)
//}

//func (api *IPv6AddrAPI) SetSortBySize(reverse bool)  {
//	api.sortBy("SizeMB", reverse)
//}

/************************************************
  // To
  To support CRUD(Create/Read/Update/Delete)
************************************************/

//func (api *IPv6AddrAPI) Create(value *sacloud.IPv6Addr) (*sacloud.IPv6Addr, error) {
//	return api.request(func(res *sacloud.Response) error {
//		return api.create(api.createRequest(value), res)
//	})
//}

//func (api *IPv6AddrAPI) Read(id int64) (*sacloud.IPv6Addr, error) {
//	return api.request(func(res *sacloud.Response) error {
//		return api.read(id, nil, res)
//	})
//}

//func (api *IPv6AddrAPI) Update(id int64, value *sacloud.IPv6Addr) (*sacloud.IPv6Addr, error) {
//	return api.request(func(res *sacloud.Response) error {
//		return api.update(id, api.createRequest(value), res)
//	})
//}
//
//func (api *IPv6AddrAPI) Delete(id int64) (*sacloud.IPv6Addr, error) {
//	return api.request(func(res *sacloud.Response) error {
//		return api.delete(id, nil, res)
//	})
//}
//

// New 新規作成用パラメーター作成
func (api *IPv6AddrAPI) New() *sacloud.IPv6Addr {
	return sacloud.CreateNewIPv6Addr()
}

/************************************************
  Inner functions
************************************************/

func (api *IPv6AddrAPI) setStateValue(setFunc func(*sacloud.Request)) *IPv6AddrAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *IPv6AddrAPI) request(f func(*sacloud.Response) error) (*sacloud.IPv6Addr, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.IPv6Addr, nil
}

func (api *IPv6AddrAPI) createRequest(value *sacloud.IPv6Addr) *sacloud.Request {
	req := &sacloud.Request{}
	req.IPv6Addr = value
	return req
}
