package api

/************************************************
  generated by IDE. for [RegionAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *RegionAPI) Reset() *RegionAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *RegionAPI) Offset(offset int) *RegionAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *RegionAPI) Limit(limit int) *RegionAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *RegionAPI) Include(key string) *RegionAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *RegionAPI) Exclude(key string) *RegionAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *RegionAPI) FilterBy(key string, value interface{}) *RegionAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *RegionAPI) FilterMultiBy(key string, value interface{}) *RegionAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *RegionAPI) WithNameLike(name string) *RegionAPI {
	return api.FilterBy("Name", name)
}

//// WithTag
//func (api *RegionAPI) WithTag(tag string) *RegionAPI {
//	return api.FilterBy("Tags.Name", tag)
//}
//
//// WithTags
//func (api *RegionAPI) WithTags(tags []string) *RegionAPI {
//	return api.FilterBy("Tags.Name", []interface{}{tags})
//}

// func (api *RegionAPI) WithSizeGib(size int) *RegionAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *RegionAPI) WithSharedScope() *RegionAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *RegionAPI) WithUserScope() *RegionAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *RegionAPI) SortBy(key string, reverse bool) *RegionAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *RegionAPI) SortByName(reverse bool) *RegionAPI {
	api.sortByName(reverse)
	return api
}

// func (api *RegionAPI) SortBySize(reverse bool) *RegionAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *RegionAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *RegionAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *RegionAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *RegionAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *RegionAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *RegionAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *RegionAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *RegionAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

//// SetTag
//func (api *RegionAPI) SetTag(tag string) {
//	api.FilterBy("Tags.Name", tag)
//}
//
//// SetTags
//func (api *RegionAPI) SetTags(tags []string) {
//	api.FilterBy("Tags.Name", []interface{}{tags})
//}

// func (api *RegionAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *RegionAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *RegionAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *RegionAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *RegionAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *RegionAPI) SetSortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

//func (api *RegionAPI) New() *sacloud.Region {
// 	return &sacloud.Region{}
//}

// func (api *RegionAPI) Create(value *sacloud.Region) (*sacloud.Region, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.create(api.createRequest(value), res)
// 	})
// }

// Read 読み取り
func (api *RegionAPI) Read(id int64) (*sacloud.Region, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// func (api *RegionAPI) Update(id int64, value *sacloud.Region) (*sacloud.Region, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.update(id, api.createRequest(value), res)
// 	})
// }

// func (api *RegionAPI) Delete(id int64) (*sacloud.Region, error) {
// 	return api.request(func(res *sacloud.Response) error {
// 		return api.delete(id, nil, res)
// 	})
// }

/************************************************
  Inner functions
************************************************/

func (api *RegionAPI) setStateValue(setFunc func(*sacloud.Request)) *RegionAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *RegionAPI) request(f func(*sacloud.Response) error) (*sacloud.Region, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.Region, nil
}

func (api *RegionAPI) createRequest(value *sacloud.Region) *sacloud.Request {
	req := &sacloud.Request{}
	req.Region = value
	return req
}
