package api

/************************************************
  generated by IDE. for [SSHKeyAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *SSHKeyAPI) Reset() *SSHKeyAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *SSHKeyAPI) Offset(offset int) *SSHKeyAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *SSHKeyAPI) Limit(limit int) *SSHKeyAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *SSHKeyAPI) Include(key string) *SSHKeyAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *SSHKeyAPI) Exclude(key string) *SSHKeyAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *SSHKeyAPI) FilterBy(key string, value interface{}) *SSHKeyAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *SSHKeyAPI) FilterMultiBy(key string, value interface{}) *SSHKeyAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *SSHKeyAPI) WithNameLike(name string) *SSHKeyAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *SSHKeyAPI) WithTag(tag string) *SSHKeyAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *SSHKeyAPI) WithTags(tags []string) *SSHKeyAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *SSHKeyAPI) WithSizeGib(size int) *SSHKeyAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *SSHKeyAPI) WithSharedScope() *SSHKeyAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *SSHKeyAPI) WithUserScope() *SSHKeyAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *SSHKeyAPI) SortBy(key string, reverse bool) *SSHKeyAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *SSHKeyAPI) SortByName(reverse bool) *SSHKeyAPI {
	api.sortByName(reverse)
	return api
}

// func (api *SSHKeyAPI) SortBySize(reverse bool) *SSHKeyAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *SSHKeyAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *SSHKeyAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *SSHKeyAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *SSHKeyAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *SSHKeyAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *SSHKeyAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *SSHKeyAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *SSHKeyAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *SSHKeyAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *SSHKeyAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *SSHKeyAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *SSHKeyAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *SSHKeyAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *SSHKeyAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *SSHKeyAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *SSHKeyAPI) SetSortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// New 新規作成用パラメーター作成
func (api *SSHKeyAPI) New() *sacloud.SSHKey {
	return &sacloud.SSHKey{}
}

// Create 新規作成
func (api *SSHKeyAPI) Create(value *sacloud.SSHKey) (*sacloud.SSHKey, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.create(api.createRequest(value), res)
	})
}

// Read 読み取り
func (api *SSHKeyAPI) Read(id int64) (*sacloud.SSHKey, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// Update 更新
func (api *SSHKeyAPI) Update(id int64, value *sacloud.SSHKey) (*sacloud.SSHKey, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.update(id, api.createRequest(value), res)
	})
}

// Delete 削除
func (api *SSHKeyAPI) Delete(id int64) (*sacloud.SSHKey, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.delete(id, nil, res)
	})
}

/************************************************
  Inner functions
************************************************/

func (api *SSHKeyAPI) setStateValue(setFunc func(*sacloud.Request)) *SSHKeyAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *SSHKeyAPI) request(f func(*sacloud.Response) error) (*sacloud.SSHKey, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.SSHKey, nil
}

func (api *SSHKeyAPI) createRequest(value *sacloud.SSHKey) *sacloud.Request {
	req := &sacloud.Request{}
	req.SSHKey = value
	return req
}
