package api

/************************************************
  generated by IDE. for [SwitchAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *SwitchAPI) Reset() *SwitchAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *SwitchAPI) Offset(offset int) *SwitchAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *SwitchAPI) Limit(limit int) *SwitchAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *SwitchAPI) Include(key string) *SwitchAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *SwitchAPI) Exclude(key string) *SwitchAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *SwitchAPI) FilterBy(key string, value interface{}) *SwitchAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *SwitchAPI) FilterMultiBy(key string, value interface{}) *SwitchAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *SwitchAPI) WithNameLike(name string) *SwitchAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *SwitchAPI) WithTag(tag string) *SwitchAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *SwitchAPI) WithTags(tags []string) *SwitchAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *SwitchAPI) WithSizeGib(size int) *SwitchAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *SwitchAPI) WithSharedScope() *SwitchAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *SwitchAPI) WithUserScope() *SwitchAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *SwitchAPI) SortBy(key string, reverse bool) *SwitchAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *SwitchAPI) SortByName(reverse bool) *SwitchAPI {
	api.sortByName(reverse)
	return api
}

// func (api *SwitchAPI) SortBySize(reverse bool) *SwitchAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *SwitchAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *SwitchAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *SwitchAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *SwitchAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *SwitchAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *SwitchAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *SwitchAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *SwitchAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *SwitchAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *SwitchAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *SwitchAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *SwitchAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *SwitchAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *SwitchAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *SwitchAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *SwitchAPI) SetSortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// New 新規作成用パラメーター作成
func (api *SwitchAPI) New() *sacloud.Switch {
	return &sacloud.Switch{}
}

// Create 新規作成
func (api *SwitchAPI) Create(value *sacloud.Switch) (*sacloud.Switch, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.create(api.createRequest(value), res)
	})
}

// Read 読み取り
func (api *SwitchAPI) Read(id int64) (*sacloud.Switch, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// Update 更新
func (api *SwitchAPI) Update(id int64, value *sacloud.Switch) (*sacloud.Switch, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.update(id, api.createRequest(value), res)
	})
}

// Delete 削除
func (api *SwitchAPI) Delete(id int64) (*sacloud.Switch, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.delete(id, nil, res)
	})
}

/************************************************
  Inner functions
************************************************/

func (api *SwitchAPI) setStateValue(setFunc func(*sacloud.Request)) *SwitchAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *SwitchAPI) request(f func(*sacloud.Response) error) (*sacloud.Switch, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.Switch, nil
}

func (api *SwitchAPI) createRequest(value *sacloud.Switch) *sacloud.Request {
	req := &sacloud.Request{}
	req.Switch = value
	return req
}
