// Unless explicitly stated otherwise all files in this repository are licensed
// under the Apache License Version 2.0.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2016-2019 Datadog, Inc.

// Code generated by make_endpoints.go DO NOT EDIT

package api

import (
	"regexp"

	"gopkg.in/DataDog/dd-trace-go.v1/contrib/google.golang.org/api/internal"
)

func init() {
	apiEndpoints = internal.NewTree([]internal.Endpoint{
		{Hostname: "", HTTPMethod: "GET", PathTemplate: "/accounts/{accountId}/reports", PathMatcher: regexp.MustCompile(`^(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/reports)$`), ServiceName: "google.repeated", ResourceName: "adsense.accounts.reports.generate"},
		{Hostname: "", HTTPMethod: "GET", PathTemplate: "/map", PathMatcher: regexp.MustCompile(`^(/map)$`), ServiceName: "google.additionalprops", ResourceName: "mapofstrings.getMap"},
		{Hostname: "", HTTPMethod: "GET", PathTemplate: "/map", PathMatcher: regexp.MustCompile(`^(/map)$`), ServiceName: "google.additionalprops", ResourceName: "mapofstrings.getMap"},
		{Hostname: "", HTTPMethod: "GET", PathTemplate: "/reports", PathMatcher: regexp.MustCompile(`^(/reports)$`), ServiceName: "google.paramrename", ResourceName: "youtubeAnalytics.reports.query"},
		{Hostname: "", HTTPMethod: "GET", PathTemplate: "/{project}/metricDescriptors", PathMatcher: regexp.MustCompile(`^(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metricDescriptors)$`), ServiceName: "google.getwithoutbody", ResourceName: "getwithoutbody.metricDescriptors.list"},
		{Hostname: "", HTTPMethod: "POST", PathTemplate: "/calendars/{calendarId}/events/{eventId}/move", PathMatcher: regexp.MustCompile(`^(/calendars/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/events/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/move)$`), ServiceName: "google.paramrename", ResourceName: "calendar.events.move"},
		{Hostname: "abusiveexperiencereport.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/sites/{sitesId}", PathMatcher: regexp.MustCompile(`^(/v1/sites/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.abusiveexperiencereport", ResourceName: "abusiveexperiencereport.sites.get"},
		{Hostname: "abusiveexperiencereport.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/violatingSites", PathMatcher: regexp.MustCompile(`^(/v1/violatingSites)$`), ServiceName: "google.abusiveexperiencereport", ResourceName: "abusiveexperiencereport.violatingSites.list"},
		{Hostname: "acceleratedmobilepageurl.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/ampUrls:batchGet", PathMatcher: regexp.MustCompile(`^(/v1/ampUrls:batchGet)$`), ServiceName: "google.acceleratedmobilepageurl", ResourceName: "acceleratedmobilepageurl.ampUrls.batchGet"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.delete"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.delete"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/accounts/{accountId}/clients", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clients)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.clients.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/accounts/{accountId}/clients/{clientAccountId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.clients.get"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/accounts/{accountId}/clients/{clientAccountId}/invitations", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/invitations)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.clients.invitations.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/accounts/{accountId}/clients/{clientAccountId}/invitations/{invitationId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/invitations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.clients.invitations.get"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/accounts/{accountId}/clients/{clientAccountId}/users", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.clients.users.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/accounts/{accountId}/clients/{clientAccountId}/users/{userId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.clients.users.get"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/accounts/{accountId}/creatives", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.creatives.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/accounts/{accountId}/creatives/{creativeId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.creatives.get"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/accounts/{accountId}/creatives/{creativeId}/dealAssociations", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dealAssociations)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.creatives.dealAssociations.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.get"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}/bidMetrics", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/bidMetrics)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.bidMetrics.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}/bidResponseErrors", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/bidResponseErrors)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.bidResponseErrors.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}/bidResponsesWithoutBids", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/bidResponsesWithoutBids)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.bidResponsesWithoutBids.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}/filteredBidRequests", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filteredBidRequests)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.filteredBidRequests.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}/filteredBids", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filteredBids)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.filteredBids.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}/filteredBids/{creativeStatusId}/creatives", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filteredBids/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.filteredBids.creatives.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}/filteredBids/{creativeStatusId}/details", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filteredBids/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/details)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.filteredBids.details.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}/impressionMetrics", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/impressionMetrics)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.impressionMetrics.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}/losingBids", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/losingBids)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.losingBids.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets/{filterSetsId}/nonBillableWinningBids", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nonBillableWinningBids)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.nonBillableWinningBids.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.get"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}/bidMetrics", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/bidMetrics)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.bidMetrics.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}/bidResponseErrors", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/bidResponseErrors)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.bidResponseErrors.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}/bidResponsesWithoutBids", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/bidResponsesWithoutBids)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.bidResponsesWithoutBids.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}/filteredBidRequests", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filteredBidRequests)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.filteredBidRequests.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}/filteredBids", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filteredBids)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.filteredBids.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}/filteredBids/{creativeStatusId}/creatives", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filteredBids/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.filteredBids.creatives.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}/filteredBids/{creativeStatusId}/details", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filteredBids/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/details)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.filteredBids.details.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}/impressionMetrics", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/impressionMetrics)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.impressionMetrics.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}/losingBids", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/losingBids)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.losingBids.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets/{filterSetsId}/nonBillableWinningBids", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nonBillableWinningBids)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.nonBillableWinningBids.list"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/accounts/{accountId}/clients", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clients)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.clients.create"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/accounts/{accountId}/clients/{clientAccountId}/invitations", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/invitations)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.clients.invitations.create"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/accounts/{accountId}/creatives", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.creatives.create"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/accounts/{accountId}/creatives/{creativeId}/dealAssociations:add", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dealAssociations:add)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.creatives.dealAssociations.add"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/accounts/{accountId}/creatives/{creativeId}/dealAssociations:remove", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dealAssociations:remove)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.creatives.dealAssociations.remove"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/accounts/{accountId}/creatives/{creativeId}:stopWatching", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:stopWatching)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.creatives.stopWatching"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/accounts/{accountId}/creatives/{creativeId}:watch", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:watch)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.creatives.watch"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/bidders/{biddersId}/accounts/{accountsId}/filterSets", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.accounts.filterSets.create"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/bidders/{biddersId}/filterSets", PathMatcher: regexp.MustCompile(`^(/v2beta1/bidders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filterSets)$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.bidders.filterSets.create"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2beta1/accounts/{accountId}/clients/{clientAccountId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.clients.update"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2beta1/accounts/{accountId}/clients/{clientAccountId}/users/{userId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.clients.users.update"},
		{Hostname: "adexchangebuyer.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2beta1/accounts/{accountId}/creatives/{creativeId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creatives/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer2", ResourceName: "adexchangebuyer2.accounts.creatives.update"},
		{Hostname: "adexperiencereport.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/sites/{sitesId}", PathMatcher: regexp.MustCompile(`^(/v1/sites/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexperiencereport", ResourceName: "adexperiencereport.sites.get"},
		{Hostname: "adexperiencereport.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/violatingSites", PathMatcher: regexp.MustCompile(`^(/v1/violatingSites)$`), ServiceName: "google.adexperiencereport", ResourceName: "adexperiencereport.violatingSites.list"},
		{Hostname: "analyticsreporting.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/reports:batchGet", PathMatcher: regexp.MustCompile(`^(/v4/reports:batchGet)$`), ServiceName: "google.analyticsreporting", ResourceName: "analyticsreporting.reports.batchGet"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/customers/{customersId}/configurations/{configurationsId}", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configurations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.configurations.delete"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/customers", PathMatcher: regexp.MustCompile(`^(/v1/customers)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.list"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/customers/{customersId}/configurations", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configurations)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.configurations.list"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/customers/{customersId}/configurations/{configurationsId}", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configurations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.configurations.get"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/customers/{customersId}/devices", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.devices.list"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/customers/{customersId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.devices.get"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/customers/{customersId}/dpcs", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dpcs)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.dpcs.list"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.operations.get"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/partners/{partnersId}/customers", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/customers)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.customers.list"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/partners/{partnersId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.devices.get"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/customers/{customersId}/configurations/{configurationsId}", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configurations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.configurations.patch"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/customers/{customersId}/configurations", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configurations)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.configurations.create"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/customers/{customersId}/devices:applyConfiguration", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices:applyConfiguration)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.devices.applyConfiguration"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/customers/{customersId}/devices:removeConfiguration", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices:removeConfiguration)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.devices.removeConfiguration"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/customers/{customersId}/devices:unclaim", PathMatcher: regexp.MustCompile(`^(/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices:unclaim)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.customers.devices.unclaim"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/partners/{partnersId}/customers", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/customers)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.customers.create"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/partners/{partnersId}/devices/{devicesId}/metadata", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metadata)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.devices.metadata"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/partners/{partnersId}/devices:claim", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices:claim)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.devices.claim"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/partners/{partnersId}/devices:claimAsync", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices:claimAsync)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.devices.claimAsync"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/partners/{partnersId}/devices:findByIdentifier", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices:findByIdentifier)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.devices.findByIdentifier"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/partners/{partnersId}/devices:findByOwner", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices:findByOwner)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.devices.findByOwner"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/partners/{partnersId}/devices:unclaim", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices:unclaim)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.devices.unclaim"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/partners/{partnersId}/devices:unclaimAsync", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices:unclaimAsync)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.devices.unclaimAsync"},
		{Hostname: "androiddeviceprovisioning.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/partners/{partnersId}/devices:updateMetadataAsync", PathMatcher: regexp.MustCompile(`^(/v1/partners/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices:updateMetadataAsync)$`), ServiceName: "google.androiddeviceprovisioning", ResourceName: "androiddeviceprovisioning.partners.devices.updateMetadataAsync"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/enterprises/{enterprisesId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.devices.delete"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/enterprises/{enterprisesId}/devices/{devicesId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.devices.operations.delete"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/enterprises/{enterprisesId}/enrollmentTokens/{enrollmentTokensId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/enrollmentTokens/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.enrollmentTokens.delete"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/enterprises/{enterprisesId}/policies/{policiesId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/policies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.policies.delete"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/enterprises/{enterprisesId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.get"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/enterprises/{enterprisesId}/applications/{applicationsId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.applications.get"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/enterprises/{enterprisesId}/devices", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices)$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.devices.list"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/enterprises/{enterprisesId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.devices.get"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/enterprises/{enterprisesId}/devices/{devicesId}/operations", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.devices.operations.list"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/enterprises/{enterprisesId}/devices/{devicesId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.devices.operations.get"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/enterprises/{enterprisesId}/policies", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/policies)$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.policies.list"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/enterprises/{enterprisesId}/policies/{policiesId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/policies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.policies.get"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/enterprises/{enterprisesId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.patch"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/enterprises/{enterprisesId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.devices.patch"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/enterprises/{enterprisesId}/policies/{policiesId}", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/policies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.policies.patch"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/enterprises", PathMatcher: regexp.MustCompile(`^(/v1/enterprises)$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.create"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/enterprises/{enterprisesId}/devices/{devicesId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.devices.operations.cancel"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/enterprises/{enterprisesId}/devices/{devicesId}:issueCommand", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:issueCommand)$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.devices.issueCommand"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/enterprises/{enterprisesId}/enrollmentTokens", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/enrollmentTokens)$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.enrollmentTokens.create"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/enterprises/{enterprisesId}/webTokens", PathMatcher: regexp.MustCompile(`^(/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/webTokens)$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.enterprises.webTokens.create"},
		{Hostname: "androidmanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/signupUrls", PathMatcher: regexp.MustCompile(`^(/v1/signupUrls)$`), ServiceName: "google.androidmanagement", ResourceName: "androidmanagement.signupUrls.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/apps/{appsId}/authorizedCertificates/{authorizedCertificatesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/apps/{appsId}/domainMappings/{domainMappingsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/apps/{appsId}/firewall/ingressRules/{ingressRulesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha/apps/{appsId}/authorizedCertificates/{authorizedCertificatesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha/apps/{appsId}/domainMappings/{domainMappingsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta/apps/{appsId}/authorizedCertificates/{authorizedCertificatesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta/apps/{appsId}/domainMappings/{domainMappingsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta/apps/{appsId}/firewall/ingressRules/{ingressRulesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.versions.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}/versions/{versionsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.versions.instances.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.delete"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/authorizedCertificates", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/authorizedCertificates/{authorizedCertificatesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/authorizedDomains", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedDomains)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedDomains.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/domainMappings", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/domainMappings/{domainMappingsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/firewall/ingressRules", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/firewall/ingressRules/{ingressRulesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/apps/{appsId}/authorizedCertificates", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/apps/{appsId}/authorizedCertificates/{authorizedCertificatesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/apps/{appsId}/authorizedDomains", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedDomains)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedDomains.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/apps/{appsId}/domainMappings", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/apps/{appsId}/domainMappings/{domainMappingsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/apps/{appsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/apps/{appsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/apps/{appsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/apps/{appsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/authorizedCertificates", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/authorizedCertificates/{authorizedCertificatesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/authorizedDomains", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedDomains)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedDomains.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/domainMappings", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/domainMappings/{domainMappingsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/firewall/ingressRules", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/firewall/ingressRules/{ingressRulesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/services", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}/versions", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}/modules", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}/versions", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.versions.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.versions.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}/versions/{versionsId}/instances", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.versions.instances.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}/versions/{versionsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.versions.instances.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta4/apps/{appsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.locations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.operations.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}/services", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}/versions", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.list"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.get"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/apps/{appsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/apps/{appsId}/authorizedCertificates/{authorizedCertificatesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/apps/{appsId}/domainMappings/{domainMappingsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/apps/{appsId}/firewall/ingressRules/{ingressRulesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1alpha/apps/{appsId}/authorizedCertificates/{authorizedCertificatesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1alpha/apps/{appsId}/domainMappings/{domainMappingsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta/apps/{appsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta/apps/{appsId}/authorizedCertificates/{authorizedCertificatesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta/apps/{appsId}/domainMappings/{domainMappingsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta/apps/{appsId}/firewall/ingressRules/{ingressRulesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta4/apps/{appsId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.versions.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta5/apps/{appsId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.patch"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps", PathMatcher: regexp.MustCompile(`^(/v1/apps)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps/{appsId}/authorizedCertificates", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps/{appsId}/domainMappings", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps/{appsId}/firewall/ingressRules", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps/{appsId}/firewall/ingressRules:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules:batchUpdate)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.batchUpdate"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}:debug", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:debug)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.debug"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}:debug", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:debug)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.debug"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps/{appsId}:repair", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:repair)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.repair"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/apps/{appsId}:repair", PathMatcher: regexp.MustCompile(`^(/v1/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:repair)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.repair"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha/apps/{appsId}/authorizedCertificates", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha/apps/{appsId}/domainMappings", PathMatcher: regexp.MustCompile(`^(/v1alpha/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta/apps", PathMatcher: regexp.MustCompile(`^(/v1beta/apps)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta/apps/{appsId}/authorizedCertificates", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/authorizedCertificates)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.authorizedCertificates.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta/apps/{appsId}/domainMappings", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainMappings)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.domainMappings.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta/apps/{appsId}/firewall/ingressRules", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta/apps/{appsId}/firewall/ingressRules:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/firewall/ingressRules:batchUpdate)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.firewall.ingressRules.batchUpdate"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}/versions", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}:debug", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:debug)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.debug"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta/apps/{appsId}:repair", PathMatcher: regexp.MustCompile(`^(/v1beta/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:repair)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.repair"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta4/apps", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}/versions", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.versions.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta4/apps/{appsId}/modules/{modulesId}/versions/{versionsId}/instances/{instancesId}:debug", PathMatcher: regexp.MustCompile(`^(/v1beta4/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/modules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:debug)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.modules.versions.instances.debug"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta5/apps", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}/versions", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.create"},
		{Hostname: "appengine.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta5/apps/{appsId}/services/{servicesId}/versions/{versionsId}/instances/{instancesId}:debug", PathMatcher: regexp.MustCompile(`^(/v1beta5/apps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:debug)$`), ServiceName: "google.appengine", ResourceName: "appengine.apps.services.versions.instances.debug"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.transferConfigs.delete"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs/{runsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/runs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.transferConfigs.runs.delete"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/transferConfigs/{transferConfigsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.transferConfigs.delete"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs/{runsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/runs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.transferConfigs.runs.delete"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/dataSources", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dataSources)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.dataSources.list"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/dataSources/{dataSourcesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dataSources/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.dataSources.get"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.list"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.get"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/dataSources", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dataSources)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.dataSources.list"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/dataSources/{dataSourcesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dataSources/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.dataSources.get"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/transferConfigs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.transferConfigs.list"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.transferConfigs.get"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/runs)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.transferConfigs.runs.list"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs/{runsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/runs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.transferConfigs.runs.get"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}/runs/{runsId}/transferLogs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/runs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferLogs)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.transferConfigs.runs.transferLogs.list"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/transferConfigs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.transferConfigs.list"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/transferConfigs/{transferConfigsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.transferConfigs.get"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/runs)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.transferConfigs.runs.list"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs/{runsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/runs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.transferConfigs.runs.get"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/transferConfigs/{transferConfigsId}/runs/{runsId}/transferLogs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/runs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferLogs)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.transferConfigs.runs.transferLogs.list"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.transferConfigs.patch"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/transferConfigs/{transferConfigsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.transferConfigs.patch"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/dataSources/{dataSourcesId}:checkValidCreds", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dataSources/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:checkValidCreds)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.dataSources.checkValidCreds"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/dataSources/{dataSourcesId}:checkValidCreds", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dataSources/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:checkValidCreds)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.dataSources.checkValidCreds"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/transferConfigs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.transferConfigs.create"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/transferConfigs/{transferConfigsId}:scheduleRuns", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:scheduleRuns)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.locations.transferConfigs.scheduleRuns"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/transferConfigs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.transferConfigs.create"},
		{Hostname: "bigquerydatatransfer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/transferConfigs/{transferConfigsId}:scheduleRuns", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/transferConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:scheduleRuns)$`), ServiceName: "google.bigquerydatatransfer", ResourceName: "bigquerydatatransfer.projects.transferConfigs.scheduleRuns"},
		{Hostname: "chat.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/spaces/{spacesId}/messages/{messagesId}", PathMatcher: regexp.MustCompile(`^(/v1/spaces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/messages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.chat", ResourceName: "chat.spaces.messages.delete"},
		{Hostname: "chat.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/spaces", PathMatcher: regexp.MustCompile(`^(/v1/spaces)$`), ServiceName: "google.chat", ResourceName: "chat.spaces.list"},
		{Hostname: "chat.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/spaces/{spacesId}", PathMatcher: regexp.MustCompile(`^(/v1/spaces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.chat", ResourceName: "chat.spaces.get"},
		{Hostname: "chat.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/spaces/{spacesId}/members", PathMatcher: regexp.MustCompile(`^(/v1/spaces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/members)$`), ServiceName: "google.chat", ResourceName: "chat.spaces.members.list"},
		{Hostname: "chat.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/spaces/{spacesId}/members/{membersId}", PathMatcher: regexp.MustCompile(`^(/v1/spaces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/members/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.chat", ResourceName: "chat.spaces.members.get"},
		{Hostname: "chat.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/spaces/{spacesId}/messages/{messagesId}", PathMatcher: regexp.MustCompile(`^(/v1/spaces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/messages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.chat", ResourceName: "chat.spaces.messages.get"},
		{Hostname: "chat.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/spaces/{spacesId}/messages", PathMatcher: regexp.MustCompile(`^(/v1/spaces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/messages)$`), ServiceName: "google.chat", ResourceName: "chat.spaces.messages.create"},
		{Hostname: "chat.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/spaces/{spacesId}/messages/{messagesId}", PathMatcher: regexp.MustCompile(`^(/v1/spaces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/messages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.chat", ResourceName: "chat.spaces.messages.update"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/courses/{courseId}/aliases/{alias}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/aliases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.aliases.delete"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/courses/{courseId}/announcements/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/announcements/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.announcements.delete"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/courses/{courseId}/courseWork/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.delete"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/courses/{courseId}/students/{userId}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/students/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.students.delete"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/courses/{courseId}/teachers/{userId}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/teachers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.teachers.delete"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/courses/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.delete"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/invitations/{id}", PathMatcher: regexp.MustCompile(`^(/v1/invitations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.invitations.delete"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/registrations/{registrationId}", PathMatcher: regexp.MustCompile(`^(/v1/registrations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.registrations.delete"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/userProfiles/{studentId}/guardians/{guardianId}", PathMatcher: regexp.MustCompile(`^(/v1/userProfiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/guardians/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.userProfiles.guardians.delete"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses", PathMatcher: regexp.MustCompile(`^(/v1/courses)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.list"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/aliases", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/aliases)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.aliases.list"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/announcements", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/announcements)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.announcements.list"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/announcements/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/announcements/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.announcements.get"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/courseWork", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.list"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/studentSubmissions)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.studentSubmissions.list"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/studentSubmissions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.studentSubmissions.get"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/courseWork/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.get"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/students", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/students)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.students.list"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/students/{userId}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/students/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.students.get"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/teachers", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/teachers)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.teachers.list"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{courseId}/teachers/{userId}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/teachers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.teachers.get"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/courses/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.get"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/invitations", PathMatcher: regexp.MustCompile(`^(/v1/invitations)$`), ServiceName: "google.classroom", ResourceName: "classroom.invitations.list"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/invitations/{id}", PathMatcher: regexp.MustCompile(`^(/v1/invitations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.invitations.get"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/userProfiles/{studentId}/guardianInvitations", PathMatcher: regexp.MustCompile(`^(/v1/userProfiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/guardianInvitations)$`), ServiceName: "google.classroom", ResourceName: "classroom.userProfiles.guardianInvitations.list"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/userProfiles/{studentId}/guardianInvitations/{invitationId}", PathMatcher: regexp.MustCompile(`^(/v1/userProfiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/guardianInvitations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.userProfiles.guardianInvitations.get"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/userProfiles/{studentId}/guardians", PathMatcher: regexp.MustCompile(`^(/v1/userProfiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/guardians)$`), ServiceName: "google.classroom", ResourceName: "classroom.userProfiles.guardians.list"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/userProfiles/{studentId}/guardians/{guardianId}", PathMatcher: regexp.MustCompile(`^(/v1/userProfiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/guardians/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.userProfiles.guardians.get"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/userProfiles/{userId}", PathMatcher: regexp.MustCompile(`^(/v1/userProfiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.userProfiles.get"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/courses/{courseId}/announcements/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/announcements/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.announcements.patch"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/studentSubmissions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.studentSubmissions.patch"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/courses/{courseId}/courseWork/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.patch"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/courses/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.patch"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/userProfiles/{studentId}/guardianInvitations/{invitationId}", PathMatcher: regexp.MustCompile(`^(/v1/userProfiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/guardianInvitations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.userProfiles.guardianInvitations.patch"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses", PathMatcher: regexp.MustCompile(`^(/v1/courses)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.create"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/aliases", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/aliases)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.aliases.create"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/announcements", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/announcements)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.announcements.create"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/announcements/{id}:modifyAssignees", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/announcements/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:modifyAssignees)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.announcements.modifyAssignees"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/courseWork", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.create"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:modifyAttachments", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/studentSubmissions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:modifyAttachments)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.studentSubmissions.modifyAttachments"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:reclaim", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/studentSubmissions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:reclaim)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.studentSubmissions.reclaim"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:return", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/studentSubmissions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:return)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.studentSubmissions.return"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/courseWork/{courseWorkId}/studentSubmissions/{id}:turnIn", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/studentSubmissions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:turnIn)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.studentSubmissions.turnIn"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/courseWork/{id}:modifyAssignees", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/courseWork/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:modifyAssignees)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.courseWork.modifyAssignees"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/students", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/students)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.students.create"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/courses/{courseId}/teachers", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/teachers)$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.teachers.create"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/invitations", PathMatcher: regexp.MustCompile(`^(/v1/invitations)$`), ServiceName: "google.classroom", ResourceName: "classroom.invitations.create"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/invitations/{id}:accept", PathMatcher: regexp.MustCompile(`^(/v1/invitations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:accept)$`), ServiceName: "google.classroom", ResourceName: "classroom.invitations.accept"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/registrations", PathMatcher: regexp.MustCompile(`^(/v1/registrations)$`), ServiceName: "google.classroom", ResourceName: "classroom.registrations.create"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/userProfiles/{studentId}/guardianInvitations", PathMatcher: regexp.MustCompile(`^(/v1/userProfiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/guardianInvitations)$`), ServiceName: "google.classroom", ResourceName: "classroom.userProfiles.guardianInvitations.create"},
		{Hostname: "classroom.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/courses/{id}", PathMatcher: regexp.MustCompile(`^(/v1/courses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.classroom", ResourceName: "classroom.courses.update"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/billingAccounts", PathMatcher: regexp.MustCompile(`^(/v1/billingAccounts)$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.billingAccounts.list"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/billingAccounts/{billingAccountsId}", PathMatcher: regexp.MustCompile(`^(/v1/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.billingAccounts.get"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/billingAccounts/{billingAccountsId}/projects", PathMatcher: regexp.MustCompile(`^(/v1/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/projects)$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.billingAccounts.projects.list"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/billingAccounts/{billingAccountsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.billingAccounts.getIamPolicy"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/billingInfo", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/billingInfo)$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.projects.getBillingInfo"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services", PathMatcher: regexp.MustCompile(`^(/v1/services)$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.services.list"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services/{servicesId}/skus", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/skus)$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.services.skus.list"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/billingAccounts/{billingAccountsId}", PathMatcher: regexp.MustCompile(`^(/v1/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.billingAccounts.patch"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/billingAccounts", PathMatcher: regexp.MustCompile(`^(/v1/billingAccounts)$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.billingAccounts.create"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/billingAccounts/{billingAccountsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.billingAccounts.setIamPolicy"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/billingAccounts/{billingAccountsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.billingAccounts.testIamPermissions"},
		{Hostname: "cloudbilling.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{projectsId}/billingInfo", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/billingInfo)$`), ServiceName: "google.cloudbilling", ResourceName: "cloudbilling.projects.updateBillingInfo"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectId}/triggers/{triggerId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/triggers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.triggers.delete"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations", PathMatcher: regexp.MustCompile(`^(/v1/operations)$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.operations.list"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.operations.get"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/builds", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/builds)$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.builds.list"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/builds/{id}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/builds/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.builds.get"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/triggers", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/triggers)$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.triggers.list"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/triggers/{triggerId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/triggers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.triggers.get"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectId}/triggers/{triggerId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/triggers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.triggers.patch"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.operations.cancel"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/builds", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/builds)$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.builds.create"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/builds/{id}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/builds/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.builds.cancel"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/builds/{id}:retry", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/builds/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:retry)$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.builds.retry"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/triggers", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/triggers)$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.triggers.create"},
		{Hostname: "cloudbuild.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/triggers/{triggerId}:run", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/triggers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:run)$`), ServiceName: "google.cloudbuild", ResourceName: "cloudbuild.projects.triggers.run"},
		{Hostname: "clouddebugger.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/debugger/debuggees/{debuggeeId}/breakpoints/{breakpointId}", PathMatcher: regexp.MustCompile(`^(/v2/debugger/debuggees/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/breakpoints/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouddebugger", ResourceName: "clouddebugger.debugger.debuggees.breakpoints.delete"},
		{Hostname: "clouddebugger.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/controller/debuggees/{debuggeeId}/breakpoints", PathMatcher: regexp.MustCompile(`^(/v2/controller/debuggees/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/breakpoints)$`), ServiceName: "google.clouddebugger", ResourceName: "clouddebugger.controller.debuggees.breakpoints.list"},
		{Hostname: "clouddebugger.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/debugger/debuggees", PathMatcher: regexp.MustCompile(`^(/v2/debugger/debuggees)$`), ServiceName: "google.clouddebugger", ResourceName: "clouddebugger.debugger.debuggees.list"},
		{Hostname: "clouddebugger.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/debugger/debuggees/{debuggeeId}/breakpoints", PathMatcher: regexp.MustCompile(`^(/v2/debugger/debuggees/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/breakpoints)$`), ServiceName: "google.clouddebugger", ResourceName: "clouddebugger.debugger.debuggees.breakpoints.list"},
		{Hostname: "clouddebugger.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/debugger/debuggees/{debuggeeId}/breakpoints/{breakpointId}", PathMatcher: regexp.MustCompile(`^(/v2/debugger/debuggees/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/breakpoints/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouddebugger", ResourceName: "clouddebugger.debugger.debuggees.breakpoints.get"},
		{Hostname: "clouddebugger.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/controller/debuggees/register", PathMatcher: regexp.MustCompile(`^(/v2/controller/debuggees/register)$`), ServiceName: "google.clouddebugger", ResourceName: "clouddebugger.controller.debuggees.register"},
		{Hostname: "clouddebugger.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/debugger/debuggees/{debuggeeId}/breakpoints/set", PathMatcher: regexp.MustCompile(`^(/v2/debugger/debuggees/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/breakpoints/set)$`), ServiceName: "google.clouddebugger", ResourceName: "clouddebugger.debugger.debuggees.breakpoints.set"},
		{Hostname: "clouddebugger.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2/controller/debuggees/{debuggeeId}/breakpoints/{id}", PathMatcher: regexp.MustCompile(`^(/v2/controller/debuggees/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/breakpoints/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouddebugger", ResourceName: "clouddebugger.controller.debuggees.breakpoints.update"},
		{Hostname: "clouderrorreporting.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/events", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/events)$`), ServiceName: "google.clouderrorreporting", ResourceName: "clouderrorreporting.projects.deleteEvents"},
		{Hostname: "clouderrorreporting.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/events", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/events)$`), ServiceName: "google.clouderrorreporting", ResourceName: "clouderrorreporting.projects.events.list"},
		{Hostname: "clouderrorreporting.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/groupStats", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groupStats)$`), ServiceName: "google.clouderrorreporting", ResourceName: "clouderrorreporting.projects.groupStats.list"},
		{Hostname: "clouderrorreporting.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/groups/{groupsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouderrorreporting", ResourceName: "clouderrorreporting.projects.groups.get"},
		{Hostname: "clouderrorreporting.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/events:report", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/events:report)$`), ServiceName: "google.clouderrorreporting", ResourceName: "clouderrorreporting.projects.events.report"},
		{Hostname: "clouderrorreporting.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/projects/{projectsId}/groups/{groupsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouderrorreporting", ResourceName: "clouderrorreporting.projects.groups.update"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/functions/{functionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.delete"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/functions/{functionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.delete"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations", PathMatcher: regexp.MustCompile(`^(/v1/operations)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.operations.list"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.operations.get"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.list"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/functions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.list"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/functions/{functionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.get"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/operations", PathMatcher: regexp.MustCompile(`^(/v1beta2/operations)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.operations.list"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.operations.get"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.list"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/functions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.list"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/functions/{functionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.get"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/functions/{functionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.patch"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/functions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.create"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/functions/{functionsId}:call", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:call)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.call"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/functions/{functionsId}:generateDownloadUrl", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:generateDownloadUrl)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.generateDownloadUrl"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/functions:generateUploadUrl", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions:generateUploadUrl)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.generateUploadUrl"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/functions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.create"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/functions/{functionsId}:call", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:call)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.call"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/functions/{functionsId}:generateDownloadUrl", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:generateDownloadUrl)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.generateDownloadUrl"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/functions:generateUploadUrl", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions:generateUploadUrl)$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.generateUploadUrl"},
		{Hostname: "cloudfunctions.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/functions/{functionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/functions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudfunctions", ResourceName: "cloudfunctions.projects.locations.functions.update"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.delete"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.delete"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/groups/{groupsId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.groups.devices.delete"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.delete"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.delete"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.list"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.get"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.list"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.get"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/configVersions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configVersions)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.configVersions.list"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/states", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/states)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.states.list"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/groups/{groupsId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.groups.devices.get"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/groups/{groupsId}/devices/{devicesId}/configVersions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configVersions)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.groups.devices.configVersions.list"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/groups/{groupsId}/devices/{devicesId}/states", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/states)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.groups.devices.states.list"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.list"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.get"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.list"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.get"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}/configVersions", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configVersions)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.configVersions.list"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.patch"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.patch"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/groups/{groupsId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.groups.devices.patch"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.patch"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.patch"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.create"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.create"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}:modifyCloudToDeviceConfig", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:modifyCloudToDeviceConfig)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.modifyCloudToDeviceConfig"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/groups/{groupsId}/devices/{devicesId}:modifyCloudToDeviceConfig", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:modifyCloudToDeviceConfig)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.groups.devices.modifyCloudToDeviceConfig"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/groups/{groupsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.groups.getIamPolicy"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/groups/{groupsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.groups.setIamPolicy"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/groups/{groupsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.groups.testIamPermissions"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.getIamPolicy"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.setIamPolicy"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.testIamPermissions"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.create"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.create"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}/devices/{devicesId}:modifyCloudToDeviceConfig", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:modifyCloudToDeviceConfig)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.devices.modifyCloudToDeviceConfig"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.getIamPolicy"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.setIamPolicy"},
		{Hostname: "cloudiot.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/registries/{registriesId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/registries/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudiot", ResourceName: "cloudiot.projects.locations.registries.testIamPermissions"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.list"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.get"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.list"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.get"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.list"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.get"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}/cryptoKeyVersions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeyVersions)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.cryptoKeyVersions.list"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}/cryptoKeyVersions/{cryptoKeyVersionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeyVersions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.cryptoKeyVersions.get"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.getIamPolicy"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.getIamPolicy"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.patch"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}/cryptoKeyVersions/{cryptoKeyVersionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeyVersions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.cryptoKeyVersions.patch"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.create"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.create"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}/cryptoKeyVersions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeyVersions)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.cryptoKeyVersions.create"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}/cryptoKeyVersions/{cryptoKeyVersionsId}:destroy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeyVersions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:destroy)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.cryptoKeyVersions.destroy"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}/cryptoKeyVersions/{cryptoKeyVersionsId}:restore", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeyVersions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:restore)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.cryptoKeyVersions.restore"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}:decrypt", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:decrypt)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.decrypt"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}:encrypt", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:encrypt)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.encrypt"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.setIamPolicy"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.testIamPermissions"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}/cryptoKeys/{cryptoKeysId}:updatePrimaryVersion", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/cryptoKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:updatePrimaryVersion)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.cryptoKeys.updatePrimaryVersion"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.setIamPolicy"},
		{Hostname: "cloudkms.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/keyRings/{keyRingsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keyRings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudkms", ResourceName: "cloudkms.projects.locations.keyRings.testIamPermissions"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/liens/{liensId}", PathMatcher: regexp.MustCompile(`^(/v1/liens/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.liens.delete"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.delete"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.delete"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/folders/{foldersId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.delete"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/folders/{foldersId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.delete"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/liens", PathMatcher: regexp.MustCompile(`^(/v1/liens)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.liens.list"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.operations.get"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/organizations/{organizationsId}", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.get"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects", PathMatcher: regexp.MustCompile(`^(/v1/projects)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.list"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects", PathMatcher: regexp.MustCompile(`^(/v1/projects)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.list"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.get"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/{+name}", PathMatcher: regexp.MustCompile(`^(/v1/)((?:(?:[\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e\x21\x23\x24\x26-\x2c\x2f\x3a\x3b\x3d\x3f\x40\x5b\x5d]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.operations.get"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/organizations", PathMatcher: regexp.MustCompile(`^(/v1beta1/organizations)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.list"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/organizations/{organizationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.get"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.list"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.get"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/folders", PathMatcher: regexp.MustCompile(`^(/v2/folders)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.list"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/folders/{foldersId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.get"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/folders", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.list"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/folders/{foldersId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.get"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/folders/{foldersId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.patch"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta1/folders/{foldersId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.patch"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/folders/{foldersId}:clearOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:clearOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.clearOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/folders/{foldersId}:getEffectiveOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getEffectiveOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.getEffectiveOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/folders/{foldersId}:getOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.getOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/folders/{foldersId}:listAvailableOrgPolicyConstraints", PathMatcher: regexp.MustCompile(`^(/v1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:listAvailableOrgPolicyConstraints)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.listAvailableOrgPolicyConstraints"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/folders/{foldersId}:listOrgPolicies", PathMatcher: regexp.MustCompile(`^(/v1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:listOrgPolicies)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.listOrgPolicies"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/folders/{foldersId}:setOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.setOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/liens", PathMatcher: regexp.MustCompile(`^(/v1/liens)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.liens.create"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}:clearOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:clearOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.clearOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}:getEffectiveOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getEffectiveOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.getEffectiveOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.getIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}:getOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.getOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}:listAvailableOrgPolicyConstraints", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:listAvailableOrgPolicyConstraints)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.listAvailableOrgPolicyConstraints"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}:listOrgPolicies", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:listOrgPolicies)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.listOrgPolicies"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.setIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}:setOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.setOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.testIamPermissions"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations:search", PathMatcher: regexp.MustCompile(`^(/v1/organizations:search)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.search"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations:search", PathMatcher: regexp.MustCompile(`^(/v1/organizations:search)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.search"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects", PathMatcher: regexp.MustCompile(`^(/v1/projects)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.create"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:getAncestry", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getAncestry)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.getAncestry"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:undelete", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:undelete)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.undelete"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}:clearOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:clearOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.clearOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}:getEffectiveOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getEffectiveOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.getEffectiveOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}:getOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.getOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}:listAvailableOrgPolicyConstraints", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:listAvailableOrgPolicyConstraints)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.listAvailableOrgPolicyConstraints"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}:listOrgPolicies", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:listOrgPolicies)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.listOrgPolicies"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}:setOrgPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setOrgPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.setOrgPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{resource}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.getIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{resource}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.setIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{resource}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.testIamPermissions"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/organizations/{organizationsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.getIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/organizations/{organizationsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.setIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/organizations/{organizationsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.testIamPermissions"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.create"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}:getAncestry", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getAncestry)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.getAncestry"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}:undelete", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:undelete)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.undelete"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{resource}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.getIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{resource}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.setIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{resource}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.testIamPermissions"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/folders", PathMatcher: regexp.MustCompile(`^(/v2/folders)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.create"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/folders/{foldersId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.getIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/folders/{foldersId}:move", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:move)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.move"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/folders/{foldersId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.setIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/folders/{foldersId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.testIamPermissions"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/folders/{foldersId}:undelete", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:undelete)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.undelete"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/folders:search", PathMatcher: regexp.MustCompile(`^(/v2/folders:search)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.search"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/folders", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.create"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/folders/{foldersId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.getIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/folders/{foldersId}:move", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:move)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.move"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/folders/{foldersId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.setIamPolicy"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/folders/{foldersId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.testIamPermissions"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/folders/{foldersId}:undelete", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:undelete)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.undelete"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/folders:search", PathMatcher: regexp.MustCompile(`^(/v2beta1/folders:search)$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.folders.search"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{projectId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.update"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/organizations/{organizationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.organizations.update"},
		{Hostname: "cloudresourcemanager.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/projects/{projectId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudresourcemanager", ResourceName: "cloudresourcemanager.projects.update"},
		{Hostname: "cloudshell.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudshell", ResourceName: "cloudshell.operations.delete"},
		{Hostname: "cloudshell.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha1/users/{usersId}/environments/{environmentsId}/publicKeys/{publicKeysId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/publicKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudshell", ResourceName: "cloudshell.users.environments.publicKeys.delete"},
		{Hostname: "cloudshell.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations", PathMatcher: regexp.MustCompile(`^(/v1/operations)$`), ServiceName: "google.cloudshell", ResourceName: "cloudshell.operations.list"},
		{Hostname: "cloudshell.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudshell", ResourceName: "cloudshell.operations.get"},
		{Hostname: "cloudshell.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/users/{usersId}/environments/{environmentsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudshell", ResourceName: "cloudshell.users.environments.get"},
		{Hostname: "cloudshell.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1alpha1/users/{usersId}/environments/{environmentsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudshell", ResourceName: "cloudshell.users.environments.patch"},
		{Hostname: "cloudshell.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.cloudshell", ResourceName: "cloudshell.operations.cancel"},
		{Hostname: "cloudshell.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/users/{usersId}/environments/{environmentsId}/publicKeys", PathMatcher: regexp.MustCompile(`^(/v1alpha1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/publicKeys)$`), ServiceName: "google.cloudshell", ResourceName: "cloudshell.users.environments.publicKeys.create"},
		{Hostname: "cloudshell.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/users/{usersId}/environments/{environmentsId}:start", PathMatcher: regexp.MustCompile(`^(/v1alpha1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:start)$`), ServiceName: "google.cloudshell", ResourceName: "cloudshell.users.environments.start"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.delete"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}/tasks/{tasksId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tasks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.tasks.delete"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/locations", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.list"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.get"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.list"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.get"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}/tasks", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tasks)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.tasks.list"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}/tasks/{tasksId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tasks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.tasks.get"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.patch"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.create"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}/tasks", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tasks)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.tasks.create"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}/tasks/{tasksId}:acknowledge", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tasks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:acknowledge)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.tasks.acknowledge"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}/tasks/{tasksId}:cancelLease", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tasks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancelLease)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.tasks.cancelLease"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}/tasks/{tasksId}:renewLease", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tasks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:renewLease)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.tasks.renewLease"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}/tasks/{tasksId}:run", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tasks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:run)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.tasks.run"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}/tasks:lease", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tasks:lease)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.tasks.lease"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.getIamPolicy"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}:pause", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:pause)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.pause"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}:purge", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:purge)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.purge"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}:resume", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:resume)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.resume"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.setIamPolicy"},
		{Hostname: "cloudtasks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/locations/{locationsId}/queues/{queuesId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/queues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.cloudtasks", ResourceName: "cloudtasks.projects.locations.queues.testIamPermissions"},
		{Hostname: "cloudtrace.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/traces", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/traces)$`), ServiceName: "google.cloudtrace", ResourceName: "cloudtrace.projects.traces.list"},
		{Hostname: "cloudtrace.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/traces/{traceId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/traces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudtrace", ResourceName: "cloudtrace.projects.traces.get"},
		{Hostname: "cloudtrace.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectId}/traces", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/traces)$`), ServiceName: "google.cloudtrace", ResourceName: "cloudtrace.projects.patchTraces"},
		{Hostname: "cloudtrace.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/traces/{tracesId}/spans/{spansId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/traces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/spans/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudtrace", ResourceName: "cloudtrace.projects.traces.spans.createSpan"},
		{Hostname: "cloudtrace.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/traces:batchWrite", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/traces:batchWrite)$`), ServiceName: "google.cloudtrace", ResourceName: "cloudtrace.projects.traces.batchWrite"},
		{Hostname: "composer.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.composer", ResourceName: "composer.projects.locations.environments.delete"},
		{Hostname: "composer.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.composer", ResourceName: "composer.projects.locations.operations.delete"},
		{Hostname: "composer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/environments", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/environments)$`), ServiceName: "google.composer", ResourceName: "composer.projects.locations.environments.list"},
		{Hostname: "composer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.composer", ResourceName: "composer.projects.locations.environments.get"},
		{Hostname: "composer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.composer", ResourceName: "composer.projects.locations.operations.list"},
		{Hostname: "composer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.composer", ResourceName: "composer.projects.locations.operations.get"},
		{Hostname: "composer.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/environments/{environmentsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.composer", ResourceName: "composer.projects.locations.environments.patch"},
		{Hostname: "composer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/environments", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/environments)$`), ServiceName: "google.composer", ResourceName: "composer.projects.locations.environments.create"},
		{Hostname: "container.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.delete"},
		{Hostname: "container.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.delete"},
		{Hostname: "container.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.delete"},
		{Hostname: "container.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.delete"},
		{Hostname: "container.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.delete"},
		{Hostname: "container.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.delete"},
		{Hostname: "container.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.delete"},
		{Hostname: "container.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.delete"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/operations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.operations.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/operations/{operationId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.operations.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/serverconfig", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serverconfig)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.getServerconfig"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.operations.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.operations.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/serverConfig", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serverConfig)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.getServerConfig"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/operations", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.operations.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/operations/{operationId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.operations.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/serverconfig", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serverconfig)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.getServerconfig"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/aggregated/usableSubnetworks", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/aggregated/usableSubnetworks)$`), ServiceName: "google.container", ResourceName: "container.projects.aggregated.usableSubnetworks.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.operations.list"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.operations.get"},
		{Hostname: "container.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/serverConfig", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serverConfig)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.getServerConfig"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.create"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/addons", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/addons)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.addons"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/legacyAbac", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/legacyAbac)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.legacyAbac"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/locations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.locations"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/logging", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logging)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.logging"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/master", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/master)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.master"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/monitoring", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/monitoring)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.monitoring"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.create"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/autoscaling", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/autoscaling)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.autoscaling"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setManagement", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/setManagement)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.setManagement"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setSize", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/setSize)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.setSize"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/update", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/update)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.update"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}:rollback", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:rollback)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.rollback"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/resourceLabels", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/resourceLabels)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.resourceLabels"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:completeIpRotation", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:completeIpRotation)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.completeIpRotation"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMaintenancePolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setMaintenancePolicy)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.setMaintenancePolicy"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMasterAuth", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setMasterAuth)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.setMasterAuth"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setNetworkPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setNetworkPolicy)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.setNetworkPolicy"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:startIpRotation", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:startIpRotation)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.startIpRotation"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/operations/{operationId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.operations.cancel"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.create"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.create"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:rollback", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:rollback)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.rollback"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setAutoscaling", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setAutoscaling)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.setAutoscaling"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setManagement", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setManagement)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.setManagement"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setSize", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setSize)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.setSize"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:completeIpRotation", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:completeIpRotation)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.completeIpRotation"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setAddons", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setAddons)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setAddons"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLegacyAbac", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setLegacyAbac)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setLegacyAbac"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLocations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setLocations)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setLocations"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLogging", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setLogging)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setLogging"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMaintenancePolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setMaintenancePolicy)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setMaintenancePolicy"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMasterAuth", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setMasterAuth)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setMasterAuth"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMonitoring", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setMonitoring)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setMonitoring"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setNetworkPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setNetworkPolicy)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setNetworkPolicy"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setResourceLabels", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setResourceLabels)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setResourceLabels"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:startIpRotation", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:startIpRotation)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.startIpRotation"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:updateMaster", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:updateMaster)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.updateMaster"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.operations.cancel"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.create"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/addons", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/addons)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.addons"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/legacyAbac", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/legacyAbac)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.legacyAbac"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/locations", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.locations"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/logging", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logging)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.logging"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/master", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/master)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.master"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/monitoring", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/monitoring)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.monitoring"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.create"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/autoscaling", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/autoscaling)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.autoscaling"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setManagement", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/setManagement)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.setManagement"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setSize", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/setSize)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.setSize"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/update", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/update)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.update"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}:rollback", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:rollback)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.nodePools.rollback"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/resourceLabels", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/resourceLabels)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.resourceLabels"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:completeIpRotation", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:completeIpRotation)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.completeIpRotation"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMaintenancePolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setMaintenancePolicy)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.setMaintenancePolicy"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMasterAuth", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setMasterAuth)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.setMasterAuth"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setNetworkPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setNetworkPolicy)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.setNetworkPolicy"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:startIpRotation", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:startIpRotation)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.startIpRotation"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/operations/{operationId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.container", ResourceName: "container.projects.zones.operations.cancel"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.create"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.create"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:rollback", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:rollback)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.rollback"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setAutoscaling", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setAutoscaling)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.setAutoscaling"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setManagement", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setManagement)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.setManagement"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}:setSize", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setSize)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.setSize"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:completeIpRotation", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:completeIpRotation)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.completeIpRotation"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setAddons", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setAddons)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setAddons"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLegacyAbac", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setLegacyAbac)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setLegacyAbac"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLocations", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setLocations)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setLocations"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setLogging", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setLogging)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setLogging"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMaintenancePolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setMaintenancePolicy)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setMaintenancePolicy"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMasterAuth", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setMasterAuth)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setMasterAuth"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setMonitoring", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setMonitoring)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setMonitoring"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setNetworkPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setNetworkPolicy)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setNetworkPolicy"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:setResourceLabels", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setResourceLabels)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.setResourceLabels"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:startIpRotation", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:startIpRotation)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.startIpRotation"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}:updateMaster", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:updateMaster)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.updateMaster"},
		{Hostname: "container.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.container", ResourceName: "container.projects.locations.operations.cancel"},
		{Hostname: "container.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.update"},
		{Hostname: "container.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.update"},
		{Hostname: "container.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.update"},
		{Hostname: "container.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/projects/{projectId}/zones/{zone}/clusters/{clusterId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.zones.clusters.update"},
		{Hostname: "container.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.update"},
		{Hostname: "container.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/clusters/{clustersId}/nodePools/{nodePoolsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodePools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.container", ResourceName: "container.projects.locations.clusters.nodePools.update"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/jobs", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.list"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.get"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/jobs/{jobId}/messages", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/messages)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.messages.list"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/jobs/{jobId}/metrics", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.getMetrics"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/jobs:aggregated", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs:aggregated)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.aggregated"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/jobs", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.jobs.list"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.jobs.get"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/messages", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/messages)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.jobs.messages.list"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/metrics", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.jobs.getMetrics"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/templates:get", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/templates:get)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.templates.get"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1b3/projects/{projectId}/templates:get", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/templates:get)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.templates.get"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/WorkerMessages", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/WorkerMessages)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.workerMessages"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/jobs", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.create"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/jobs/{jobId}/debug/getConfig", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/debug/getConfig)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.debug.getConfig"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/jobs/{jobId}/debug/sendCapture", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/debug/sendCapture)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.debug.sendCapture"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/jobs/{jobId}/workItems:lease", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workItems:lease)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.workItems.lease"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/jobs/{jobId}/workItems:reportStatus", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workItems:reportStatus)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.workItems.reportStatus"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/WorkerMessages", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/WorkerMessages)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.workerMessages"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/jobs", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.jobs.create"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/debug/getConfig", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/debug/getConfig)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.jobs.debug.getConfig"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/debug/sendCapture", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/debug/sendCapture)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.jobs.debug.sendCapture"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/workItems:lease", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workItems:lease)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.jobs.workItems.lease"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}/workItems:reportStatus", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workItems:reportStatus)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.jobs.workItems.reportStatus"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/templates", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/templates)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.templates.create"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/templates:launch", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/templates:launch)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.templates.launch"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/templates", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/templates)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.templates.create"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1b3/projects/{projectId}/templates:launch", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/templates:launch)$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.templates.launch"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1b3/projects/{projectId}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.jobs.update"},
		{Hostname: "dataflow.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1b3/projects/{projectId}/locations/{location}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1b3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataflow", ResourceName: "dataflow.projects.locations.jobs.update"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectId}/regions/{region}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectId}/regions/{region}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/regions/{regionsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.operations.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.operations.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectId}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.clusters.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectId}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.jobs.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/workflowTemplates/{workflowTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.locations.workflowTemplates.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/workflowTemplates/{workflowTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.workflowTemplates.delete"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/regions/{region}/clusters", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/regions/{region}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/regions/{region}/jobs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/regions/{region}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/regions/{regionsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/regions/{regionsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/operations", PathMatcher: regexp.MustCompile(`^(/v1alpha1/operations)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.operations.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.operations.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/clusters", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/operations", PathMatcher: regexp.MustCompile(`^(/v1beta1/operations)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.operations.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.operations.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/clusters", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.clusters.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.clusters.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/jobs", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.jobs.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectId}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.jobs.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/clusters", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/jobs", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/workflowTemplates", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.locations.workflowTemplates.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/workflowTemplates/{workflowTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.locations.workflowTemplates.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/workflowTemplates/{workflowTemplatesId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.locations.workflowTemplates.getIamPolicy"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/clusters/{clustersId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.getIamPolicy"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/jobs/{jobsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.getIamPolicy"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/operations/{operationsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.getIamPolicy"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/workflowTemplates", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.workflowTemplates.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/workflowTemplates/{workflowTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.workflowTemplates.get"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/workflowTemplates/{workflowTemplatesId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.workflowTemplates.getIamPolicy"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectId}/regions/{region}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.patch"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectId}/regions/{region}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.patch"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.patch"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.patch"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta1/projects/{projectId}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.clusters.patch"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta1/projects/{projectId}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.jobs.patch"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/clusters/{clusterName}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.patch"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/jobs/{jobId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.patch"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/regions/{region}/clusters", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.create"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:diagnose", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:diagnose)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.diagnose"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/regions/{region}/jobs/{jobId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.cancel"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/regions/{region}/jobs:submit", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs:submit)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.submit"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/regions/{regionsId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.cancel"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1alpha1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.operations.cancel"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/clusters", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.create"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/jobs/{jobId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.cancel"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/jobs:list", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs:list)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.list"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/projects/{projectId}/regions/{region}/jobs:submit", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs:submit)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.submit"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1beta1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.operations.cancel"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/clusters", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.clusters.create"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/clusters/{clusterName}:diagnose", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:diagnose)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.clusters.diagnose"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/jobs/{jobId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.jobs.cancel"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}/jobs:submit", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs:submit)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.jobs.submit"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/clusters", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.create"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/clusters/{clusterName}:diagnose", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:diagnose)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.diagnose"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/jobs/{jobId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.cancel"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectId}/regions/{region}/jobs:submit", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs:submit)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.submit"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/workflowTemplates", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.locations.workflowTemplates.create"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/workflowTemplates/{workflowTemplatesId}:instantiate", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:instantiate)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.locations.workflowTemplates.instantiate"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/workflowTemplates/{workflowTemplatesId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.locations.workflowTemplates.setIamPolicy"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/workflowTemplates/{workflowTemplatesId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.locations.workflowTemplates.testIamPermissions"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/workflowTemplates:instantiateInline", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates:instantiateInline)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.locations.workflowTemplates.instantiateInline"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/clusters/{clustersId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.setIamPolicy"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/clusters/{clustersId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.clusters.testIamPermissions"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/jobs/{jobsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.setIamPolicy"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/jobs/{jobsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.jobs.testIamPermissions"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.cancel"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/operations/{operationsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.setIamPolicy"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/operations/{operationsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.operations.testIamPermissions"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/workflowTemplates", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.workflowTemplates.create"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/workflowTemplates/{workflowTemplatesId}:instantiate", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:instantiate)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.workflowTemplates.instantiate"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/workflowTemplates/{workflowTemplatesId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.workflowTemplates.setIamPolicy"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/workflowTemplates/{workflowTemplatesId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.workflowTemplates.testIamPermissions"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/workflowTemplates:instantiateInline", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates:instantiateInline)$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.workflowTemplates.instantiateInline"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta2/projects/{projectsId}/locations/{locationsId}/workflowTemplates/{workflowTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.locations.workflowTemplates.update"},
		{Hostname: "dataproc.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta2/projects/{projectsId}/regions/{regionsId}/workflowTemplates/{workflowTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/workflowTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dataproc", ResourceName: "dataproc.projects.regions.workflowTemplates.update"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.operations.delete"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.operations.list"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.operations.get"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:allocateIds", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:allocateIds)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.allocateIds"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:beginTransaction", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:beginTransaction)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.beginTransaction"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:commit", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:commit)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.commit"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:export", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:export)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.export"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:import", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:import)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.import"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:lookup", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:lookup)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.lookup"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:reserveIds", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:reserveIds)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.reserveIds"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:rollback", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:rollback)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.rollback"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}:runQuery", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:runQuery)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.runQuery"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.operations.cancel"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}:export", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:export)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.export"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectId}:import", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:import)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.import"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta3/projects/{projectId}:allocateIds", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:allocateIds)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.allocateIds"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta3/projects/{projectId}:beginTransaction", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:beginTransaction)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.beginTransaction"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta3/projects/{projectId}:commit", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:commit)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.commit"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta3/projects/{projectId}:lookup", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:lookup)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.lookup"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta3/projects/{projectId}:reserveIds", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:reserveIds)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.reserveIds"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta3/projects/{projectId}:rollback", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:rollback)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.rollback"},
		{Hostname: "datastore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta3/projects/{projectId}:runQuery", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:runQuery)$`), ServiceName: "google.datastore", ResourceName: "datastore.projects.runQuery"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.delete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/agent/intents/{intentsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.delete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.deleteContexts"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts/{contextsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.contexts.delete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.entityTypes.delete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/agent/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.delete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.deleteContexts"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts/{contextsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.contexts.delete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.entityTypes.delete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/agent/intents/{intentsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.delete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/contexts", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.deleteContexts"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/contexts/{contextsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.contexts.delete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.entityTypes.delete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/agent", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.getAgent"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/agent/entityTypes", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.list"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/agent/intents", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.list"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/agent/intents/{intentsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.contexts.list"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts/{contextsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.contexts.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.entityTypes.list"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.entityTypes.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/agent:search", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent:search)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.search"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.operations.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.getAgent"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/entityTypes", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.list"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.contexts.list"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts/{contextsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.contexts.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/entityTypes", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.entityTypes.list"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.entityTypes.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/intents", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.list"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/intents/{intentsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/contexts", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.contexts.list"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/contexts/{contextsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.contexts.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.entityTypes.list"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.entityTypes.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/agent:search", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent:search)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.search"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.operations.get"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.patch"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/projects/{projectsId}/agent/intents/{intentsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.patch"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts/{contextsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.contexts.patch"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.entityTypes.patch"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta1/projects/{projectsId}/agent/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.patch"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts/{contextsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.contexts.patch"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.entityTypes.patch"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta1/projects/{projectsId}/agent/intents/{intentsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.patch"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/contexts/{contextsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.contexts.patch"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes/{entityTypesId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.entityTypes.patch"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/entityTypes", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.create"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}/entities:batchCreate", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entities:batchCreate)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.entities.batchCreate"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}/entities:batchDelete", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entities:batchDelete)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.entities.batchDelete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/entityTypes/{entityTypesId}/entities:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entities:batchUpdate)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.entities.batchUpdate"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/entityTypes:batchDelete", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes:batchDelete)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.batchDelete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/entityTypes:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes:batchUpdate)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.batchUpdate"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/intents", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.create"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/intents:batchDelete", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents:batchDelete)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.batchDelete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/intents:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents:batchUpdate)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.batchUpdate"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/contexts", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.contexts.create"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.entityTypes.create"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent/sessions/{sessionsId}:detectIntent", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:detectIntent)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.detectIntent"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent:export", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent:export)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.export"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent:import", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent:import)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.import"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent:restore", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent:restore)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.restore"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/agent:train", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent:train)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.train"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/entityTypes", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.create"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/entityTypes/{entityTypesId}/entities:batchCreate", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entities:batchCreate)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.entities.batchCreate"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/entityTypes/{entityTypesId}/entities:batchDelete", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entities:batchDelete)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.entities.batchDelete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/entityTypes/{entityTypesId}/entities:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entities:batchUpdate)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.entities.batchUpdate"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/entityTypes:batchDelete", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes:batchDelete)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.batchDelete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/entityTypes:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/entityTypes:batchUpdate)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.entityTypes.batchUpdate"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/contexts", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.contexts.create"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}/entityTypes", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.entityTypes.create"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/environments/{environmentsId}/users/{usersId}/sessions/{sessionsId}:detectIntent", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/environments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:detectIntent)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.environments.users.sessions.detectIntent"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/intents", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.create"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/intents:batchDelete", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents:batchDelete)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.batchDelete"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/intents:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/intents:batchUpdate)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.intents.batchUpdate"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/contexts", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contexts)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.contexts.create"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}/entityTypes", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityTypes)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.entityTypes.create"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent/sessions/{sessionsId}:detectIntent", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:detectIntent)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.sessions.detectIntent"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent:export", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent:export)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.export"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent:import", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent:import)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.import"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent:restore", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent:restore)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.restore"},
		{Hostname: "dialogflow.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/agent:train", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/agent:train)$`), ServiceName: "google.dialogflow", ResourceName: "dialogflow.projects.agent.train"},
		{Hostname: "digitalassetlinks.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/assetlinks:check", PathMatcher: regexp.MustCompile(`^(/v1/assetlinks:check)$`), ServiceName: "google.digitalassetlinks", ResourceName: "digitalassetlinks.assetlinks.check"},
		{Hostname: "digitalassetlinks.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/statements:list", PathMatcher: regexp.MustCompile(`^(/v1/statements:list)$`), ServiceName: "google.digitalassetlinks", ResourceName: "digitalassetlinks.statements.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/organizations/{organizationsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.deidentifyTemplates.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/organizations/{organizationsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.inspectTemplates.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.deidentifyTemplates.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/dlpJobs/{dlpJobsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dlpJobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dlpJobs.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.inspectTemplates.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/jobTriggers/{jobTriggersId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobTriggers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.jobTriggers.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/inspect/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/inspect/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.inspect.operations.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/riskAnalysis/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/riskAnalysis/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.riskAnalysis.operations.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta2/organizations/{organizationsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.deidentifyTemplates.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta2/organizations/{organizationsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.inspectTemplates.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta2/projects/{projectsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.deidentifyTemplates.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta2/projects/{projectsId}/dlpJobs/{dlpJobsId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dlpJobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dlpJobs.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta2/projects/{projectsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.inspectTemplates.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta2/projects/{projectsId}/jobTriggers/{jobTriggersId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobTriggers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.jobTriggers.delete"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/infoTypes", PathMatcher: regexp.MustCompile(`^(/v2/infoTypes)$`), ServiceName: "google.dlp", ResourceName: "dlp.infoTypes.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/organizations/{organizationsId}/deidentifyTemplates", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.deidentifyTemplates.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/organizations/{organizationsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.deidentifyTemplates.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/organizations/{organizationsId}/inspectTemplates", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.inspectTemplates.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/organizations/{organizationsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.inspectTemplates.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/deidentifyTemplates", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.deidentifyTemplates.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.deidentifyTemplates.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/dlpJobs", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dlpJobs)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dlpJobs.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/dlpJobs/{dlpJobsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dlpJobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dlpJobs.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/inspectTemplates", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.inspectTemplates.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.inspectTemplates.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/jobTriggers", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobTriggers)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.jobTriggers.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/jobTriggers/{jobTriggersId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobTriggers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.jobTriggers.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/inspect/operations", PathMatcher: regexp.MustCompile(`^(/v2beta1/inspect/operations)$`), ServiceName: "google.dlp", ResourceName: "dlp.inspect.operations.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/inspect/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/inspect/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.inspect.operations.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/inspect/results/{resultsId}/findings", PathMatcher: regexp.MustCompile(`^(/v2beta1/inspect/results/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/findings)$`), ServiceName: "google.dlp", ResourceName: "dlp.inspect.results.findings.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/riskAnalysis/operations", PathMatcher: regexp.MustCompile(`^(/v2beta1/riskAnalysis/operations)$`), ServiceName: "google.dlp", ResourceName: "dlp.riskAnalysis.operations.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/riskAnalysis/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/riskAnalysis/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.riskAnalysis.operations.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/rootCategories", PathMatcher: regexp.MustCompile(`^(/v2beta1/rootCategories)$`), ServiceName: "google.dlp", ResourceName: "dlp.rootCategories.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/rootCategories/{rootCategoriesId}/infoTypes", PathMatcher: regexp.MustCompile(`^(/v2beta1/rootCategories/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/infoTypes)$`), ServiceName: "google.dlp", ResourceName: "dlp.rootCategories.infoTypes.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/infoTypes", PathMatcher: regexp.MustCompile(`^(/v2beta2/infoTypes)$`), ServiceName: "google.dlp", ResourceName: "dlp.infoTypes.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/organizations/{organizationsId}/deidentifyTemplates", PathMatcher: regexp.MustCompile(`^(/v2beta2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.deidentifyTemplates.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/organizations/{organizationsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.deidentifyTemplates.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/organizations/{organizationsId}/inspectTemplates", PathMatcher: regexp.MustCompile(`^(/v2beta2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.inspectTemplates.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/organizations/{organizationsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.inspectTemplates.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/deidentifyTemplates", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.deidentifyTemplates.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.deidentifyTemplates.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/dlpJobs", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dlpJobs)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dlpJobs.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/dlpJobs/{dlpJobsId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dlpJobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dlpJobs.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/inspectTemplates", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.inspectTemplates.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.inspectTemplates.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/jobTriggers", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobTriggers)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.jobTriggers.list"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta2/projects/{projectsId}/jobTriggers/{jobTriggersId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobTriggers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.jobTriggers.get"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/organizations/{organizationsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.deidentifyTemplates.patch"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/organizations/{organizationsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.inspectTemplates.patch"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/projects/{projectsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.deidentifyTemplates.patch"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/projects/{projectsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.inspectTemplates.patch"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/projects/{projectsId}/jobTriggers/{jobTriggersId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobTriggers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.jobTriggers.patch"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta2/organizations/{organizationsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.deidentifyTemplates.patch"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta2/organizations/{organizationsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.inspectTemplates.patch"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta2/projects/{projectsId}/deidentifyTemplates/{deidentifyTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.deidentifyTemplates.patch"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta2/projects/{projectsId}/inspectTemplates/{inspectTemplatesId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.inspectTemplates.patch"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2beta2/projects/{projectsId}/jobTriggers/{jobTriggersId}", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobTriggers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.jobTriggers.patch"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/organizations/{organizationsId}/deidentifyTemplates", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.deidentifyTemplates.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/organizations/{organizationsId}/inspectTemplates", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.inspectTemplates.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/content:deidentify", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/content:deidentify)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.content.deidentify"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/content:inspect", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/content:inspect)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.content.inspect"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/content:reidentify", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/content:reidentify)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.content.reidentify"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/deidentifyTemplates", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.deidentifyTemplates.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/dlpJobs", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dlpJobs)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dlpJobs.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/dlpJobs/{dlpJobsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dlpJobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dlpJobs.cancel"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/image:redact", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/image:redact)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.image.redact"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/inspectTemplates", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.inspectTemplates.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/jobTriggers", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobTriggers)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.jobTriggers.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/content:deidentify", PathMatcher: regexp.MustCompile(`^(/v2beta1/content:deidentify)$`), ServiceName: "google.dlp", ResourceName: "dlp.content.deidentify"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/content:inspect", PathMatcher: regexp.MustCompile(`^(/v2beta1/content:inspect)$`), ServiceName: "google.dlp", ResourceName: "dlp.content.inspect"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/content:redact", PathMatcher: regexp.MustCompile(`^(/v2beta1/content:redact)$`), ServiceName: "google.dlp", ResourceName: "dlp.content.redact"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/dataSource:analyze", PathMatcher: regexp.MustCompile(`^(/v2beta1/dataSource:analyze)$`), ServiceName: "google.dlp", ResourceName: "dlp.dataSource.analyze"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/inspect/operations", PathMatcher: regexp.MustCompile(`^(/v2beta1/inspect/operations)$`), ServiceName: "google.dlp", ResourceName: "dlp.inspect.operations.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/inspect/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v2beta1/inspect/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dlp", ResourceName: "dlp.inspect.operations.cancel"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/riskAnalysis/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v2beta1/riskAnalysis/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dlp", ResourceName: "dlp.riskAnalysis.operations.cancel"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/organizations/{organizationsId}/deidentifyTemplates", PathMatcher: regexp.MustCompile(`^(/v2beta2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.deidentifyTemplates.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/organizations/{organizationsId}/inspectTemplates", PathMatcher: regexp.MustCompile(`^(/v2beta2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.organizations.inspectTemplates.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/content:deidentify", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/content:deidentify)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.content.deidentify"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/content:inspect", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/content:inspect)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.content.inspect"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/content:reidentify", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/content:reidentify)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.content.reidentify"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/dataSource:analyze", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dataSource:analyze)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dataSource.analyze"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/dataSource:inspect", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dataSource:inspect)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dataSource.inspect"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/deidentifyTemplates", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deidentifyTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.deidentifyTemplates.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/dlpJobs/{dlpJobsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dlpJobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.dlpJobs.cancel"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/image:redact", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/image:redact)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.image.redact"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/inspectTemplates", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inspectTemplates)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.inspectTemplates.create"},
		{Hostname: "dlp.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta2/projects/{projectsId}/jobTriggers", PathMatcher: regexp.MustCompile(`^(/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobTriggers)$`), ServiceName: "google.dlp", ResourceName: "dlp.projects.jobTriggers.create"},
		{Hostname: "firebasedynamiclinks.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/{dynamicLink}/linkStats", PathMatcher: regexp.MustCompile(`^(/v1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/linkStats)$`), ServiceName: "google.firebasedynamiclinks", ResourceName: "firebasedynamiclinks.getLinkStats"},
		{Hostname: "firebasedynamiclinks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/installAttribution", PathMatcher: regexp.MustCompile(`^(/v1/installAttribution)$`), ServiceName: "google.firebasedynamiclinks", ResourceName: "firebasedynamiclinks.installAttribution"},
		{Hostname: "firebasedynamiclinks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/managedShortLinks:create", PathMatcher: regexp.MustCompile(`^(/v1/managedShortLinks:create)$`), ServiceName: "google.firebasedynamiclinks", ResourceName: "firebasedynamiclinks.managedShortLinks.create"},
		{Hostname: "firebasedynamiclinks.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/shortLinks", PathMatcher: regexp.MustCompile(`^(/v1/shortLinks)$`), ServiceName: "google.firebasedynamiclinks", ResourceName: "firebasedynamiclinks.shortLinks.create"},
		{Hostname: "firebaseremoteconfig.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/remoteConfig", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/remoteConfig)$`), ServiceName: "google.firebaseremoteconfig", ResourceName: "firebaseremoteconfig.projects.getRemoteConfig"},
		{Hostname: "firebaseremoteconfig.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{projectsId}/remoteConfig", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/remoteConfig)$`), ServiceName: "google.firebaseremoteconfig", ResourceName: "firebaseremoteconfig.projects.updateRemoteConfig"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/releases/{releasesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/releases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.releases.delete"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/rulesets/{rulesetsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/rulesets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.rulesets.delete"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/releases", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/releases)$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.releases.list"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/releases/{releasesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/releases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.releases.get"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/releases/{releasesId}:getExecutable", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/releases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getExecutable)$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.releases.getExecutable"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/rulesets", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/rulesets)$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.rulesets.list"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/rulesets/{rulesetsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/rulesets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.rulesets.get"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/releases/{releasesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/releases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.releases.patch"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/releases", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/releases)$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.releases.create"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/rulesets", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/rulesets)$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.rulesets.create"},
		{Hostname: "firebaserules.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}:test", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:test)$`), ServiceName: "google.firebaserules", ResourceName: "firebaserules.projects.test"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents/{documentsId}/{documentsId1}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.delete"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/indexes/{indexesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/indexes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.indexes.delete"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents/{documentsId}/{documentsId1}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.get"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents/{documentsId}/{documentsId1}/{collectionId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.list"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/indexes", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/indexes)$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.indexes.list"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/indexes/{indexesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/indexes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.indexes.get"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents/{documentsId}/{documentsId1}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.patch"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents/{documentsId}/{collectionId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.createDocument"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents/{documentsId}/{documentsId1}:listCollectionIds", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:listCollectionIds)$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.listCollectionIds"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents/{documentsId}/{documentsId1}:runQuery", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:runQuery)$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.runQuery"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents:batchGet", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents:batchGet)$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.batchGet"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents:beginTransaction", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents:beginTransaction)$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.beginTransaction"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents:commit", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents:commit)$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.commit"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents:listen", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents:listen)$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.listen"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents:rollback", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents:rollback)$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.rollback"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/documents:write", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/documents:write)$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.documents.write"},
		{Hostname: "firestore.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/databases/{databasesId}/indexes", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/indexes)$`), ServiceName: "google.firestore", ResourceName: "firestore.projects.databases.indexes.create"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/annotations/{annotationId}", PathMatcher: regexp.MustCompile(`^(/v1/annotations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.annotations.delete"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/annotationsets/{annotationSetId}", PathMatcher: regexp.MustCompile(`^(/v1/annotationsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.annotationsets.delete"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/callsets/{callSetId}", PathMatcher: regexp.MustCompile(`^(/v1/callsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.callsets.delete"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/datasets/{datasetId}", PathMatcher: regexp.MustCompile(`^(/v1/datasets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.datasets.delete"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/readgroupsets/{readGroupSetId}", PathMatcher: regexp.MustCompile(`^(/v1/readgroupsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.readgroupsets.delete"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/variants/{variantId}", PathMatcher: regexp.MustCompile(`^(/v1/variants/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.variants.delete"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/variantsets/{variantSetId}", PathMatcher: regexp.MustCompile(`^(/v1/variantsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.variantsets.delete"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha2/pipelines/{pipelineId}", PathMatcher: regexp.MustCompile(`^(/v1alpha2/pipelines/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.pipelines.delete"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/annotations/{annotationId}", PathMatcher: regexp.MustCompile(`^(/v1/annotations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.annotations.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/annotationsets/{annotationSetId}", PathMatcher: regexp.MustCompile(`^(/v1/annotationsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.annotationsets.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/callsets/{callSetId}", PathMatcher: regexp.MustCompile(`^(/v1/callsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.callsets.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/datasets", PathMatcher: regexp.MustCompile(`^(/v1/datasets)$`), ServiceName: "google.genomics", ResourceName: "genomics.datasets.list"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/datasets/{datasetId}", PathMatcher: regexp.MustCompile(`^(/v1/datasets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.datasets.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations", PathMatcher: regexp.MustCompile(`^(/v1/operations)$`), ServiceName: "google.genomics", ResourceName: "genomics.operations.list"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.operations.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/readgroupsets/{readGroupSetId}", PathMatcher: regexp.MustCompile(`^(/v1/readgroupsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.readgroupsets.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/readgroupsets/{readGroupSetId}/coveragebuckets", PathMatcher: regexp.MustCompile(`^(/v1/readgroupsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/coveragebuckets)$`), ServiceName: "google.genomics", ResourceName: "genomics.readgroupsets.coveragebuckets.list"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/references/{referenceId}", PathMatcher: regexp.MustCompile(`^(/v1/references/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.references.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/references/{referenceId}/bases", PathMatcher: regexp.MustCompile(`^(/v1/references/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/bases)$`), ServiceName: "google.genomics", ResourceName: "genomics.references.bases.list"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/referencesets/{referenceSetId}", PathMatcher: regexp.MustCompile(`^(/v1/referencesets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.referencesets.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/variants/{variantId}", PathMatcher: regexp.MustCompile(`^(/v1/variants/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.variants.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/variantsets/{variantSetId}", PathMatcher: regexp.MustCompile(`^(/v1/variantsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.variantsets.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha2/operations", PathMatcher: regexp.MustCompile(`^(/v1alpha2/operations)$`), ServiceName: "google.genomics", ResourceName: "genomics.operations.list"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha2/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha2/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.operations.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha2/pipelines", PathMatcher: regexp.MustCompile(`^(/v1alpha2/pipelines)$`), ServiceName: "google.genomics", ResourceName: "genomics.pipelines.list"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha2/pipelines/{pipelineId}", PathMatcher: regexp.MustCompile(`^(/v1alpha2/pipelines/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.pipelines.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha2/pipelines:getControllerConfig", PathMatcher: regexp.MustCompile(`^(/v1alpha2/pipelines:getControllerConfig)$`), ServiceName: "google.genomics", ResourceName: "genomics.pipelines.getControllerConfig"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2alpha1/projects/{projectsId}/operations", PathMatcher: regexp.MustCompile(`^(/v2alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.genomics", ResourceName: "genomics.projects.operations.list"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2alpha1/projects/{projectsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v2alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.projects.operations.get"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/callsets/{callSetId}", PathMatcher: regexp.MustCompile(`^(/v1/callsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.callsets.patch"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/datasets/{datasetId}", PathMatcher: regexp.MustCompile(`^(/v1/datasets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.datasets.patch"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/readgroupsets/{readGroupSetId}", PathMatcher: regexp.MustCompile(`^(/v1/readgroupsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.readgroupsets.patch"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/variants/{variantId}", PathMatcher: regexp.MustCompile(`^(/v1/variants/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.variants.patch"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/variantsets/{variantSetId}", PathMatcher: regexp.MustCompile(`^(/v1/variantsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.variantsets.patch"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/annotations", PathMatcher: regexp.MustCompile(`^(/v1/annotations)$`), ServiceName: "google.genomics", ResourceName: "genomics.annotations.create"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/annotations/search", PathMatcher: regexp.MustCompile(`^(/v1/annotations/search)$`), ServiceName: "google.genomics", ResourceName: "genomics.annotations.search"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/annotations:batchCreate", PathMatcher: regexp.MustCompile(`^(/v1/annotations:batchCreate)$`), ServiceName: "google.genomics", ResourceName: "genomics.annotations.batchCreate"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/annotationsets", PathMatcher: regexp.MustCompile(`^(/v1/annotationsets)$`), ServiceName: "google.genomics", ResourceName: "genomics.annotationsets.create"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/annotationsets/search", PathMatcher: regexp.MustCompile(`^(/v1/annotationsets/search)$`), ServiceName: "google.genomics", ResourceName: "genomics.annotationsets.search"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/callsets", PathMatcher: regexp.MustCompile(`^(/v1/callsets)$`), ServiceName: "google.genomics", ResourceName: "genomics.callsets.create"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/callsets/search", PathMatcher: regexp.MustCompile(`^(/v1/callsets/search)$`), ServiceName: "google.genomics", ResourceName: "genomics.callsets.search"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/datasets", PathMatcher: regexp.MustCompile(`^(/v1/datasets)$`), ServiceName: "google.genomics", ResourceName: "genomics.datasets.create"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/datasets/{datasetId}:undelete", PathMatcher: regexp.MustCompile(`^(/v1/datasets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:undelete)$`), ServiceName: "google.genomics", ResourceName: "genomics.datasets.undelete"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/datasets/{datasetsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/datasets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.genomics", ResourceName: "genomics.datasets.getIamPolicy"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/datasets/{datasetsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/datasets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.genomics", ResourceName: "genomics.datasets.setIamPolicy"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/datasets/{datasetsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/datasets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.genomics", ResourceName: "genomics.datasets.testIamPermissions"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.genomics", ResourceName: "genomics.operations.cancel"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/readgroupsets/search", PathMatcher: regexp.MustCompile(`^(/v1/readgroupsets/search)$`), ServiceName: "google.genomics", ResourceName: "genomics.readgroupsets.search"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/readgroupsets/{readGroupSetId}:export", PathMatcher: regexp.MustCompile(`^(/v1/readgroupsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:export)$`), ServiceName: "google.genomics", ResourceName: "genomics.readgroupsets.export"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/readgroupsets:import", PathMatcher: regexp.MustCompile(`^(/v1/readgroupsets:import)$`), ServiceName: "google.genomics", ResourceName: "genomics.readgroupsets.import"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/reads/search", PathMatcher: regexp.MustCompile(`^(/v1/reads/search)$`), ServiceName: "google.genomics", ResourceName: "genomics.reads.search"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/references/search", PathMatcher: regexp.MustCompile(`^(/v1/references/search)$`), ServiceName: "google.genomics", ResourceName: "genomics.references.search"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/referencesets/search", PathMatcher: regexp.MustCompile(`^(/v1/referencesets/search)$`), ServiceName: "google.genomics", ResourceName: "genomics.referencesets.search"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/variants", PathMatcher: regexp.MustCompile(`^(/v1/variants)$`), ServiceName: "google.genomics", ResourceName: "genomics.variants.create"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/variants/search", PathMatcher: regexp.MustCompile(`^(/v1/variants/search)$`), ServiceName: "google.genomics", ResourceName: "genomics.variants.search"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/variants:import", PathMatcher: regexp.MustCompile(`^(/v1/variants:import)$`), ServiceName: "google.genomics", ResourceName: "genomics.variants.import"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/variants:merge", PathMatcher: regexp.MustCompile(`^(/v1/variants:merge)$`), ServiceName: "google.genomics", ResourceName: "genomics.variants.merge"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/variantsets", PathMatcher: regexp.MustCompile(`^(/v1/variantsets)$`), ServiceName: "google.genomics", ResourceName: "genomics.variantsets.create"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/variantsets/search", PathMatcher: regexp.MustCompile(`^(/v1/variantsets/search)$`), ServiceName: "google.genomics", ResourceName: "genomics.variantsets.search"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/variantsets/{variantSetId}:export", PathMatcher: regexp.MustCompile(`^(/v1/variantsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:export)$`), ServiceName: "google.genomics", ResourceName: "genomics.variantsets.export"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha2/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1alpha2/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.genomics", ResourceName: "genomics.operations.cancel"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha2/pipelines", PathMatcher: regexp.MustCompile(`^(/v1alpha2/pipelines)$`), ServiceName: "google.genomics", ResourceName: "genomics.pipelines.create"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha2/pipelines:run", PathMatcher: regexp.MustCompile(`^(/v1alpha2/pipelines:run)$`), ServiceName: "google.genomics", ResourceName: "genomics.pipelines.run"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2alpha1/pipelines:run", PathMatcher: regexp.MustCompile(`^(/v2alpha1/pipelines:run)$`), ServiceName: "google.genomics", ResourceName: "genomics.pipelines.run"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2alpha1/projects/{projectsId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v2alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.genomics", ResourceName: "genomics.projects.operations.cancel"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2alpha1/workers/{id}:checkIn", PathMatcher: regexp.MustCompile(`^(/v2alpha1/workers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:checkIn)$`), ServiceName: "google.genomics", ResourceName: "genomics.workers.checkIn"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/annotations/{annotationId}", PathMatcher: regexp.MustCompile(`^(/v1/annotations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.annotations.update"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/annotationsets/{annotationSetId}", PathMatcher: regexp.MustCompile(`^(/v1/annotationsets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.genomics", ResourceName: "genomics.annotationsets.update"},
		{Hostname: "genomics.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1alpha2/pipelines:setOperationStatus", PathMatcher: regexp.MustCompile(`^(/v1alpha2/pipelines:setOperationStatus)$`), ServiceName: "google.genomics", ResourceName: "genomics.pipelines.setOperationStatus"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/organizations/{organizationsId}/roles/{rolesId}", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.organizations.roles.delete"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/roles/{rolesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.projects.roles.delete"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.delete"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys/{keysId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.keys.delete"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/organizations/{organizationsId}/roles", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles)$`), ServiceName: "google.iam", ResourceName: "iam.organizations.roles.list"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/organizations/{organizationsId}/roles/{rolesId}", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.organizations.roles.get"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/roles", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles)$`), ServiceName: "google.iam", ResourceName: "iam.projects.roles.list"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/roles/{rolesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.projects.roles.get"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts)$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.list"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.get"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keys)$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.keys.list"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys/{keysId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.keys.get"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/roles", PathMatcher: regexp.MustCompile(`^(/v1/roles)$`), ServiceName: "google.iam", ResourceName: "iam.roles.list"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/roles/{rolesId}", PathMatcher: regexp.MustCompile(`^(/v1/roles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.roles.get"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/organizations/{organizationsId}/roles/{rolesId}", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.organizations.roles.patch"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/roles/{rolesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.projects.roles.patch"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/iamPolicies:queryAuditableServices", PathMatcher: regexp.MustCompile(`^(/v1/iamPolicies:queryAuditableServices)$`), ServiceName: "google.iam", ResourceName: "iam.iamPolicies.queryAuditableServices"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}/roles", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles)$`), ServiceName: "google.iam", ResourceName: "iam.organizations.roles.create"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/organizations/{organizationsId}/roles/{rolesId}:undelete", PathMatcher: regexp.MustCompile(`^(/v1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:undelete)$`), ServiceName: "google.iam", ResourceName: "iam.organizations.roles.undelete"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/permissions:queryTestablePermissions", PathMatcher: regexp.MustCompile(`^(/v1/permissions:queryTestablePermissions)$`), ServiceName: "google.iam", ResourceName: "iam.permissions.queryTestablePermissions"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/roles", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles)$`), ServiceName: "google.iam", ResourceName: "iam.projects.roles.create"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/roles/{rolesId}:undelete", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:undelete)$`), ServiceName: "google.iam", ResourceName: "iam.projects.roles.undelete"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts)$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.create"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/keys)$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.keys.create"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.getIamPolicy"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.setIamPolicy"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:signBlob", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:signBlob)$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.signBlob"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:signJwt", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:signJwt)$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.signJwt"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.testIamPermissions"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/roles:queryGrantableRoles", PathMatcher: regexp.MustCompile(`^(/v1/roles:queryGrantableRoles)$`), ServiceName: "google.iam", ResourceName: "iam.roles.queryGrantableRoles"},
		{Hostname: "iam.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.iam", ResourceName: "iam.projects.serviceAccounts.update"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/companies/{companiesId}", PathMatcher: regexp.MustCompile(`^(/v2/companies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.jobs", ResourceName: "jobs.companies.delete"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/jobs/{jobsId}", PathMatcher: regexp.MustCompile(`^(/v2/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.jobs", ResourceName: "jobs.jobs.delete"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/companies", PathMatcher: regexp.MustCompile(`^(/v2/companies)$`), ServiceName: "google.jobs", ResourceName: "jobs.companies.list"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/companies/{companiesId}", PathMatcher: regexp.MustCompile(`^(/v2/companies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.jobs", ResourceName: "jobs.companies.get"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/companies/{companiesId}/jobs", PathMatcher: regexp.MustCompile(`^(/v2/companies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs)$`), ServiceName: "google.jobs", ResourceName: "jobs.companies.jobs.list"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/jobs", PathMatcher: regexp.MustCompile(`^(/v2/jobs)$`), ServiceName: "google.jobs", ResourceName: "jobs.jobs.list"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/jobs/{jobsId}", PathMatcher: regexp.MustCompile(`^(/v2/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.jobs", ResourceName: "jobs.jobs.get"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2:complete", PathMatcher: regexp.MustCompile(`^(/v2:complete)$`), ServiceName: "google.jobs", ResourceName: "jobs.complete"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/companies/{companiesId}", PathMatcher: regexp.MustCompile(`^(/v2/companies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.jobs", ResourceName: "jobs.companies.patch"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/jobs/{jobsId}", PathMatcher: regexp.MustCompile(`^(/v2/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.jobs", ResourceName: "jobs.jobs.patch"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/companies", PathMatcher: regexp.MustCompile(`^(/v2/companies)$`), ServiceName: "google.jobs", ResourceName: "jobs.companies.create"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/jobs", PathMatcher: regexp.MustCompile(`^(/v2/jobs)$`), ServiceName: "google.jobs", ResourceName: "jobs.jobs.create"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/jobs:batchDelete", PathMatcher: regexp.MustCompile(`^(/v2/jobs:batchDelete)$`), ServiceName: "google.jobs", ResourceName: "jobs.jobs.batchDelete"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/jobs:deleteByFilter", PathMatcher: regexp.MustCompile(`^(/v2/jobs:deleteByFilter)$`), ServiceName: "google.jobs", ResourceName: "jobs.jobs.deleteByFilter"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/jobs:histogram", PathMatcher: regexp.MustCompile(`^(/v2/jobs:histogram)$`), ServiceName: "google.jobs", ResourceName: "jobs.jobs.histogram"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/jobs:search", PathMatcher: regexp.MustCompile(`^(/v2/jobs:search)$`), ServiceName: "google.jobs", ResourceName: "jobs.jobs.search"},
		{Hostname: "jobs.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/jobs:searchForAlert", PathMatcher: regexp.MustCompile(`^(/v2/jobs:searchForAlert)$`), ServiceName: "google.jobs", ResourceName: "jobs.jobs.searchForAlert"},
		{Hostname: "kgsearch.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/entities:search", PathMatcher: regexp.MustCompile(`^(/v1/entities:search)$`), ServiceName: "google.kgsearch", ResourceName: "kgsearch.entities.search"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/documents:analyzeEntities", PathMatcher: regexp.MustCompile(`^(/v1/documents:analyzeEntities)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeEntities"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/documents:analyzeEntitySentiment", PathMatcher: regexp.MustCompile(`^(/v1/documents:analyzeEntitySentiment)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeEntitySentiment"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/documents:analyzeSentiment", PathMatcher: regexp.MustCompile(`^(/v1/documents:analyzeSentiment)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeSentiment"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/documents:analyzeSyntax", PathMatcher: regexp.MustCompile(`^(/v1/documents:analyzeSyntax)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeSyntax"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/documents:annotateText", PathMatcher: regexp.MustCompile(`^(/v1/documents:annotateText)$`), ServiceName: "google.language", ResourceName: "language.documents.annotateText"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/documents:classifyText", PathMatcher: regexp.MustCompile(`^(/v1/documents:classifyText)$`), ServiceName: "google.language", ResourceName: "language.documents.classifyText"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/documents:analyzeEntities", PathMatcher: regexp.MustCompile(`^(/v1beta1/documents:analyzeEntities)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeEntities"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/documents:analyzeSentiment", PathMatcher: regexp.MustCompile(`^(/v1beta1/documents:analyzeSentiment)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeSentiment"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/documents:analyzeSyntax", PathMatcher: regexp.MustCompile(`^(/v1beta1/documents:analyzeSyntax)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeSyntax"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/documents:annotateText", PathMatcher: regexp.MustCompile(`^(/v1beta1/documents:annotateText)$`), ServiceName: "google.language", ResourceName: "language.documents.annotateText"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/documents:analyzeEntities", PathMatcher: regexp.MustCompile(`^(/v1beta2/documents:analyzeEntities)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeEntities"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/documents:analyzeEntitySentiment", PathMatcher: regexp.MustCompile(`^(/v1beta2/documents:analyzeEntitySentiment)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeEntitySentiment"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/documents:analyzeSentiment", PathMatcher: regexp.MustCompile(`^(/v1beta2/documents:analyzeSentiment)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeSentiment"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/documents:analyzeSyntax", PathMatcher: regexp.MustCompile(`^(/v1beta2/documents:analyzeSyntax)$`), ServiceName: "google.language", ResourceName: "language.documents.analyzeSyntax"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/documents:annotateText", PathMatcher: regexp.MustCompile(`^(/v1beta2/documents:annotateText)$`), ServiceName: "google.language", ResourceName: "language.documents.annotateText"},
		{Hostname: "language.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/documents:classifyText", PathMatcher: regexp.MustCompile(`^(/v1beta2/documents:classifyText)$`), ServiceName: "google.language", ResourceName: "language.documents.classifyText"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta3/projects/{projectsId}/logServices/{logServicesId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.logServices.sinks.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta3/projects/{projectsId}/logs/{logsId}", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta3/projects/{projectsId}/logs/{logsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.sinks.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.exclusions.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/logs/{logsId}", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.logs.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.sinks.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/folders/{foldersId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.folders.exclusions.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/folders/{foldersId}/logs/{logsId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.folders.logs.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/folders/{foldersId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.folders.sinks.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/organizations/{organizationsId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.organizations.exclusions.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/organizations/{organizationsId}/logs/{logsId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.organizations.logs.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/organizations/{organizationsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.organizations.sinks.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.exclusions.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/logs/{logsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/metrics/{metricsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.metrics.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/projects/{projectsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/{v2Id}/{v2Id1}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.exclusions.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/{v2Id}/{v2Id1}/logs/{logsId}", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.logs.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/{v2Id}/{v2Id1}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.sinks.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/billingAccounts/{billingAccountsId}/logs/{logsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.logs.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/organizations/{organizationsId}/logs/{logsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.organizations.logs.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/logs/{logsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/metrics/{metricsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.metrics.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2beta1/projects/{projectsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.delete"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta3/projects/{projectsId}/logServices", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logServices)$`), ServiceName: "google.logging", ResourceName: "logging.projects.logServices.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta3/projects/{projectsId}/logServices/{logServicesId}/indexes", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/indexes)$`), ServiceName: "google.logging", ResourceName: "logging.projects.logServices.indexes.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta3/projects/{projectsId}/logServices/{logServicesId}/sinks", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.projects.logServices.sinks.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta3/projects/{projectsId}/logServices/{logServicesId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.logServices.sinks.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta3/projects/{projectsId}/logs", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs)$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta3/projects/{projectsId}/logs/{logsId}/sinks", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.sinks.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta3/projects/{projectsId}/logs/{logsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.sinks.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/exclusions", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions)$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.exclusions.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.exclusions.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/logs", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs)$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.logs.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/sinks", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.sinks.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.sinks.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/folders/{foldersId}/exclusions", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions)$`), ServiceName: "google.logging", ResourceName: "logging.folders.exclusions.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/folders/{foldersId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.folders.exclusions.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/folders/{foldersId}/logs", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs)$`), ServiceName: "google.logging", ResourceName: "logging.folders.logs.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/folders/{foldersId}/sinks", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.folders.sinks.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/folders/{foldersId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.folders.sinks.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/monitoredResourceDescriptors", PathMatcher: regexp.MustCompile(`^(/v2/monitoredResourceDescriptors)$`), ServiceName: "google.logging", ResourceName: "logging.monitoredResourceDescriptors.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/organizations/{organizationsId}/exclusions", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions)$`), ServiceName: "google.logging", ResourceName: "logging.organizations.exclusions.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/organizations/{organizationsId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.organizations.exclusions.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/organizations/{organizationsId}/logs", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs)$`), ServiceName: "google.logging", ResourceName: "logging.organizations.logs.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/organizations/{organizationsId}/sinks", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.organizations.sinks.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/organizations/{organizationsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.organizations.sinks.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/exclusions", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions)$`), ServiceName: "google.logging", ResourceName: "logging.projects.exclusions.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.exclusions.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/logs", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs)$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/metrics", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics)$`), ServiceName: "google.logging", ResourceName: "logging.projects.metrics.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/metrics/{metricsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.metrics.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/sinks", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/{v2Id}/{v2Id1}/exclusions", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions)$`), ServiceName: "google.logging", ResourceName: "logging.exclusions.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/{v2Id}/{v2Id1}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.exclusions.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/{v2Id}/{v2Id1}/logs", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs)$`), ServiceName: "google.logging", ResourceName: "logging.logs.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/{v2Id}/{v2Id1}/sinks", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.sinks.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/{v2Id}/{v2Id1}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.sinks.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/billingAccounts/{billingAccountsId}/logs", PathMatcher: regexp.MustCompile(`^(/v2beta1/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs)$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.logs.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/monitoredResourceDescriptors", PathMatcher: regexp.MustCompile(`^(/v2beta1/monitoredResourceDescriptors)$`), ServiceName: "google.logging", ResourceName: "logging.monitoredResourceDescriptors.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/organizations/{organizationsId}/logs", PathMatcher: regexp.MustCompile(`^(/v2beta1/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs)$`), ServiceName: "google.logging", ResourceName: "logging.organizations.logs.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/logs", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs)$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/metrics", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics)$`), ServiceName: "google.logging", ResourceName: "logging.projects.metrics.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/metrics/{metricsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.metrics.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/sinks", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2beta1/projects/{projectsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.get"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.exclusions.patch"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.sinks.patch"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/folders/{foldersId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.folders.exclusions.patch"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/folders/{foldersId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.folders.sinks.patch"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/organizations/{organizationsId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.organizations.exclusions.patch"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/organizations/{organizationsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.organizations.sinks.patch"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/projects/{projectsId}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.exclusions.patch"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/projects/{projectsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.patch"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/{v2Id}/{v2Id1}/exclusions/{exclusionsId}", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.exclusions.patch"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta3/projects/{projectsId}/logServices/{logServicesId}/sinks", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.projects.logServices.sinks.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta3/projects/{projectsId}/logs/{logsId}/entries:write", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entries:write)$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.entries.write"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta3/projects/{projectsId}/logs/{logsId}/sinks", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.sinks.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/exclusions", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions)$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.exclusions.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/sinks", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.sinks.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/entries:list", PathMatcher: regexp.MustCompile(`^(/v2/entries:list)$`), ServiceName: "google.logging", ResourceName: "logging.entries.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/entries:write", PathMatcher: regexp.MustCompile(`^(/v2/entries:write)$`), ServiceName: "google.logging", ResourceName: "logging.entries.write"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/folders/{foldersId}/exclusions", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions)$`), ServiceName: "google.logging", ResourceName: "logging.folders.exclusions.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/folders/{foldersId}/sinks", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.folders.sinks.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/organizations/{organizationsId}/exclusions", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions)$`), ServiceName: "google.logging", ResourceName: "logging.organizations.exclusions.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/organizations/{organizationsId}/sinks", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.organizations.sinks.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/exclusions", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions)$`), ServiceName: "google.logging", ResourceName: "logging.projects.exclusions.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/metrics", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics)$`), ServiceName: "google.logging", ResourceName: "logging.projects.metrics.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/sinks", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/{v2Id}/{v2Id1}/exclusions", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/exclusions)$`), ServiceName: "google.logging", ResourceName: "logging.exclusions.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/{v2Id}/{v2Id1}/sinks", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.sinks.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/entries:list", PathMatcher: regexp.MustCompile(`^(/v2beta1/entries:list)$`), ServiceName: "google.logging", ResourceName: "logging.entries.list"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/entries:write", PathMatcher: regexp.MustCompile(`^(/v2beta1/entries:write)$`), ServiceName: "google.logging", ResourceName: "logging.entries.write"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/metrics", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics)$`), ServiceName: "google.logging", ResourceName: "logging.projects.metrics.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2beta1/projects/{projectsId}/sinks", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks)$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.create"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta3/projects/{projectsId}/logServices/{logServicesId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.logServices.sinks.update"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta3/projects/{projectsId}/logs/{logsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v1beta3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/logs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.logs.sinks.update"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2/billingAccounts/{billingAccountsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/billingAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.billingAccounts.sinks.update"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2/folders/{foldersId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/folders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.folders.sinks.update"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2/organizations/{organizationsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/organizations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.organizations.sinks.update"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2/projects/{projectsId}/metrics/{metricsId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.metrics.update"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2/projects/{projectsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.update"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2/{v2Id}/{v2Id1}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.sinks.update"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2beta1/projects/{projectsId}/metrics/{metricsId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.metrics.update"},
		{Hostname: "logging.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2beta1/projects/{projectsId}/sinks/{sinksId}", PathMatcher: regexp.MustCompile(`^(/v2beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.logging", ResourceName: "logging.projects.sinks.update"},
		{Hostname: "manufacturers.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/accounts/{accountsId}/products/{productsId}", PathMatcher: regexp.MustCompile(`^(/v1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/products/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.manufacturers", ResourceName: "manufacturers.accounts.products.delete"},
		{Hostname: "manufacturers.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/accounts/{accountsId}/products", PathMatcher: regexp.MustCompile(`^(/v1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/products)$`), ServiceName: "google.manufacturers", ResourceName: "manufacturers.accounts.products.list"},
		{Hostname: "manufacturers.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/accounts/{accountsId}/products/{productsId}", PathMatcher: regexp.MustCompile(`^(/v1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/products/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.manufacturers", ResourceName: "manufacturers.accounts.products.get"},
		{Hostname: "manufacturers.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/accounts/{accountsId}/products/{productsId}", PathMatcher: regexp.MustCompile(`^(/v1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/products/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.manufacturers", ResourceName: "manufacturers.accounts.products.update"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.delete"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.versions.delete"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.ml", ResourceName: "ml.projects.operations.delete"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/jobs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs)$`), ServiceName: "google.ml", ResourceName: "ml.projects.jobs.list"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/jobs/{jobsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.ml", ResourceName: "ml.projects.jobs.get"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/jobs/{jobsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.ml", ResourceName: "ml.projects.jobs.getIamPolicy"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.ml", ResourceName: "ml.projects.locations.list"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.ml", ResourceName: "ml.projects.locations.get"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/models", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models)$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.list"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.get"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}/versions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.versions.list"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.versions.get"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.getIamPolicy"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.ml", ResourceName: "ml.projects.operations.list"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.ml", ResourceName: "ml.projects.operations.get"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}:getConfig", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getConfig)$`), ServiceName: "google.ml", ResourceName: "ml.projects.getConfig"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.patch"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}/versions/{versionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.versions.patch"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/jobs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs)$`), ServiceName: "google.ml", ResourceName: "ml.projects.jobs.create"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/jobs/{jobsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.ml", ResourceName: "ml.projects.jobs.cancel"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/jobs/{jobsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.ml", ResourceName: "ml.projects.jobs.setIamPolicy"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/jobs/{jobsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/jobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.ml", ResourceName: "ml.projects.jobs.testIamPermissions"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/models", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models)$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.create"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}/versions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.versions.create"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}/versions/{versionsId}:setDefault", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setDefault)$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.versions.setDefault"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.setIamPolicy"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/models/{modelsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/models/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.ml", ResourceName: "ml.projects.models.testIamPermissions"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.ml", ResourceName: "ml.projects.operations.cancel"},
		{Hostname: "ml.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}:predict", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:predict)$`), ServiceName: "google.ml", ResourceName: "ml.projects.predict"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v3/projects/{projectsId}/alertPolicies/{alertPoliciesId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/alertPolicies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.alertPolicies.delete"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v3/projects/{projectsId}/groups/{groupsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.groups.delete"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v3/projects/{projectsId}/metricDescriptors/{metricDescriptorsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metricDescriptors/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.metricDescriptors.delete"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notificationChannels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.notificationChannels.delete"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v3/projects/{projectsId}/uptimeCheckConfigs/{uptimeCheckConfigsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/uptimeCheckConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.uptimeCheckConfigs.delete"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/alertPolicies", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/alertPolicies)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.alertPolicies.list"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/alertPolicies/{alertPoliciesId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/alertPolicies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.alertPolicies.get"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/groups", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.groups.list"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/groups/{groupsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.groups.get"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/groups/{groupsId}/members", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/members)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.groups.members.list"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/metricDescriptors", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metricDescriptors)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.metricDescriptors.list"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/metricDescriptors/{metricDescriptorsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metricDescriptors/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.metricDescriptors.get"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/monitoredResourceDescriptors", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/monitoredResourceDescriptors)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.monitoredResourceDescriptors.list"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/monitoredResourceDescriptors/{monitoredResourceDescriptorsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/monitoredResourceDescriptors/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.monitoredResourceDescriptors.get"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/notificationChannelDescriptors", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notificationChannelDescriptors)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.notificationChannelDescriptors.list"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/notificationChannelDescriptors/{notificationChannelDescriptorsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notificationChannelDescriptors/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.notificationChannelDescriptors.get"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/notificationChannels", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notificationChannels)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.notificationChannels.list"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notificationChannels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.notificationChannels.get"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/timeSeries", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/timeSeries)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.timeSeries.list"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/uptimeCheckConfigs", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/uptimeCheckConfigs)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.uptimeCheckConfigs.list"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/projects/{projectsId}/uptimeCheckConfigs/{uptimeCheckConfigsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/uptimeCheckConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.uptimeCheckConfigs.get"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v3/uptimeCheckIps", PathMatcher: regexp.MustCompile(`^(/v3/uptimeCheckIps)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.uptimeCheckIps.list"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v3/projects/{projectsId}/alertPolicies/{alertPoliciesId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/alertPolicies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.alertPolicies.patch"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notificationChannels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.notificationChannels.patch"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v3/projects/{projectsId}/uptimeCheckConfigs/{uptimeCheckConfigsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/uptimeCheckConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.uptimeCheckConfigs.patch"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v3/projects/{projectsId}/alertPolicies", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/alertPolicies)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.alertPolicies.create"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v3/projects/{projectsId}/collectdTimeSeries", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/collectdTimeSeries)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.collectdTimeSeries.create"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v3/projects/{projectsId}/groups", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.groups.create"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v3/projects/{projectsId}/metricDescriptors", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metricDescriptors)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.metricDescriptors.create"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v3/projects/{projectsId}/notificationChannels", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notificationChannels)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.notificationChannels.create"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}:getVerificationCode", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notificationChannels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getVerificationCode)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.notificationChannels.getVerificationCode"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}:sendVerificationCode", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notificationChannels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:sendVerificationCode)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.notificationChannels.sendVerificationCode"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v3/projects/{projectsId}/notificationChannels/{notificationChannelsId}:verify", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notificationChannels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:verify)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.notificationChannels.verify"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v3/projects/{projectsId}/timeSeries", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/timeSeries)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.timeSeries.create"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v3/projects/{projectsId}/uptimeCheckConfigs", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/uptimeCheckConfigs)$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.uptimeCheckConfigs.create"},
		{Hostname: "monitoring.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v3/projects/{projectsId}/groups/{groupsId}", PathMatcher: regexp.MustCompile(`^(/v3/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.monitoring", ResourceName: "monitoring.projects.groups.update"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/users/{usersId}/projects/{projectsId}", PathMatcher: regexp.MustCompile(`^(/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.projects.delete"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/users/{usersId}/sshPublicKeys/{sshPublicKeysId}", PathMatcher: regexp.MustCompile(`^(/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sshPublicKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.sshPublicKeys.delete"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha/users/{usersId}/projects/{projectsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.projects.delete"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha/users/{usersId}/sshPublicKeys/{sshPublicKeysId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sshPublicKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.sshPublicKeys.delete"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta/users/{usersId}/projects/{projectsId}", PathMatcher: regexp.MustCompile(`^(/v1beta/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.projects.delete"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta/users/{usersId}/sshPublicKeys/{sshPublicKeysId}", PathMatcher: regexp.MustCompile(`^(/v1beta/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sshPublicKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.sshPublicKeys.delete"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/users/{usersId}/loginProfile", PathMatcher: regexp.MustCompile(`^(/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/loginProfile)$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.getLoginProfile"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/users/{usersId}/sshPublicKeys/{sshPublicKeysId}", PathMatcher: regexp.MustCompile(`^(/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sshPublicKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.sshPublicKeys.get"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/users/{usersId}/loginProfile", PathMatcher: regexp.MustCompile(`^(/v1alpha/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/loginProfile)$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.getLoginProfile"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/users/{usersId}/sshPublicKeys/{sshPublicKeysId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sshPublicKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.sshPublicKeys.get"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/users/{usersId}/loginProfile", PathMatcher: regexp.MustCompile(`^(/v1beta/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/loginProfile)$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.getLoginProfile"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta/users/{usersId}/sshPublicKeys/{sshPublicKeysId}", PathMatcher: regexp.MustCompile(`^(/v1beta/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sshPublicKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.sshPublicKeys.get"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/users/{usersId}/sshPublicKeys/{sshPublicKeysId}", PathMatcher: regexp.MustCompile(`^(/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sshPublicKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.sshPublicKeys.patch"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1alpha/users/{usersId}/sshPublicKeys/{sshPublicKeysId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sshPublicKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.sshPublicKeys.patch"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta/users/{usersId}/sshPublicKeys/{sshPublicKeysId}", PathMatcher: regexp.MustCompile(`^(/v1beta/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sshPublicKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.sshPublicKeys.patch"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/users/{usersId}:importSshPublicKey", PathMatcher: regexp.MustCompile(`^(/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:importSshPublicKey)$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.importSshPublicKey"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha/users/{usersId}:importSshPublicKey", PathMatcher: regexp.MustCompile(`^(/v1alpha/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:importSshPublicKey)$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.importSshPublicKey"},
		{Hostname: "oslogin.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta/users/{usersId}:importSshPublicKey", PathMatcher: regexp.MustCompile(`^(/v1beta/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:importSshPublicKey)$`), ServiceName: "google.oslogin", ResourceName: "oslogin.users.importSshPublicKey"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v2/users/{userId}/companyRelation", PathMatcher: regexp.MustCompile(`^(/v2/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/companyRelation)$`), ServiceName: "google.partners", ResourceName: "partners.users.deleteCompanyRelation"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/analytics", PathMatcher: regexp.MustCompile(`^(/v2/analytics)$`), ServiceName: "google.partners", ResourceName: "partners.analytics.list"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/companies", PathMatcher: regexp.MustCompile(`^(/v2/companies)$`), ServiceName: "google.partners", ResourceName: "partners.companies.list"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/companies/{companyId}", PathMatcher: regexp.MustCompile(`^(/v2/companies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.partners", ResourceName: "partners.companies.get"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/leads", PathMatcher: regexp.MustCompile(`^(/v2/leads)$`), ServiceName: "google.partners", ResourceName: "partners.leads.list"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/offers", PathMatcher: regexp.MustCompile(`^(/v2/offers)$`), ServiceName: "google.partners", ResourceName: "partners.offers.list"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/offers/history", PathMatcher: regexp.MustCompile(`^(/v2/offers/history)$`), ServiceName: "google.partners", ResourceName: "partners.offers.history.list"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/partnersstatus", PathMatcher: regexp.MustCompile(`^(/v2/partnersstatus)$`), ServiceName: "google.partners", ResourceName: "partners.getPartnersstatus"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/userStates", PathMatcher: regexp.MustCompile(`^(/v2/userStates)$`), ServiceName: "google.partners", ResourceName: "partners.userStates.list"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/users/{userId}", PathMatcher: regexp.MustCompile(`^(/v2/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.partners", ResourceName: "partners.users.get"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/companies", PathMatcher: regexp.MustCompile(`^(/v2/companies)$`), ServiceName: "google.partners", ResourceName: "partners.updateCompanies"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/leads", PathMatcher: regexp.MustCompile(`^(/v2/leads)$`), ServiceName: "google.partners", ResourceName: "partners.updateLeads"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v2/users/profile", PathMatcher: regexp.MustCompile(`^(/v2/users/profile)$`), ServiceName: "google.partners", ResourceName: "partners.users.updateProfile"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/clientMessages:log", PathMatcher: regexp.MustCompile(`^(/v2/clientMessages:log)$`), ServiceName: "google.partners", ResourceName: "partners.clientMessages.log"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/companies/{companyId}/leads", PathMatcher: regexp.MustCompile(`^(/v2/companies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/leads)$`), ServiceName: "google.partners", ResourceName: "partners.companies.leads.create"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/userEvents:log", PathMatcher: regexp.MustCompile(`^(/v2/userEvents:log)$`), ServiceName: "google.partners", ResourceName: "partners.userEvents.log"},
		{Hostname: "partners.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2/users/{userId}/companyRelation", PathMatcher: regexp.MustCompile(`^(/v2/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/companyRelation)$`), ServiceName: "google.partners", ResourceName: "partners.users.createCompanyRelation"},
		{Hostname: "people.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/contactGroups/{contactGroupsId}", PathMatcher: regexp.MustCompile(`^(/v1/contactGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.people", ResourceName: "people.contactGroups.delete"},
		{Hostname: "people.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/people/{peopleId}:deleteContact", PathMatcher: regexp.MustCompile(`^(/v1/people/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:deleteContact)$`), ServiceName: "google.people", ResourceName: "people.people.deleteContact"},
		{Hostname: "people.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/contactGroups", PathMatcher: regexp.MustCompile(`^(/v1/contactGroups)$`), ServiceName: "google.people", ResourceName: "people.contactGroups.list"},
		{Hostname: "people.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/contactGroups/{contactGroupsId}", PathMatcher: regexp.MustCompile(`^(/v1/contactGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.people", ResourceName: "people.contactGroups.get"},
		{Hostname: "people.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/contactGroups:batchGet", PathMatcher: regexp.MustCompile(`^(/v1/contactGroups:batchGet)$`), ServiceName: "google.people", ResourceName: "people.contactGroups.batchGet"},
		{Hostname: "people.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/people/{peopleId}", PathMatcher: regexp.MustCompile(`^(/v1/people/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.people", ResourceName: "people.people.get"},
		{Hostname: "people.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/people/{peopleId}/connections", PathMatcher: regexp.MustCompile(`^(/v1/people/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/connections)$`), ServiceName: "google.people", ResourceName: "people.people.connections.list"},
		{Hostname: "people.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/people:batchGet", PathMatcher: regexp.MustCompile(`^(/v1/people:batchGet)$`), ServiceName: "google.people", ResourceName: "people.people.getBatchGet"},
		{Hostname: "people.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/people/{peopleId}:updateContact", PathMatcher: regexp.MustCompile(`^(/v1/people/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:updateContact)$`), ServiceName: "google.people", ResourceName: "people.people.updateContact"},
		{Hostname: "people.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/contactGroups", PathMatcher: regexp.MustCompile(`^(/v1/contactGroups)$`), ServiceName: "google.people", ResourceName: "people.contactGroups.create"},
		{Hostname: "people.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/contactGroups/{contactGroupsId}/members:modify", PathMatcher: regexp.MustCompile(`^(/v1/contactGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/members:modify)$`), ServiceName: "google.people", ResourceName: "people.contactGroups.members.modify"},
		{Hostname: "people.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/people:createContact", PathMatcher: regexp.MustCompile(`^(/v1/people:createContact)$`), ServiceName: "google.people", ResourceName: "people.people.createContact"},
		{Hostname: "people.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/contactGroups/{contactGroupsId}", PathMatcher: regexp.MustCompile(`^(/v1/contactGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.people", ResourceName: "people.contactGroups.update"},
		{Hostname: "photoslibrary.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/albums", PathMatcher: regexp.MustCompile(`^(/v1/albums)$`), ServiceName: "google.photoslibrary", ResourceName: "photoslibrary.albums.list"},
		{Hostname: "photoslibrary.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/albums/{albumsId}", PathMatcher: regexp.MustCompile(`^(/v1/albums/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.photoslibrary", ResourceName: "photoslibrary.albums.get"},
		{Hostname: "photoslibrary.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/mediaItems/{mediaItemsId}", PathMatcher: regexp.MustCompile(`^(/v1/mediaItems/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.photoslibrary", ResourceName: "photoslibrary.mediaItems.get"},
		{Hostname: "photoslibrary.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/sharedAlbums", PathMatcher: regexp.MustCompile(`^(/v1/sharedAlbums)$`), ServiceName: "google.photoslibrary", ResourceName: "photoslibrary.sharedAlbums.list"},
		{Hostname: "photoslibrary.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/albums", PathMatcher: regexp.MustCompile(`^(/v1/albums)$`), ServiceName: "google.photoslibrary", ResourceName: "photoslibrary.albums.create"},
		{Hostname: "photoslibrary.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/albums/{albumsId}:addEnrichment", PathMatcher: regexp.MustCompile(`^(/v1/albums/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:addEnrichment)$`), ServiceName: "google.photoslibrary", ResourceName: "photoslibrary.albums.addEnrichment"},
		{Hostname: "photoslibrary.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/albums/{albumsId}:share", PathMatcher: regexp.MustCompile(`^(/v1/albums/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:share)$`), ServiceName: "google.photoslibrary", ResourceName: "photoslibrary.albums.share"},
		{Hostname: "photoslibrary.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/mediaItems:batchCreate", PathMatcher: regexp.MustCompile(`^(/v1/mediaItems:batchCreate)$`), ServiceName: "google.photoslibrary", ResourceName: "photoslibrary.mediaItems.batchCreate"},
		{Hostname: "photoslibrary.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/mediaItems:search", PathMatcher: regexp.MustCompile(`^(/v1/mediaItems:search)$`), ServiceName: "google.photoslibrary", ResourceName: "photoslibrary.mediaItems.search"},
		{Hostname: "photoslibrary.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/sharedAlbums:join", PathMatcher: regexp.MustCompile(`^(/v1/sharedAlbums:join)$`), ServiceName: "google.photoslibrary", ResourceName: "photoslibrary.sharedAlbums.join"},
		{Hostname: "playmoviespartner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/accounts/{accountId}/avails", PathMatcher: regexp.MustCompile(`^(/v1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/avails)$`), ServiceName: "google.playmoviespartner", ResourceName: "playmoviespartner.accounts.avails.list"},
		{Hostname: "playmoviespartner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/accounts/{accountId}/avails/{availId}", PathMatcher: regexp.MustCompile(`^(/v1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/avails/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.playmoviespartner", ResourceName: "playmoviespartner.accounts.avails.get"},
		{Hostname: "playmoviespartner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/accounts/{accountId}/orders", PathMatcher: regexp.MustCompile(`^(/v1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/orders)$`), ServiceName: "google.playmoviespartner", ResourceName: "playmoviespartner.accounts.orders.list"},
		{Hostname: "playmoviespartner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/accounts/{accountId}/orders/{orderId}", PathMatcher: regexp.MustCompile(`^(/v1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/orders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.playmoviespartner", ResourceName: "playmoviespartner.accounts.orders.get"},
		{Hostname: "playmoviespartner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/accounts/{accountId}/storeInfos", PathMatcher: regexp.MustCompile(`^(/v1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/storeInfos)$`), ServiceName: "google.playmoviespartner", ResourceName: "playmoviespartner.accounts.storeInfos.list"},
		{Hostname: "playmoviespartner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/accounts/{accountId}/storeInfos/{videoId}/country/{country}", PathMatcher: regexp.MustCompile(`^(/v1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/storeInfos/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/country/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.playmoviespartner", ResourceName: "playmoviespartner.accounts.storeInfos.country.get"},
		{Hostname: "poly.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/assets", PathMatcher: regexp.MustCompile(`^(/v1/assets)$`), ServiceName: "google.poly", ResourceName: "poly.assets.list"},
		{Hostname: "poly.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/assets/{assetsId}", PathMatcher: regexp.MustCompile(`^(/v1/assets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.poly", ResourceName: "poly.assets.get"},
		{Hostname: "poly.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/users/{usersId}/assets", PathMatcher: regexp.MustCompile(`^(/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/assets)$`), ServiceName: "google.poly", ResourceName: "poly.users.assets.list"},
		{Hostname: "poly.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/users/{usersId}/likedassets", PathMatcher: regexp.MustCompile(`^(/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/likedassets)$`), ServiceName: "google.poly", ResourceName: "poly.users.likedassets.list"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/beacons/{beaconsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.delete"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/beacons/{beaconsId}/attachments/{attachmentsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/attachments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.attachments.delete"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/beacons", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.list"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/beacons/{beaconsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.get"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/beacons/{beaconsId}/attachments", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/attachments)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.attachments.list"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/beacons/{beaconsId}/diagnostics", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/diagnostics)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.diagnostics.list"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/eidparams", PathMatcher: regexp.MustCompile(`^(/v1beta1/eidparams)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.getEidparams"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/namespaces", PathMatcher: regexp.MustCompile(`^(/v1beta1/namespaces)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.namespaces.list"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/beaconinfo:getforobserved", PathMatcher: regexp.MustCompile(`^(/v1beta1/beaconinfo:getforobserved)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beaconinfo.getforobserved"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/beacons/{beaconsId}/attachments", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/attachments)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.attachments.create"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/beacons/{beaconsId}/attachments:batchDelete", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/attachments:batchDelete)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.attachments.batchDelete"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/beacons/{beaconsId}:activate", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:activate)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.activate"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/beacons/{beaconsId}:deactivate", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:deactivate)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.deactivate"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/beacons/{beaconsId}:decommission", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:decommission)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.decommission"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/beacons:register", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons:register)$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.register"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/beacons/{beaconsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/beacons/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.beacons.update"},
		{Hostname: "proximitybeacon.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/namespaces/{namespacesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/namespaces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.proximitybeacon", ResourceName: "proximitybeacon.namespaces.update"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/snapshots/{snapshotsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/snapshots/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.snapshots.delete"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.delete"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/topics/{topicsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.delete"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1a/subscriptions/{subscriptionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1a/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.subscriptions.delete"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1a/topics/{topicsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1a/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.topics.delete"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions/{subscriptionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.delete"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta2/projects/{projectsId}/topics/{topicsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.delete"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/snapshots", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/snapshots)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.snapshots.list"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/snapshots/{snapshotsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/snapshots/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.snapshots.get"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/snapshots/{snapshotsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/snapshots/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.snapshots.getIamPolicy"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/subscriptions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.list"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.get"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.getIamPolicy"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/topics", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.list"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/topics/{topicsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.get"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/topics/{topicsId}/snapshots", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/snapshots)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.snapshots.list"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/topics/{topicsId}/subscriptions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.subscriptions.list"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/topics/{topicsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.getIamPolicy"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1a/subscriptions", PathMatcher: regexp.MustCompile(`^(/v1beta1a/subscriptions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.subscriptions.list"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1a/subscriptions/{subscriptionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1a/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.subscriptions.get"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1a/topics", PathMatcher: regexp.MustCompile(`^(/v1beta1a/topics)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.topics.list"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1a/topics/{topicsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1a/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.topics.get"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.list"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions/{subscriptionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.get"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions/{subscriptionsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.getIamPolicy"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/topics", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.list"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/topics/{topicsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.get"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/topics/{topicsId}/subscriptions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.subscriptions.list"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta2/projects/{projectsId}/topics/{topicsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.getIamPolicy"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/snapshots/{snapshotsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/snapshots/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.snapshots.patch"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.patch"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/snapshots/{snapshotsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/snapshots/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.snapshots.setIamPolicy"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/snapshots/{snapshotsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/snapshots/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.snapshots.testIamPermissions"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}:acknowledge", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:acknowledge)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.acknowledge"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}:modifyAckDeadline", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:modifyAckDeadline)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.modifyAckDeadline"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}:modifyPushConfig", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:modifyPushConfig)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.modifyPushConfig"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}:pull", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:pull)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.pull"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}:seek", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:seek)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.seek"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.setIamPolicy"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.testIamPermissions"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/topics/{topicsId}:publish", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:publish)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.publish"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/topics/{topicsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.setIamPolicy"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/topics/{topicsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.testIamPermissions"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1a/subscriptions", PathMatcher: regexp.MustCompile(`^(/v1beta1a/subscriptions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.subscriptions.create"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1a/subscriptions/acknowledge", PathMatcher: regexp.MustCompile(`^(/v1beta1a/subscriptions/acknowledge)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.subscriptions.acknowledge"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1a/subscriptions/modifyAckDeadline", PathMatcher: regexp.MustCompile(`^(/v1beta1a/subscriptions/modifyAckDeadline)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.subscriptions.modifyAckDeadline"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1a/subscriptions/modifyPushConfig", PathMatcher: regexp.MustCompile(`^(/v1beta1a/subscriptions/modifyPushConfig)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.subscriptions.modifyPushConfig"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1a/subscriptions/pull", PathMatcher: regexp.MustCompile(`^(/v1beta1a/subscriptions/pull)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.subscriptions.pull"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1a/subscriptions/pullBatch", PathMatcher: regexp.MustCompile(`^(/v1beta1a/subscriptions/pullBatch)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.subscriptions.pullBatch"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1a/topics", PathMatcher: regexp.MustCompile(`^(/v1beta1a/topics)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.topics.create"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1a/topics/publish", PathMatcher: regexp.MustCompile(`^(/v1beta1a/topics/publish)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.topics.publish"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1a/topics/publishBatch", PathMatcher: regexp.MustCompile(`^(/v1beta1a/topics/publishBatch)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.topics.publishBatch"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions/{subscriptionsId}:acknowledge", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:acknowledge)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.acknowledge"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions/{subscriptionsId}:modifyAckDeadline", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:modifyAckDeadline)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.modifyAckDeadline"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions/{subscriptionsId}:modifyPushConfig", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:modifyPushConfig)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.modifyPushConfig"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions/{subscriptionsId}:pull", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:pull)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.pull"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions/{subscriptionsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.setIamPolicy"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions/{subscriptionsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.testIamPermissions"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/topics/{topicsId}:publish", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:publish)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.publish"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/topics/{topicsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.setIamPolicy"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/projects/{projectsId}/topics/{topicsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.testIamPermissions"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{projectsId}/snapshots/{snapshotsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/snapshots/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.snapshots.create"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{projectsId}/subscriptions/{subscriptionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.create"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{projectsId}/topics/{topicsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.create"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta2/projects/{projectsId}/subscriptions/{subscriptionsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.subscriptions.create"},
		{Hostname: "pubsub.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta2/projects/{projectsId}/topics/{topicsId}", PathMatcher: regexp.MustCompile(`^(/v1beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/topics/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.pubsub", ResourceName: "pubsub.projects.topics.create"},
		{Hostname: "redis.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.redis", ResourceName: "redis.projects.locations.instances.delete"},
		{Hostname: "redis.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.redis", ResourceName: "redis.projects.locations.list"},
		{Hostname: "redis.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.redis", ResourceName: "redis.projects.locations.get"},
		{Hostname: "redis.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/instances", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances)$`), ServiceName: "google.redis", ResourceName: "redis.projects.locations.instances.list"},
		{Hostname: "redis.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.redis", ResourceName: "redis.projects.locations.instances.get"},
		{Hostname: "redis.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.redis", ResourceName: "redis.projects.locations.operations.list"},
		{Hostname: "redis.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.redis", ResourceName: "redis.projects.locations.operations.get"},
		{Hostname: "redis.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.redis", ResourceName: "redis.projects.locations.instances.patch"},
		{Hostname: "redis.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/locations/{locationsId}/instances", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances)$`), ServiceName: "google.redis", ResourceName: "redis.projects.locations.instances.create"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.operations.delete"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.delete"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/variables/{variablesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/variables/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.variables.delete"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/waiters/{waitersId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/waiters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.waiters.delete"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations", PathMatcher: regexp.MustCompile(`^(/v1/operations)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.operations.list"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/configs", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.list"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.get"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.operations.get"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/variables", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/variables)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.variables.list"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/variables/{variablesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/variables/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.variables.get"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/waiters", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/waiters)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.waiters.list"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/waiters/{waitersId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/waiters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.waiters.get"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.getIamPolicy"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.operations.cancel"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/configs", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.create"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/operations/{operationsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.operations.testIamPermissions"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/variables", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/variables)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.variables.create"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/variables/{variablesId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/variables/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.variables.testIamPermissions"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/variables/{variablesId}:watch", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/variables/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:watch)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.variables.watch"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/waiters", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/waiters)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.waiters.create"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/waiters/{waitersId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/waiters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.waiters.testIamPermissions"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.setIamPolicy"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.testIamPermissions"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.update"},
		{Hostname: "runtimeconfig.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/projects/{projectsId}/configs/{configsId}/variables/{variablesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/variables/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.runtimeconfig", ResourceName: "runtimeconfig.projects.configs.variables.update"},
		{Hostname: "safebrowsing.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v4/encodedFullHashes/{encodedRequest}", PathMatcher: regexp.MustCompile(`^(/v4/encodedFullHashes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.safebrowsing", ResourceName: "safebrowsing.encodedFullHashes.get"},
		{Hostname: "safebrowsing.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v4/encodedUpdates/{encodedRequest}", PathMatcher: regexp.MustCompile(`^(/v4/encodedUpdates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.safebrowsing", ResourceName: "safebrowsing.encodedUpdates.get"},
		{Hostname: "safebrowsing.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v4/threatLists", PathMatcher: regexp.MustCompile(`^(/v4/threatLists)$`), ServiceName: "google.safebrowsing", ResourceName: "safebrowsing.threatLists.list"},
		{Hostname: "safebrowsing.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/fullHashes:find", PathMatcher: regexp.MustCompile(`^(/v4/fullHashes:find)$`), ServiceName: "google.safebrowsing", ResourceName: "safebrowsing.fullHashes.find"},
		{Hostname: "safebrowsing.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/threatHits", PathMatcher: regexp.MustCompile(`^(/v4/threatHits)$`), ServiceName: "google.safebrowsing", ResourceName: "safebrowsing.threatHits.create"},
		{Hostname: "safebrowsing.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/threatListUpdates:fetch", PathMatcher: regexp.MustCompile(`^(/v4/threatListUpdates:fetch)$`), ServiceName: "google.safebrowsing", ResourceName: "safebrowsing.threatListUpdates.fetch"},
		{Hostname: "safebrowsing.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/threatMatches:find", PathMatcher: regexp.MustCompile(`^(/v4/threatMatches:find)$`), ServiceName: "google.safebrowsing", ResourceName: "safebrowsing.threatMatches.find"},
		{Hostname: "script.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{scriptId}/deployments/{deploymentId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deployments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.script", ResourceName: "script.projects.deployments.delete"},
		{Hostname: "script.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/processes", PathMatcher: regexp.MustCompile(`^(/v1/processes)$`), ServiceName: "google.script", ResourceName: "script.processes.list"},
		{Hostname: "script.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/processes:listScriptProcesses", PathMatcher: regexp.MustCompile(`^(/v1/processes:listScriptProcesses)$`), ServiceName: "google.script", ResourceName: "script.processes.listScriptProcesses"},
		{Hostname: "script.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{scriptId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.script", ResourceName: "script.projects.get"},
		{Hostname: "script.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{scriptId}/content", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/content)$`), ServiceName: "google.script", ResourceName: "script.projects.getContent"},
		{Hostname: "script.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{scriptId}/deployments", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deployments)$`), ServiceName: "google.script", ResourceName: "script.projects.deployments.list"},
		{Hostname: "script.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{scriptId}/deployments/{deploymentId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deployments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.script", ResourceName: "script.projects.deployments.get"},
		{Hostname: "script.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{scriptId}/metrics", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metrics)$`), ServiceName: "google.script", ResourceName: "script.projects.getMetrics"},
		{Hostname: "script.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{scriptId}/versions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.script", ResourceName: "script.projects.versions.list"},
		{Hostname: "script.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{scriptId}/versions/{versionNumber}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.script", ResourceName: "script.projects.versions.get"},
		{Hostname: "script.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects", PathMatcher: regexp.MustCompile(`^(/v1/projects)$`), ServiceName: "google.script", ResourceName: "script.projects.create"},
		{Hostname: "script.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{scriptId}/deployments", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deployments)$`), ServiceName: "google.script", ResourceName: "script.projects.deployments.create"},
		{Hostname: "script.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{scriptId}/versions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/versions)$`), ServiceName: "google.script", ResourceName: "script.projects.versions.create"},
		{Hostname: "script.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/scripts/{scriptId}:run", PathMatcher: regexp.MustCompile(`^(/v1/scripts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:run)$`), ServiceName: "google.script", ResourceName: "script.scripts.run"},
		{Hostname: "script.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{scriptId}/content", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/content)$`), ServiceName: "google.script", ResourceName: "script.projects.updateContent"},
		{Hostname: "script.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/projects/{scriptId}/deployments/{deploymentId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deployments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.script", ResourceName: "script.projects.deployments.update"},
		{Hostname: "searchconsole.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/urlTestingTools/mobileFriendlyTest:run", PathMatcher: regexp.MustCompile(`^(/v1/urlTestingTools/mobileFriendlyTest:run)$`), ServiceName: "google.searchconsole", ResourceName: "searchconsole.urlTestingTools.mobileFriendlyTest.run"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{instanceId}/service_bindings/{bindingId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/service_bindings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.service_bindings.delete"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.delete"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.delete"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.delete"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}/service_bindings/{service_bindingsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/service_bindings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.service_bindings.delete"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/{v1Id}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.getIamPolicy"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.instances.get"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/instances/{instancesId}/service_bindings", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/service_bindings)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.instances.service_bindings.list"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/service_instances", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/service_instances)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.service_instances.list"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/v2/catalog", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/catalog)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.catalog.list"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.get"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}/last_operation", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/last_operation)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.getLast_operation"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}/service_bindings/{service_bindingsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/service_bindings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.service_bindings.get"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}/service_bindings/{service_bindingsId}/last_operation", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/service_bindings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/last_operation)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.service_bindings.getLast_operation"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/{v1alpha1Id}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1alpha1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.getIamPolicy"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.list"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/instances", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.instances.list"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.instances.get"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/instances/{instancesId}/bindings", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/bindings)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.instances.bindings.list"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/instances/{instancesId}/bindings/{bindingsId}/last_operation", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/bindings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/last_operation)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.instances.bindings.getLast_operation"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/instances/{instancesId}/last_operation", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/last_operation)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.instances.getLast_operation"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/v2/catalog", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/catalog)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.catalog.list"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.get"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}/last_operation", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/last_operation)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.getLast_operation"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}/service_bindings/{service_bindingsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/service_bindings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.service_bindings.get"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}/service_bindings/{service_bindingsId}/last_operation", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/service_bindings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/last_operation)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.service_bindings.getLast_operation"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/{v1beta1Id}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.getIamPolicy"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.patch"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.patch"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/{v1Id}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.setIamPolicy"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/{v1Id}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.testIamPermissions"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/{v1alpha1Id}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1alpha1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.setIamPolicy"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/{v1alpha1Id}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1alpha1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.testIamPermissions"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/projects/{projectsId}/brokers", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.create"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/{v1beta1Id}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1beta1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.setIamPolicy"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/{v1beta1Id}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1beta1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.testIamPermissions"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.create"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1alpha1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}/service_bindings/{service_bindingsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/service_bindings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.service_bindings.create"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.create"},
		{Hostname: "servicebroker.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1beta1/projects/{projectsId}/brokers/{brokersId}/v2/service_instances/{service_instancesId}/service_bindings/{service_bindingsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/brokers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/v2/service_instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/service_bindings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicebroker", ResourceName: "servicebroker.projects.brokers.v2.service_instances.service_bindings.create"},
		{Hostname: "serviceconsumermanagement.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.serviceconsumermanagement", ResourceName: "serviceconsumermanagement.operations.delete"},
		{Hostname: "serviceconsumermanagement.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/services/{servicesId}/{servicesId1}/{servicesId2}/tenancyUnits/{tenancyUnitsId}", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tenancyUnits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.serviceconsumermanagement", ResourceName: "serviceconsumermanagement.services.tenancyUnits.delete"},
		{Hostname: "serviceconsumermanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations", PathMatcher: regexp.MustCompile(`^(/v1/operations)$`), ServiceName: "google.serviceconsumermanagement", ResourceName: "serviceconsumermanagement.operations.list"},
		{Hostname: "serviceconsumermanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.serviceconsumermanagement", ResourceName: "serviceconsumermanagement.operations.get"},
		{Hostname: "serviceconsumermanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services/{servicesId}/{servicesId1}/{servicesId2}/tenancyUnits", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tenancyUnits)$`), ServiceName: "google.serviceconsumermanagement", ResourceName: "serviceconsumermanagement.services.tenancyUnits.list"},
		{Hostname: "serviceconsumermanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services/{servicesId}:search", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:search)$`), ServiceName: "google.serviceconsumermanagement", ResourceName: "serviceconsumermanagement.services.search"},
		{Hostname: "serviceconsumermanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.serviceconsumermanagement", ResourceName: "serviceconsumermanagement.operations.cancel"},
		{Hostname: "serviceconsumermanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{servicesId}/{servicesId1}/{servicesId2}/tenancyUnits", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tenancyUnits)$`), ServiceName: "google.serviceconsumermanagement", ResourceName: "serviceconsumermanagement.services.tenancyUnits.create"},
		{Hostname: "serviceconsumermanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{servicesId}/{servicesId1}/{servicesId2}/tenancyUnits/{tenancyUnitsId}:addProject", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tenancyUnits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:addProject)$`), ServiceName: "google.serviceconsumermanagement", ResourceName: "serviceconsumermanagement.services.tenancyUnits.addProject"},
		{Hostname: "serviceconsumermanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{servicesId}/{servicesId1}/{servicesId2}/tenancyUnits/{tenancyUnitsId}:removeProject", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tenancyUnits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:removeProject)$`), ServiceName: "google.serviceconsumermanagement", ResourceName: "serviceconsumermanagement.services.tenancyUnits.removeProject"},
		{Hostname: "servicecontrol.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}:allocateQuota", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:allocateQuota)$`), ServiceName: "google.servicecontrol", ResourceName: "servicecontrol.services.allocateQuota"},
		{Hostname: "servicecontrol.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}:check", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:check)$`), ServiceName: "google.servicecontrol", ResourceName: "servicecontrol.services.check"},
		{Hostname: "servicecontrol.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}:endReconciliation", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:endReconciliation)$`), ServiceName: "google.servicecontrol", ResourceName: "servicecontrol.services.endReconciliation"},
		{Hostname: "servicecontrol.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}:releaseQuota", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:releaseQuota)$`), ServiceName: "google.servicecontrol", ResourceName: "servicecontrol.services.releaseQuota"},
		{Hostname: "servicecontrol.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}:report", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:report)$`), ServiceName: "google.servicecontrol", ResourceName: "servicecontrol.services.report"},
		{Hostname: "servicecontrol.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}:startReconciliation", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:startReconciliation)$`), ServiceName: "google.servicecontrol", ResourceName: "servicecontrol.services.startReconciliation"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/services/{serviceName}", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.delete"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations", PathMatcher: regexp.MustCompile(`^(/v1/operations)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.operations.list"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.operations.get"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services", PathMatcher: regexp.MustCompile(`^(/v1/services)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.list"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services/{serviceName}", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.get"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services/{serviceName}/config", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/config)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.getConfig"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services/{serviceName}/configs", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.configs.list"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services/{serviceName}/configs/{configId}", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.configs.get"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services/{serviceName}/rollouts", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/rollouts)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.rollouts.list"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services/{serviceName}/rollouts/{rolloutId}", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/rollouts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.rollouts.get"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services", PathMatcher: regexp.MustCompile(`^(/v1/services)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.create"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}/configs", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.configs.create"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}/configs:submit", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/configs:submit)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.configs.submit"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}/rollouts", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/rollouts)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.rollouts.create"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}:disable", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:disable)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.disable"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}:enable", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:enable)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.enable"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{serviceName}:undelete", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:undelete)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.undelete"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{servicesId}/consumers/{consumersId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/consumers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.consumers.getIamPolicy"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{servicesId}/consumers/{consumersId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/consumers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.consumers.setIamPolicy"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{servicesId}/consumers/{consumersId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/consumers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.consumers.testIamPermissions"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{servicesId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.getIamPolicy"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{servicesId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.setIamPolicy"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services/{servicesId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.testIamPermissions"},
		{Hostname: "servicemanagement.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/services:generateConfigReport", PathMatcher: regexp.MustCompile(`^(/v1/services:generateConfigReport)$`), ServiceName: "google.servicemanagement", ResourceName: "servicemanagement.services.generateConfigReport"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.operations.delete"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations", PathMatcher: regexp.MustCompile(`^(/v1/operations)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.operations.list"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.operations.get"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services:search", PathMatcher: regexp.MustCompile(`^(/v1/services:search)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.services.search"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/{v1Id}/{v1Id1}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.services.get"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/{v1Id}/{v1Id1}/services:enabled", PathMatcher: regexp.MustCompile(`^(/v1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services:enabled)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.services.listEnabled"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/operations", PathMatcher: regexp.MustCompile(`^(/v1beta1/operations)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.operations.list"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.operations.get"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/{v1beta1Id}/{v1beta1Id1}/services", PathMatcher: regexp.MustCompile(`^(/v1beta1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.services.list"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/{v1beta1Id}/{v1beta1Id1}/services/{servicesId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.services.get"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.operations.cancel"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/{v1Id}/{v1Id1}/services/{servicesId}:disable", PathMatcher: regexp.MustCompile(`^(/v1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:disable)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.services.disable"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/{v1Id}/{v1Id1}/services/{servicesId}:enable", PathMatcher: regexp.MustCompile(`^(/v1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:enable)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.services.enable"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/{v1beta1Id}/{v1beta1Id1}/services/{servicesId}:disable", PathMatcher: regexp.MustCompile(`^(/v1beta1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:disable)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.services.disable"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/{v1beta1Id}/{v1beta1Id1}/services/{servicesId}:enable", PathMatcher: regexp.MustCompile(`^(/v1beta1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:enable)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.services.enable"},
		{Hostname: "serviceusage.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/{v1beta1Id}/{v1beta1Id1}/services:batchEnable", PathMatcher: regexp.MustCompile(`^(/v1beta1/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services:batchEnable)$`), ServiceName: "google.serviceusage", ResourceName: "serviceusage.services.batchEnable"},
		{Hostname: "serviceuser.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/services", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services)$`), ServiceName: "google.serviceuser", ResourceName: "serviceuser.projects.services.list"},
		{Hostname: "serviceuser.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/services:search", PathMatcher: regexp.MustCompile(`^(/v1/services:search)$`), ServiceName: "google.serviceuser", ResourceName: "serviceuser.services.search"},
		{Hostname: "serviceuser.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/services/{servicesId}:disable", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:disable)$`), ServiceName: "google.serviceuser", ResourceName: "serviceuser.projects.services.disable"},
		{Hostname: "serviceuser.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/services/{servicesId}:enable", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/services/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:enable)$`), ServiceName: "google.serviceuser", ResourceName: "serviceuser.projects.services.enable"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v4/spreadsheets/{spreadsheetId}", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.get"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/developerMetadata/{metadataId}", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/developerMetadata/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.developerMetadata.get"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/values/{range}", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/values/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.values.get"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/values:batchGet", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/values:batchGet)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.values.batchGet"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.create"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/developerMetadata:search", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/developerMetadata:search)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.developerMetadata.search"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/sheets/{sheetId}:copyTo", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:copyTo)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.sheets.copyTo"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/values/{range}:append", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/values/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:append)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.values.append"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/values/{range}:clear", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/values/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:clear)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.values.clear"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/values:batchClear", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/values:batchClear)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.values.batchClear"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/values:batchClearByDataFilter", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/values:batchClearByDataFilter)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.values.batchClearByDataFilter"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/values:batchGetByDataFilter", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/values:batchGetByDataFilter)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.values.batchGetByDataFilter"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/values:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/values:batchUpdate)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.values.batchUpdate"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/values:batchUpdateByDataFilter", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/values:batchUpdateByDataFilter)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.values.batchUpdateByDataFilter"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:batchUpdate)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.batchUpdate"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v4/spreadsheets/{spreadsheetId}:getByDataFilter", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getByDataFilter)$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.getByDataFilter"},
		{Hostname: "sheets.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v4/spreadsheets/{spreadsheetId}/values/{range}", PathMatcher: regexp.MustCompile(`^(/v4/spreadsheets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/values/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.sheets", ResourceName: "sheets.spreadsheets.values.update"},
		{Hostname: "slides.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/presentations/{presentationId}/pages/{pageObjectId}", PathMatcher: regexp.MustCompile(`^(/v1/presentations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/pages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.slides", ResourceName: "slides.presentations.pages.get"},
		{Hostname: "slides.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/presentations/{presentationId}/pages/{pageObjectId}/thumbnail", PathMatcher: regexp.MustCompile(`^(/v1/presentations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/pages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/thumbnail)$`), ServiceName: "google.slides", ResourceName: "slides.presentations.pages.getThumbnail"},
		{Hostname: "slides.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/presentations/{presentationsId}", PathMatcher: regexp.MustCompile(`^(/v1/presentations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.slides", ResourceName: "slides.presentations.get"},
		{Hostname: "slides.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/presentations", PathMatcher: regexp.MustCompile(`^(/v1/presentations)$`), ServiceName: "google.slides", ResourceName: "slides.presentations.create"},
		{Hostname: "slides.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/presentations/{presentationId}:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v1/presentations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:batchUpdate)$`), ServiceName: "google.slides", ResourceName: "slides.presentations.batchUpdate"},
		{Hostname: "sourcerepo.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/repos/{reposId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/repos/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.sourcerepo", ResourceName: "sourcerepo.projects.repos.delete"},
		{Hostname: "sourcerepo.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/config", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/config)$`), ServiceName: "google.sourcerepo", ResourceName: "sourcerepo.projects.getConfig"},
		{Hostname: "sourcerepo.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/repos", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/repos)$`), ServiceName: "google.sourcerepo", ResourceName: "sourcerepo.projects.repos.list"},
		{Hostname: "sourcerepo.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/repos/{reposId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/repos/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.sourcerepo", ResourceName: "sourcerepo.projects.repos.get"},
		{Hostname: "sourcerepo.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/repos/{reposId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/repos/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.sourcerepo", ResourceName: "sourcerepo.projects.repos.getIamPolicy"},
		{Hostname: "sourcerepo.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/config", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/config)$`), ServiceName: "google.sourcerepo", ResourceName: "sourcerepo.projects.updateConfig"},
		{Hostname: "sourcerepo.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/repos/{reposId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/repos/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.sourcerepo", ResourceName: "sourcerepo.projects.repos.patch"},
		{Hostname: "sourcerepo.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/repos", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/repos)$`), ServiceName: "google.sourcerepo", ResourceName: "sourcerepo.projects.repos.create"},
		{Hostname: "sourcerepo.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/repos/{reposId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/repos/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.sourcerepo", ResourceName: "sourcerepo.projects.repos.setIamPolicy"},
		{Hostname: "sourcerepo.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/repos/{reposId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/repos/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.sourcerepo", ResourceName: "sourcerepo.projects.repos.testIamPermissions"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.delete"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.dropDatabase"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.operations.delete"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.delete"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.operations.delete"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instanceConfigs", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceConfigs)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instanceConfigs.list"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instanceConfigs/{instanceConfigsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instanceConfigs.get"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.list"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.get"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.list"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.get"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/ddl", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/ddl)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.getDdl"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.operations.list"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.operations.get"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.list"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.get"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/operations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.operations.list"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.operations.get"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.patch"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/ddl", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/ddl)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.updateDdl"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.create"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.create"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.operations.cancel"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.create"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:beginTransaction", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:beginTransaction)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.beginTransaction"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:commit", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:commit)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.commit"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:executeSql", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:executeSql)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.executeSql"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:executeStreamingSql", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:executeStreamingSql)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.executeStreamingSql"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:partitionQuery", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:partitionQuery)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.partitionQuery"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:partitionRead", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:partitionRead)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.partitionRead"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:read", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:read)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.read"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:rollback", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:rollback)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.rollback"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}/sessions/{sessionsId}:streamingRead", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sessions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:streamingRead)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.sessions.streamingRead"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.getIamPolicy"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.setIamPolicy"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/databases/{databasesId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/databases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.databases.testIamPermissions"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.operations.cancel"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}:getIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:getIamPolicy)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.getIamPolicy"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}:setIamPolicy", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:setIamPolicy)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.setIamPolicy"},
		{Hostname: "spanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/instances/{instancesId}:testIamPermissions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:testIamPermissions)$`), ServiceName: "google.spanner", ResourceName: "spanner.projects.instances.testIamPermissions"},
		{Hostname: "speech.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.speech", ResourceName: "speech.operations.get"},
		{Hostname: "speech.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1beta1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.speech", ResourceName: "speech.operations.get"},
		{Hostname: "speech.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/speech:longrunningrecognize", PathMatcher: regexp.MustCompile(`^(/v1/speech:longrunningrecognize)$`), ServiceName: "google.speech", ResourceName: "speech.speech.longrunningrecognize"},
		{Hostname: "speech.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/speech:recognize", PathMatcher: regexp.MustCompile(`^(/v1/speech:recognize)$`), ServiceName: "google.speech", ResourceName: "speech.speech.recognize"},
		{Hostname: "speech.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/speech:asyncrecognize", PathMatcher: regexp.MustCompile(`^(/v1beta1/speech:asyncrecognize)$`), ServiceName: "google.speech", ResourceName: "speech.speech.asyncrecognize"},
		{Hostname: "speech.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/speech:syncrecognize", PathMatcher: regexp.MustCompile(`^(/v1beta1/speech:syncrecognize)$`), ServiceName: "google.speech", ResourceName: "speech.speech.syncrecognize"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/transferOperations/{transferOperationsId}", PathMatcher: regexp.MustCompile(`^(/v1/transferOperations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.transferOperations.delete"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/googleServiceAccounts/{projectId}", PathMatcher: regexp.MustCompile(`^(/v1/googleServiceAccounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.googleServiceAccounts.get"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/transferJobs", PathMatcher: regexp.MustCompile(`^(/v1/transferJobs)$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.transferJobs.list"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/transferJobs/{transferJobsId}", PathMatcher: regexp.MustCompile(`^(/v1/transferJobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.transferJobs.get"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/transferOperations", PathMatcher: regexp.MustCompile(`^(/v1/transferOperations)$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.transferOperations.list"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/transferOperations/{transferOperationsId}", PathMatcher: regexp.MustCompile(`^(/v1/transferOperations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.transferOperations.get"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1/transferJobs/{transferJobsId}", PathMatcher: regexp.MustCompile(`^(/v1/transferJobs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.transferJobs.patch"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/transferJobs", PathMatcher: regexp.MustCompile(`^(/v1/transferJobs)$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.transferJobs.create"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/transferOperations/{transferOperationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/transferOperations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.transferOperations.cancel"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/transferOperations/{transferOperationsId}:pause", PathMatcher: regexp.MustCompile(`^(/v1/transferOperations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:pause)$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.transferOperations.pause"},
		{Hostname: "storagetransfer.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/transferOperations/{transferOperationsId}:resume", PathMatcher: regexp.MustCompile(`^(/v1/transferOperations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:resume)$`), ServiceName: "google.storagetransfer", ResourceName: "storagetransfer.transferOperations.resume"},
		{Hostname: "streetviewpublish.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/photo/{photoId}", PathMatcher: regexp.MustCompile(`^(/v1/photo/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.streetviewpublish", ResourceName: "streetviewpublish.photo.delete"},
		{Hostname: "streetviewpublish.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/photo/{photoId}", PathMatcher: regexp.MustCompile(`^(/v1/photo/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.streetviewpublish", ResourceName: "streetviewpublish.photo.get"},
		{Hostname: "streetviewpublish.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/photos", PathMatcher: regexp.MustCompile(`^(/v1/photos)$`), ServiceName: "google.streetviewpublish", ResourceName: "streetviewpublish.photos.list"},
		{Hostname: "streetviewpublish.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/photos:batchGet", PathMatcher: regexp.MustCompile(`^(/v1/photos:batchGet)$`), ServiceName: "google.streetviewpublish", ResourceName: "streetviewpublish.photos.batchGet"},
		{Hostname: "streetviewpublish.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/photo", PathMatcher: regexp.MustCompile(`^(/v1/photo)$`), ServiceName: "google.streetviewpublish", ResourceName: "streetviewpublish.photo.create"},
		{Hostname: "streetviewpublish.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/photo:startUpload", PathMatcher: regexp.MustCompile(`^(/v1/photo:startUpload)$`), ServiceName: "google.streetviewpublish", ResourceName: "streetviewpublish.photo.startUpload"},
		{Hostname: "streetviewpublish.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/photos:batchDelete", PathMatcher: regexp.MustCompile(`^(/v1/photos:batchDelete)$`), ServiceName: "google.streetviewpublish", ResourceName: "streetviewpublish.photos.batchDelete"},
		{Hostname: "streetviewpublish.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/photos:batchUpdate", PathMatcher: regexp.MustCompile(`^(/v1/photos:batchUpdate)$`), ServiceName: "google.streetviewpublish", ResourceName: "streetviewpublish.photos.batchUpdate"},
		{Hostname: "streetviewpublish.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/photo/{id}", PathMatcher: regexp.MustCompile(`^(/v1/photo/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.streetviewpublish", ResourceName: "streetviewpublish.photo.update"},
		{Hostname: "testing.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectId}/testMatrices/{testMatrixId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/testMatrices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.testing", ResourceName: "testing.projects.testMatrices.get"},
		{Hostname: "testing.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/testEnvironmentCatalog/{environmentType}", PathMatcher: regexp.MustCompile(`^(/v1/testEnvironmentCatalog/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.testing", ResourceName: "testing.testEnvironmentCatalog.get"},
		{Hostname: "testing.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/applicationDetailService/getApkDetails", PathMatcher: regexp.MustCompile(`^(/v1/applicationDetailService/getApkDetails)$`), ServiceName: "google.testing", ResourceName: "testing.applicationDetailService.getApkDetails"},
		{Hostname: "testing.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/testMatrices", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/testMatrices)$`), ServiceName: "google.testing", ResourceName: "testing.projects.testMatrices.create"},
		{Hostname: "testing.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectId}/testMatrices/{testMatrixId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/testMatrices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.testing", ResourceName: "testing.projects.testMatrices.cancel"},
		{Hostname: "texttospeech.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1beta1/voices", PathMatcher: regexp.MustCompile(`^(/v1beta1/voices)$`), ServiceName: "google.texttospeech", ResourceName: "texttospeech.voices.list"},
		{Hostname: "texttospeech.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/text:synthesize", PathMatcher: regexp.MustCompile(`^(/v1beta1/text:synthesize)$`), ServiceName: "google.texttospeech", ResourceName: "texttospeech.text.synthesize"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.delete"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.operations.delete"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.delete"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.operations.delete"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.list"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.get"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/acceleratorTypes", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/acceleratorTypes)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.acceleratorTypes.list"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/acceleratorTypes/{acceleratorTypesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/acceleratorTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.acceleratorTypes.get"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/nodes", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.list"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.get"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.operations.list"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.operations.get"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/tensorflowVersions", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tensorflowVersions)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.tensorflowVersions.list"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/tensorflowVersions/{tensorflowVersionsId}", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tensorflowVersions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.tensorflowVersions.get"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/locations", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.list"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.get"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/acceleratorTypes", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/acceleratorTypes)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.acceleratorTypes.list"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/acceleratorTypes/{acceleratorTypesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/acceleratorTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.acceleratorTypes.get"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/nodes", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.list"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.get"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/operations", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.operations.list"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.operations.get"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/tensorflowVersions", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tensorflowVersions)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.tensorflowVersions.list"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/tensorflowVersions/{tensorflowVersionsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tensorflowVersions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.tensorflowVersions.get"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/nodes", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.create"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}:reimage", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:reimage)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.reimage"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}:reset", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:reset)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.reset"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}:start", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:start)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.start"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}:stop", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:stop)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.stop"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.operations.cancel"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/nodes", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.create"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}:reimage", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:reimage)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.reimage"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}:reset", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:reset)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.reset"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}:start", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:start)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.start"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/nodes/{nodesId}:stop", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:stop)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.nodes.stop"},
		{Hostname: "tpu.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1alpha1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.tpu", ResourceName: "tpu.projects.locations.operations.cancel"},
		{Hostname: "tracing.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/traces", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/traces)$`), ServiceName: "google.tracing", ResourceName: "tracing.projects.traces.list"},
		{Hostname: "tracing.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v2/projects/{projectsId}/traces/{tracesId}:listSpans", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/traces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:listSpans)$`), ServiceName: "google.tracing", ResourceName: "tracing.projects.traces.listSpans"},
		{Hostname: "tracing.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v2/projects/{projectsId}/traces:batchWrite", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/traces:batchWrite)$`), ServiceName: "google.tracing", ResourceName: "tracing.projects.traces.batchWrite"},
		{Hostname: "tracing.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v2/projects/{projectsId}/traces/{tracesId}/spans/{spansId}", PathMatcher: regexp.MustCompile(`^(/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/traces/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/spans/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.tracing", ResourceName: "tracing.projects.traces.spans.create"},
		{Hostname: "translation.googleapis.com", HTTPMethod: "GET", PathTemplate: "/language/translate/v2", PathMatcher: regexp.MustCompile(`^(/language/translate/v2)$`), ServiceName: "google.translate", ResourceName: "language.translations.list"},
		{Hostname: "translation.googleapis.com", HTTPMethod: "GET", PathTemplate: "/language/translate/v2/detect", PathMatcher: regexp.MustCompile(`^(/language/translate/v2/detect)$`), ServiceName: "google.translate", ResourceName: "language.detections.list"},
		{Hostname: "translation.googleapis.com", HTTPMethod: "GET", PathTemplate: "/language/translate/v2/languages", PathMatcher: regexp.MustCompile(`^(/language/translate/v2/languages)$`), ServiceName: "google.translate", ResourceName: "language.languages.list"},
		{Hostname: "translation.googleapis.com", HTTPMethod: "POST", PathTemplate: "/language/translate/v2", PathMatcher: regexp.MustCompile(`^(/language/translate/v2)$`), ServiceName: "google.translate", ResourceName: "language.translations.translate"},
		{Hostname: "translation.googleapis.com", HTTPMethod: "POST", PathTemplate: "/language/translate/v2/detect", PathMatcher: regexp.MustCompile(`^(/language/translate/v2/detect)$`), ServiceName: "google.translate", ResourceName: "language.detections.detect"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/matters/{matterId}", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.vault", ResourceName: "vault.matters.delete"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/matters/{matterId}/holds/{holdId}", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/holds/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.vault", ResourceName: "vault.matters.holds.delete"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/matters/{matterId}/holds/{holdId}/accounts/{accountId}", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/holds/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.vault", ResourceName: "vault.matters.holds.accounts.delete"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/matters", PathMatcher: regexp.MustCompile(`^(/v1/matters)$`), ServiceName: "google.vault", ResourceName: "vault.matters.list"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/matters/{matterId}", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.vault", ResourceName: "vault.matters.get"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/matters/{matterId}/holds", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/holds)$`), ServiceName: "google.vault", ResourceName: "vault.matters.holds.list"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/matters/{matterId}/holds/{holdId}", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/holds/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.vault", ResourceName: "vault.matters.holds.get"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/matters/{matterId}/holds/{holdId}/accounts", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/holds/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts)$`), ServiceName: "google.vault", ResourceName: "vault.matters.holds.accounts.list"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/matters", PathMatcher: regexp.MustCompile(`^(/v1/matters)$`), ServiceName: "google.vault", ResourceName: "vault.matters.create"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/matters/{matterId}/holds", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/holds)$`), ServiceName: "google.vault", ResourceName: "vault.matters.holds.create"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/matters/{matterId}/holds/{holdId}/accounts", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/holds/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts)$`), ServiceName: "google.vault", ResourceName: "vault.matters.holds.accounts.create"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/matters/{matterId}:addPermissions", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:addPermissions)$`), ServiceName: "google.vault", ResourceName: "vault.matters.addPermissions"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/matters/{matterId}:close", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:close)$`), ServiceName: "google.vault", ResourceName: "vault.matters.close"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/matters/{matterId}:removePermissions", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:removePermissions)$`), ServiceName: "google.vault", ResourceName: "vault.matters.removePermissions"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/matters/{matterId}:reopen", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:reopen)$`), ServiceName: "google.vault", ResourceName: "vault.matters.reopen"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/matters/{matterId}:undelete", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:undelete)$`), ServiceName: "google.vault", ResourceName: "vault.matters.undelete"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/matters/{matterId}", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.vault", ResourceName: "vault.matters.update"},
		{Hostname: "vault.googleapis.com", HTTPMethod: "PUT", PathTemplate: "/v1/matters/{matterId}/holds/{holdId}", PathMatcher: regexp.MustCompile(`^(/v1/matters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/holds/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.vault", ResourceName: "vault.matters.holds.update"},
		{Hostname: "videointelligence.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.videointelligence", ResourceName: "videointelligence.operations.delete"},
		{Hostname: "videointelligence.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations", PathMatcher: regexp.MustCompile(`^(/v1/operations)$`), ServiceName: "google.videointelligence", ResourceName: "videointelligence.operations.list"},
		{Hostname: "videointelligence.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.videointelligence", ResourceName: "videointelligence.operations.get"},
		{Hostname: "videointelligence.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.videointelligence", ResourceName: "videointelligence.operations.cancel"},
		{Hostname: "videointelligence.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/videos:annotate", PathMatcher: regexp.MustCompile(`^(/v1/videos:annotate)$`), ServiceName: "google.videointelligence", ResourceName: "videointelligence.videos.annotate"},
		{Hostname: "videointelligence.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta1/videos:annotate", PathMatcher: regexp.MustCompile(`^(/v1beta1/videos:annotate)$`), ServiceName: "google.videointelligence", ResourceName: "videointelligence.videos.annotate"},
		{Hostname: "videointelligence.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1beta2/videos:annotate", PathMatcher: regexp.MustCompile(`^(/v1beta2/videos:annotate)$`), ServiceName: "google.videointelligence", ResourceName: "videointelligence.videos.annotate"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.vision", ResourceName: "vision.operations.delete"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/locations/{locationsId}/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/locations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.vision", ResourceName: "vision.locations.operations.get"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations", PathMatcher: regexp.MustCompile(`^(/v1/operations)$`), ServiceName: "google.vision", ResourceName: "vision.operations.list"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1/operations/{operationsId}", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.vision", ResourceName: "vision.operations.get"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/files:asyncBatchAnnotate", PathMatcher: regexp.MustCompile(`^(/v1/files:asyncBatchAnnotate)$`), ServiceName: "google.vision", ResourceName: "vision.files.asyncBatchAnnotate"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/images:annotate", PathMatcher: regexp.MustCompile(`^(/v1/images:annotate)$`), ServiceName: "google.vision", ResourceName: "vision.images.annotate"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1/operations/{operationsId}:cancel", PathMatcher: regexp.MustCompile(`^(/v1/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:cancel)$`), ServiceName: "google.vision", ResourceName: "vision.operations.cancel"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1p1beta1/files:asyncBatchAnnotate", PathMatcher: regexp.MustCompile(`^(/v1p1beta1/files:asyncBatchAnnotate)$`), ServiceName: "google.vision", ResourceName: "vision.files.asyncBatchAnnotate"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1p1beta1/images:annotate", PathMatcher: regexp.MustCompile(`^(/v1p1beta1/images:annotate)$`), ServiceName: "google.vision", ResourceName: "vision.images.annotate"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1p2beta1/files:asyncBatchAnnotate", PathMatcher: regexp.MustCompile(`^(/v1p2beta1/files:asyncBatchAnnotate)$`), ServiceName: "google.vision", ResourceName: "vision.files.asyncBatchAnnotate"},
		{Hostname: "vision.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1p2beta1/images:annotate", PathMatcher: regexp.MustCompile(`^(/v1p2beta1/images:annotate)$`), ServiceName: "google.vision", ResourceName: "vision.images.annotate"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.delete"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs)$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.list"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.get"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}/scanRuns", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanRuns)$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.scanRuns.list"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}/scanRuns/{scanRunsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanRuns/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.scanRuns.get"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}/scanRuns/{scanRunsId}/crawledUrls", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanRuns/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/crawledUrls)$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.scanRuns.crawledUrls.list"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}/scanRuns/{scanRunsId}/findingTypeStats", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanRuns/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/findingTypeStats)$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.scanRuns.findingTypeStats.list"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}/scanRuns/{scanRunsId}/findings", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanRuns/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/findings)$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.scanRuns.findings.list"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "GET", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}/scanRuns/{scanRunsId}/findings/{findingsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanRuns/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/findings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.scanRuns.findings.get"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "PATCH", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.patch"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs)$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.create"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}/scanRuns/{scanRunsId}:stop", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanRuns/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:stop)$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.scanRuns.stop"},
		{Hostname: "websecurityscanner.googleapis.com", HTTPMethod: "POST", PathTemplate: "/v1alpha/projects/{projectsId}/scanConfigs/{scanConfigsId}:start", PathMatcher: regexp.MustCompile(`^(/v1alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/scanConfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(:start)$`), ServiceName: "google.websecurityscanner", ResourceName: "websecurityscanner.projects.scanConfigs.start"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/adexchangebuyer/v1.3/pretargetingconfigs/{accountId}/{configId}", PathMatcher: regexp.MustCompile(`^(/adexchangebuyer/v1\.3/pretargetingconfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer", ResourceName: "adexchangebuyer.pretargetingConfig.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/adexchangebuyer/v1.4/pretargetingconfigs/{accountId}/{configId}", PathMatcher: regexp.MustCompile(`^(/adexchangebuyer/v1\.4/pretargetingconfigs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adexchangebuyer", ResourceName: "adexchangebuyer.pretargetingConfig.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customerId}/devices/mobile/{resourceId}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/mobile/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.mobiledevices.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customerId}/orgunits{/orgUnitPath*}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/orgunits)(?:/((?:(?:[\x2c\x3d\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*)(?:/(?:(?:[\x2c\x3d\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))*))?$`), ServiceName: "google.admin", ResourceName: "directory.orgunits.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customerId}/schemas/{schemaKey}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/schemas/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.schemas.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customer}/domainaliases/{domainAliasName}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domainaliases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.domainAliases.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customer}/domains/{domainName}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/domains/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.domains.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customer}/notifications/{notificationId}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/notifications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.notifications.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customer}/resources/buildings/{buildingId}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/resources/buildings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.resources.buildings.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customer}/resources/calendars/{calendarResourceId}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/resources/calendars/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.resources.calendars.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customer}/resources/features/{featureKey}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/resources/features/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.resources.features.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customer}/roleassignments/{roleAssignmentId}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roleassignments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.roleAssignments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/customer/{customer}/roles/{roleId}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/customer/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/roles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.roles.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/groups/{groupKey}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.groups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/groups/{groupKey}/aliases/{alias}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/aliases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.groups.aliases.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/groups/{groupKey}/members/{memberKey}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/members/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.members.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/users/{userKey}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.users.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/users/{userKey}/aliases/{alias}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/aliases/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.users.aliases.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/users/{userKey}/asps/{codeId}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/asps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.asps.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/users/{userKey}/photos/thumbnail", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/photos/thumbnail)$`), ServiceName: "google.admin", ResourceName: "directory.users.photos.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/admin/directory/v1/users/{userKey}/tokens/{clientId}", PathMatcher: regexp.MustCompile(`^(/admin/directory/v1/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tokens/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.admin", ResourceName: "directory.tokens.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/adsense/v1.4/accounts/{accountId}/alerts/{alertId}", PathMatcher: regexp.MustCompile(`^(/adsense/v1\.4/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/alerts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adsense", ResourceName: "adsense.accounts.alerts.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/adsense/v1.4/alerts/{alertId}", PathMatcher: regexp.MustCompile(`^(/adsense/v1\.4/alerts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adsense", ResourceName: "adsense.alerts.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/adsensehost/v4.1/accounts/{accountId}/adclients/{adClientId}/adunits/{adUnitId}", PathMatcher: regexp.MustCompile(`^(/adsensehost/v4\.1/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/adclients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/adunits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adsensehost", ResourceName: "adsensehost.accounts.adunits.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/adsensehost/v4.1/adclients/{adClientId}/customchannels/{customChannelId}", PathMatcher: regexp.MustCompile(`^(/adsensehost/v4\.1/adclients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/customchannels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adsensehost", ResourceName: "adsensehost.customchannels.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/adsensehost/v4.1/adclients/{adClientId}/urlchannels/{urlChannelId}", PathMatcher: regexp.MustCompile(`^(/adsensehost/v4\.1/adclients/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/urlchannels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.adsensehost", ResourceName: "adsensehost.urlchannels.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/analytics/v3/management/accounts/{accountId}/entityUserLinks/{linkId}", PathMatcher: regexp.MustCompile(`^(/analytics/v3/management/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityUserLinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.analytics", ResourceName: "analytics.management.accountUserLinks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/analytics/v3/management/accounts/{accountId}/filters/{filterId}", PathMatcher: regexp.MustCompile(`^(/analytics/v3/management/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/filters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.analytics", ResourceName: "analytics.management.filters.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/analytics/v3/management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}", PathMatcher: regexp.MustCompile(`^(/analytics/v3/management/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/webproperties/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityAdWordsLinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.analytics", ResourceName: "analytics.management.webPropertyAdWordsLinks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/analytics/v3/management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks/{linkId}", PathMatcher: regexp.MustCompile(`^(/analytics/v3/management/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/webproperties/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityUserLinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.analytics", ResourceName: "analytics.management.webpropertyUserLinks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/analytics/v3/management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}", PathMatcher: regexp.MustCompile(`^(/analytics/v3/management/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/webproperties/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/profiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.analytics", ResourceName: "analytics.management.profiles.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/analytics/v3/management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks/{linkId}", PathMatcher: regexp.MustCompile(`^(/analytics/v3/management/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/webproperties/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/profiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entityUserLinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.analytics", ResourceName: "analytics.management.profileUserLinks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/analytics/v3/management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}", PathMatcher: regexp.MustCompile(`^(/analytics/v3/management/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/webproperties/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/profiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/experiments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.analytics", ResourceName: "analytics.management.experiments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/analytics/v3/management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}", PathMatcher: regexp.MustCompile(`^(/analytics/v3/management/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/webproperties/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/profiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/profileFilterLinks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.analytics", ResourceName: "analytics.management.profileFilterLinks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/analytics/v3/management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports/{unsampledReportId}", PathMatcher: regexp.MustCompile(`^(/analytics/v3/management/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/webproperties/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/profiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/unsampledReports/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.analytics", ResourceName: "analytics.management.unsampledReports.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/analytics/v3/management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences/{remarketingAudienceId}", PathMatcher: regexp.MustCompile(`^(/analytics/v3/management/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/webproperties/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/remarketingAudiences/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.analytics", ResourceName: "analytics.management.remarketingAudience.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.enterprises.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}/serviceAccountKeys/{keyId}", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/serviceAccountKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.serviceaccountkeys.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}/storeLayout/pages/{pageId}", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/storeLayout/pages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.storelayoutpages.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}/storeLayout/pages/{pageId}/clusters/{clusterId}", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/storeLayout/pages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/clusters/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.storelayoutclusters.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}/users/{userId}", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.users.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}/users/{userId}/deviceAccess", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/deviceAccess)$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.users.revokeDeviceAccess"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}/users/{userId}/devices/{deviceId}/installs/{installId}", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/installs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.installs.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}/users/{userId}/devices/{deviceId}/managedConfigurationsForDevice/{managedConfigurationForDeviceId}", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/devices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/managedConfigurationsForDevice/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.managedconfigurationsfordevice.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}/users/{userId}/entitlements/{entitlementId}", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/entitlements/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.entitlements.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}/users/{userId}/managedConfigurationsForUser/{managedConfigurationForUserId}", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/managedConfigurationsForUser/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.managedconfigurationsforuser.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidenterprise/v1/enterprises/{enterpriseId}/users/{userId}/token", PathMatcher: regexp.MustCompile(`^(/androidenterprise/v1/enterprises/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/token)$`), ServiceName: "google.androidenterprise", ResourceName: "androidenterprise.users.revokeToken"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v2/applications/{packageName}/edits/{editId}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v2/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v2/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/listings", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v2/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/apks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/listings)$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.apklistings.deleteall"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v2/applications/{packageName}/edits/{editId}/apks/{apkVersionCode}/listings/{language}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v2/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/apks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/listings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.apklistings.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v2/applications/{packageName}/edits/{editId}/listings", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v2/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/listings)$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.listings.deleteall"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v2/applications/{packageName}/edits/{editId}/listings/{language}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v2/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/listings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.listings.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v2/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v2/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/listings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.images.deleteall"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v2/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}/{imageId}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v2/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/listings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.images.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v2/applications/{packageName}/inappproducts/{sku}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v2/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inappproducts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.inappproducts.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v3/applications/{packageName}/edits/{editId}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v3/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v3/applications/{packageName}/edits/{editId}/listings", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v3/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/listings)$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.listings.deleteall"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v3/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/listings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.listings.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v3/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/listings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.images.deleteall"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v3/applications/{packageName}/edits/{editId}/listings/{language}/{imageType}/{imageId}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v3/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/edits/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/listings/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.edits.images.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/androidpublisher/v3/applications/{packageName}/inappproducts/{sku}", PathMatcher: regexp.MustCompile(`^(/androidpublisher/v3/applications/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/inappproducts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.androidpublisher", ResourceName: "androidpublisher.inappproducts.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/apps/licensing/v1/product/{productId}/sku/{skuId}/user/{userId}", PathMatcher: regexp.MustCompile(`^(/apps/licensing/v1/product/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/sku/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/user/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.licensing", ResourceName: "licensing.licenseAssignments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/apps/reseller/v1/customers/{customerId}/subscriptions/{subscriptionId}", PathMatcher: regexp.MustCompile(`^(/apps/reseller/v1/customers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subscriptions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.reseller", ResourceName: "reseller.subscriptions.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/appstate/v1/states/{stateKey}", PathMatcher: regexp.MustCompile(`^(/appstate/v1/states/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.appstate", ResourceName: "appstate.states.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/bigquery/v2/projects/{projectId}/datasets/{datasetId}", PathMatcher: regexp.MustCompile(`^(/bigquery/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/datasets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquery", ResourceName: "bigquery.datasets.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/bigquery/v2/projects/{projectId}/datasets/{datasetId}/tables/{tableId}", PathMatcher: regexp.MustCompile(`^(/bigquery/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/datasets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/tables/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.bigquery", ResourceName: "bigquery.tables.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/blogger/v3/blogs/{blogId}/pages/{pageId}", PathMatcher: regexp.MustCompile(`^(/blogger/v3/blogs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/pages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.blogger", ResourceName: "blogger.pages.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/blogger/v3/blogs/{blogId}/pages/{pageId}", PathMatcher: regexp.MustCompile(`^(/blogger/v3/blogs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/pages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.blogger", ResourceName: "blogger.pages.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/blogger/v3/blogs/{blogId}/posts/{postId}", PathMatcher: regexp.MustCompile(`^(/blogger/v3/blogs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/posts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.blogger", ResourceName: "blogger.posts.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/blogger/v3/blogs/{blogId}/posts/{postId}", PathMatcher: regexp.MustCompile(`^(/blogger/v3/blogs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/posts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.blogger", ResourceName: "blogger.posts.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/blogger/v3/blogs/{blogId}/posts/{postId}/comments/{commentId}", PathMatcher: regexp.MustCompile(`^(/blogger/v3/blogs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/posts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/comments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.blogger", ResourceName: "blogger.comments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/blogger/v3/blogs/{blogId}/posts/{postId}/comments/{commentId}", PathMatcher: regexp.MustCompile(`^(/blogger/v3/blogs/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/posts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/comments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.blogger", ResourceName: "blogger.comments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/books/v1/mylibrary/annotations/{annotationId}", PathMatcher: regexp.MustCompile(`^(/books/v1/mylibrary/annotations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.books", ResourceName: "books.mylibrary.annotations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/calendar/v3/calendars/{calendarId}", PathMatcher: regexp.MustCompile(`^(/calendar/v3/calendars/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.calendar", ResourceName: "calendar.calendars.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/calendar/v3/calendars/{calendarId}/acl/{ruleId}", PathMatcher: regexp.MustCompile(`^(/calendar/v3/calendars/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/acl/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.calendar", ResourceName: "calendar.acl.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/calendar/v3/calendars/{calendarId}/events/{eventId}", PathMatcher: regexp.MustCompile(`^(/calendar/v3/calendars/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/events/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.calendar", ResourceName: "calendar.events.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/calendar/v3/users/me/calendarList/{calendarId}", PathMatcher: regexp.MustCompile(`^(/calendar/v3/users/me/calendarList/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.calendar", ResourceName: "calendar.calendarList.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/cloudmonitoring/v2beta2/projects/{project}/metricDescriptors/{metric}", PathMatcher: regexp.MustCompile(`^(/cloudmonitoring/v2beta2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/metricDescriptors/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.cloudmonitoring", ResourceName: "cloudmonitoring.metricDescriptors.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/alpha/projects/{project}/global/groups/{groupName}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.groups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/alpha/projects/{project}/global/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.globalAccountsOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/alpha/projects/{project}/global/users/{user}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.users.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/beta/projects/{project}/global/groups/{groupName}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.groups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/beta/projects/{project}/global/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.globalAccountsOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/beta/projects/{project}/global/users/{user}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.users.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/vm_alpha/projects/{project}/global/groups/{groupName}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/vm_alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.groups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/vm_alpha/projects/{project}/global/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/vm_alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.globalAccountsOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/vm_alpha/projects/{project}/global/users/{user}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/vm_alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.users.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/vm_beta/projects/{project}/global/groups/{groupName}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/vm_beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/groups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.groups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/vm_beta/projects/{project}/global/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/vm_beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.globalAccountsOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/clouduseraccounts/vm_beta/projects/{project}/global/users/{user}", PathMatcher: regexp.MustCompile(`^(/clouduseraccounts/vm_beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/users/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.clouduseraccounts", ResourceName: "clouduseraccounts.users.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/addresses/{address}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/addresses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.globalAddresses.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/backendBuckets/{backendBucket}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/backendBuckets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.backendBuckets.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/backendServices/{backendService}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/backendServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.backendServices.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/firewalls/{firewall}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/firewalls/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.firewalls.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/forwardingRules/{forwardingRule}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/forwardingRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.globalForwardingRules.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/healthChecks/{healthCheck}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/healthChecks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.healthChecks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/httpHealthChecks/{httpHealthCheck}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/httpHealthChecks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.httpHealthChecks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/httpsHealthChecks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.httpsHealthChecks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/images/{image}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/images/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.images.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/instanceTemplates/{instanceTemplate}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/instanceTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instanceTemplates.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/interconnects/{interconnect}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/interconnects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.interconnects.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/licenses/{license}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/licenses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.licenses.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/networks/{network}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/networks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.networks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.globalOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/routes/{route}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/routes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.routes.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/securityPolicies/{securityPolicy}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/securityPolicies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.securityPolicies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/snapshots/{snapshot}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/snapshots/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.snapshots.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/sslCertificates/{sslCertificate}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/sslCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.sslCertificates.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/sslPolicies/{sslPolicy}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/sslPolicies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.sslPolicies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/targetHttpProxies/{targetHttpProxy}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetHttpProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetHttpProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetHttpsProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetHttpsProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/targetSslProxies/{targetSslProxy}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetSslProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetSslProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/targetTcpProxies/{targetTcpProxy}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetTcpProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetTcpProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/global/urlMaps/{urlMap}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/urlMaps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.urlMaps.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/addresses/{address}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/addresses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.addresses.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/autoscalers/{autoscaler}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/autoscalers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionAutoscalers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/backendServices/{backendService}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/backendServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionBackendServices.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/disks/{disk}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/disks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionDisks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/forwardingRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.forwardingRules.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/healthChecks/{healthCheck}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/healthChecks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionHealthChecks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceGroupManagers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionInstanceGroupManagers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/interconnectAttachments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.interconnectAttachments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/nodeTemplates/{nodeTemplate}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodeTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.nodeTemplates.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/resourcePolicies/{resourcePolicy}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/resourcePolicies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.resourcePolicies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/routers/{router}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/routers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.routers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/subnetworks/{subnetwork}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subnetworks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.subnetworks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/targetHttpProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionTargetHttpProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/targetPools/{targetPool}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/targetPools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetPools.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/targetVpnGateways/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetVpnGateways.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/urlMaps/{urlMap}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/urlMaps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionUrlMaps.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/vpnGateways/{vpnGateway}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/vpnGateways/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.vpnGateways.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/regions/{region}/vpnTunnels/{vpnTunnel}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/vpnTunnels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.vpnTunnels.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/zones/{zone}/autoscalers/{autoscaler}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/autoscalers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.autoscalers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/zones/{zone}/disks/{disk}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/disks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.disks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/zones/{zone}/hosts/{host}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/hosts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.hosts.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceGroupManagers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instanceGroupManagers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instanceGroups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/zones/{zone}/instances/{instance}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instances.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/networkEndpointGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.networkEndpointGroups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodeGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.nodeGroups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/zones/{zone}/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.zoneOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/alpha/projects/{project}/zones/{zone}/targetInstances/{targetInstance}", PathMatcher: regexp.MustCompile(`^(/compute/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/targetInstances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetInstances.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/addresses/{address}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/addresses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.globalAddresses.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/backendBuckets/{backendBucket}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/backendBuckets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.backendBuckets.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/backendServices/{backendService}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/backendServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.backendServices.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/firewalls/{firewall}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/firewalls/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.firewalls.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/forwardingRules/{forwardingRule}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/forwardingRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.globalForwardingRules.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/healthChecks/{healthCheck}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/healthChecks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.healthChecks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/httpHealthChecks/{httpHealthCheck}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/httpHealthChecks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.httpHealthChecks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/httpsHealthChecks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.httpsHealthChecks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/images/{image}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/images/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.images.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/instanceTemplates/{instanceTemplate}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/instanceTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instanceTemplates.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/interconnects/{interconnect}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/interconnects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.interconnects.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/licenses/{license}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/licenses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.licenses.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/networks/{network}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/networks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.networks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.globalOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/routes/{route}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/routes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.routes.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/securityPolicies/{securityPolicy}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/securityPolicies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.securityPolicies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/snapshots/{snapshot}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/snapshots/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.snapshots.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/sslCertificates/{sslCertificate}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/sslCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.sslCertificates.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/sslPolicies/{sslPolicy}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/sslPolicies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.sslPolicies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/targetHttpProxies/{targetHttpProxy}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetHttpProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetHttpProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetHttpsProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetHttpsProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/targetSslProxies/{targetSslProxy}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetSslProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetSslProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/targetTcpProxies/{targetTcpProxy}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetTcpProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetTcpProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/global/urlMaps/{urlMap}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/urlMaps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.urlMaps.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/addresses/{address}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/addresses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.addresses.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/autoscalers/{autoscaler}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/autoscalers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionAutoscalers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/backendServices/{backendService}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/backendServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionBackendServices.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/disks/{disk}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/disks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionDisks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/forwardingRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.forwardingRules.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceGroupManagers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionInstanceGroupManagers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/interconnectAttachments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.interconnectAttachments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/nodeTemplates/{nodeTemplate}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodeTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.nodeTemplates.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/routers/{router}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/routers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.routers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/subnetworks/{subnetwork}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subnetworks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.subnetworks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/targetPools/{targetPool}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/targetPools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetPools.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/targetVpnGateways/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetVpnGateways.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/regions/{region}/vpnTunnels/{vpnTunnel}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/vpnTunnels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.vpnTunnels.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/zones/{zone}/autoscalers/{autoscaler}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/autoscalers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.autoscalers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/zones/{zone}/disks/{disk}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/disks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.disks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceGroupManagers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instanceGroupManagers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instanceGroups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/zones/{zone}/instances/{instance}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instances.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/nodeGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.nodeGroups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/zones/{zone}/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.zoneOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/beta/projects/{project}/zones/{zone}/targetInstances/{targetInstance}", PathMatcher: regexp.MustCompile(`^(/compute/beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/targetInstances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetInstances.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/addresses/{address}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/addresses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.globalAddresses.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/backendBuckets/{backendBucket}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/backendBuckets/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.backendBuckets.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/backendServices/{backendService}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/backendServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.backendServices.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/firewalls/{firewall}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/firewalls/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.firewalls.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/forwardingRules/{forwardingRule}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/forwardingRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.globalForwardingRules.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/healthChecks/{healthCheck}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/healthChecks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.healthChecks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/httpHealthChecks/{httpHealthCheck}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/httpHealthChecks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.httpHealthChecks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/httpsHealthChecks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.httpsHealthChecks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/images/{image}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/images/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.images.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/instanceTemplates/{instanceTemplate}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/instanceTemplates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instanceTemplates.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/interconnects/{interconnect}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/interconnects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.interconnects.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/licenses/{license}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/licenses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.licenses.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/networks/{network}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/networks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.networks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.globalOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/routes/{route}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/routes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.routes.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/snapshots/{snapshot}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/snapshots/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.snapshots.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/sslCertificates/{sslCertificate}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/sslCertificates/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.sslCertificates.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/sslPolicies/{sslPolicy}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/sslPolicies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.sslPolicies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/targetHttpProxies/{targetHttpProxy}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetHttpProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetHttpProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetHttpsProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetHttpsProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/targetSslProxies/{targetSslProxy}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetSslProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetSslProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/targetTcpProxies/{targetTcpProxy}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/targetTcpProxies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetTcpProxies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/global/urlMaps/{urlMap}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/urlMaps/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.urlMaps.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/addresses/{address}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/addresses/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.addresses.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/autoscalers/{autoscaler}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/autoscalers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionAutoscalers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/backendServices/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionBackendServices.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/disks/{disk}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/disks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionDisks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/forwardingRules/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.forwardingRules.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceGroupManagers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionInstanceGroupManagers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/interconnectAttachments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.interconnectAttachments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.regionOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/routers/{router}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/routers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.routers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/subnetworks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.subnetworks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/targetPools/{targetPool}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/targetPools/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetPools.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/targetVpnGateways/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetVpnGateways.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/regions/{region}/vpnTunnels/{vpnTunnel}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/regions/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/vpnTunnels/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.vpnTunnels.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/zones/{zone}/autoscalers/{autoscaler}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/autoscalers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.autoscalers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/zones/{zone}/disks/{disk}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/disks/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.disks.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceGroupManagers/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instanceGroupManagers.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instanceGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instanceGroups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/zones/{zone}/instances/{instance}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/instances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.instances.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/zones/{zone}/operations/{operation}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/operations/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.zoneOperations.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/compute/v1/projects/{project}/zones/{zone}/targetInstances/{targetInstance}", PathMatcher: regexp.MustCompile(`^(/compute/v1/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/zones/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/targetInstances/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.compute", ResourceName: "compute.targetInstances.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/consumersurveys/v2/surveys/{surveyUrlId}", PathMatcher: regexp.MustCompile(`^(/consumersurveys/v2/surveys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.consumersurveys", ResourceName: "consumersurveys.surveys.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/content/v2/{merchantId}/accounts/{accountId}", PathMatcher: regexp.MustCompile(`^(/content/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/accounts/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.content", ResourceName: "content.accounts.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/content/v2/{merchantId}/datafeeds/{datafeedId}", PathMatcher: regexp.MustCompile(`^(/content/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/datafeeds/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.content", ResourceName: "content.datafeeds.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/content/v2/{merchantId}/pos/{targetMerchantId}/store/{storeCode}", PathMatcher: regexp.MustCompile(`^(/content/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/pos/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/store/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.content", ResourceName: "content.pos.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/content/v2/{merchantId}/products/{productId}", PathMatcher: regexp.MustCompile(`^(/content/v2/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/products/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.content", ResourceName: "content.products.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/deploymentmanager/alpha/projects/{project}/global/compositeTypes/{compositeType}", PathMatcher: regexp.MustCompile(`^(/deploymentmanager/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/compositeTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.deploymentmanager", ResourceName: "deploymentmanager.compositeTypes.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/deploymentmanager/alpha/projects/{project}/global/deployments/{deployment}", PathMatcher: regexp.MustCompile(`^(/deploymentmanager/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/deployments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.deploymentmanager", ResourceName: "deploymentmanager.deployments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/deploymentmanager/alpha/projects/{project}/global/typeProviders/{typeProvider}", PathMatcher: regexp.MustCompile(`^(/deploymentmanager/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/typeProviders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.deploymentmanager", ResourceName: "deploymentmanager.typeProviders.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/deploymentmanager/alpha/projects/{project}/global/types/{type}", PathMatcher: regexp.MustCompile(`^(/deploymentmanager/alpha/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/types/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.deploymentmanager", ResourceName: "deploymentmanager.types.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/deploymentmanager/v2/projects/{project}/global/deployments/{deployment}", PathMatcher: regexp.MustCompile(`^(/deploymentmanager/v2/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/deployments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.deploymentmanager", ResourceName: "deploymentmanager.deployments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/deploymentmanager/v2beta/projects/{project}/global/compositeTypes/{compositeType}", PathMatcher: regexp.MustCompile(`^(/deploymentmanager/v2beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/compositeTypes/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.deploymentmanager", ResourceName: "deploymentmanager.compositeTypes.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/deploymentmanager/v2beta/projects/{project}/global/deployments/{deployment}", PathMatcher: regexp.MustCompile(`^(/deploymentmanager/v2beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/deployments/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.deploymentmanager", ResourceName: "deploymentmanager.deployments.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/deploymentmanager/v2beta/projects/{project}/global/typeProviders/{typeProvider}", PathMatcher: regexp.MustCompile(`^(/deploymentmanager/v2beta/projects/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/global/typeProviders/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.deploymentmanager", ResourceName: "deploymentmanager.typeProviders.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/advertiserGroups/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/advertiserGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.advertiserGroups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/campaigns/{campaignId}/landingPages/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/campaigns/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/landingPages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.landingPages.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/contentCategories/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contentCategories/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.contentCategories.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/creativeFields/{creativeFieldId}/creativeFieldValues/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creativeFields/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creativeFieldValues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.creativeFieldValues.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/creativeFields/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creativeFields/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.creativeFields.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/dynamicTargetingKeys/{objectId}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dynamicTargetingKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.dynamicTargetingKeys.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/eventTags/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/eventTags/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.eventTags.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/floodlightActivities/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/floodlightActivities/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.floodlightActivities.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/placementStrategies/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/placementStrategies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.placementStrategies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/reports/{reportId}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/reports/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.reports.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.7/userprofiles/{profileId}/userRoles/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.7/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/userRoles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.userRoles.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/advertiserGroups/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/advertiserGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.advertiserGroups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/campaigns/{campaignId}/landingPages/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/campaigns/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/landingPages/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.landingPages.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/contentCategories/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contentCategories/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.contentCategories.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/creativeFields/{creativeFieldId}/creativeFieldValues/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creativeFields/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creativeFieldValues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.creativeFieldValues.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/creativeFields/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creativeFields/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.creativeFields.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/dynamicTargetingKeys/{objectId}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dynamicTargetingKeys/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.dynamicTargetingKeys.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/eventTags/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/eventTags/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.eventTags.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/floodlightActivities/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/floodlightActivities/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.floodlightActivities.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/placementStrategies/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/placementStrategies/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.placementStrategies.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/reports/{reportId}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/reports/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.reports.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v2.8/userprofiles/{profileId}/userRoles/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v2\.8/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/userRoles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.userRoles.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v3.0/userprofiles/{profileId}/advertiserGroups/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v3\.0/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/advertiserGroups/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.advertiserGroups.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v3.0/userprofiles/{profileId}/contentCategories/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v3\.0/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/contentCategories/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.contentCategories.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v3.0/userprofiles/{profileId}/creativeFields/{creativeFieldId}/creativeFieldValues/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v3\.0/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creativeFields/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creativeFieldValues/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.creativeFieldValues.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v3.0/userprofiles/{profileId}/creativeFields/{id}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v3\.0/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/creativeFields/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?$`), ServiceName: "google.dfareporting", ResourceName: "dfareporting.creativeFields.delete"},
		{Hostname: "www.googleapis.com", HTTPMethod: "DELETE", PathTemplate: "/dfareporting/v3.0/userprofiles/{profileId}/dynamicTargetingKeys/{objectId}", PathMatcher: regexp.MustCompile(`^(/dfareporting/v3\.0/userprofiles/)((?:(?:[\x2c\x2d\x2e\x30-\x39\x41-\x5a\x5f\x61-\x7a\x7e]|%[[:xdigit:]][[:xdigit:]])*))?(/dynamicTargeting