"use strict";

var _MongoMemoryReplSet = _interopRequireDefault(require("../MongoMemoryReplSet"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

describe('single server replset', () => {
  let replSet;
  afterEach(
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    if (!(replSet && replSet._state === 'running')) return;
    yield replSet.stop();
    replSet = null;
  }));
  it('should enter running state',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    replSet = new _MongoMemoryReplSet.default();
    yield replSet.waitUntilRunning();
    const uri = yield replSet.getUri();
    expect(uri.split(',').length).toEqual(1);
  }));
  it('should be able to get connection string to specific db',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    replSet = new _MongoMemoryReplSet.default();
    yield replSet.waitUntilRunning();
    const uri = yield replSet.getUri('other');
    const str = yield replSet.getConnectionString('other');
    expect(uri.split(',').length).toEqual(1);
    expect(uri.endsWith('/other')).toBeTruthy();
    expect(str).toEqual(uri);
  }));
  it('should be able to get dbName',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    const opts = {
      autoStart: false,
      replSet: {
        dbName: 'static'
      }
    };
    replSet = new _MongoMemoryReplSet.default(opts);
    const dbName = yield replSet.getDbName();
    expect(dbName).toEqual('static');
  }));
  it('should not autostart if autostart: false',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    replSet = new _MongoMemoryReplSet.default({
      autoStart: false
    });
    yield new Promise((resolve, reject) => {
      replSet.once('state', state => reject(new Error(`Invalid state: ${state}`)));
      setTimeout(resolve, 500);
    });
  }));
});
describe('multi-member replica set', () => {
  let replSet;
  afterEach(
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    if (!replSet) return;
    yield replSet.stop();
    replSet = null;
  }));
  it('should enter running state',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    const opts = {
      replSet: {
        count: 3
      }
    };
    replSet = new _MongoMemoryReplSet.default(opts);
    yield replSet.waitUntilRunning();
    expect(replSet.servers.length).toEqual(3);
    const uri = yield replSet.getUri();
    expect(uri.split(',').length).toEqual(3);
  }), 40000);
});