"use strict";

var _tmp = _interopRequireDefault(require("tmp"));

var _MongoInstance = _interopRequireDefault(require("../MongoInstance"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

jasmine.DEFAULT_TIMEOUT_INTERVAL = 240000;
let tmpDir;
beforeEach(() => {
  _tmp.default.setGracefulCleanup();

  tmpDir = _tmp.default.dirSync({
    prefix: 'mongo-mem-',
    unsafeCleanup: true
  });
});
afterEach(() => {
  tmpDir.removeCallback();
});
describe('MongoInstance', () => {
  it('should prepare command args', () => {
    const inst = new _MongoInstance.default({
      instance: {
        port: 27333,
        dbPath: '/data',
        storageEngine: 'ephemeralForTest'
      }
    });
    expect(inst.prepareCommandArgs()).toEqual(['--bind_ip', '127.0.0.1', '--port', '27333', '--storageEngine', 'ephemeralForTest', '--dbpath', '/data', '--noauth']);
  });
  it('should allow specifying replSet', () => {
    const inst = new _MongoInstance.default({
      instance: {
        port: 27555,
        dbPath: '/data',
        replSet: 'testset'
      }
    });
    expect(inst.prepareCommandArgs()).toEqual(['--bind_ip', '127.0.0.1', '--port', '27555', '--dbpath', '/data', '--noauth', '--replSet', 'testset']);
  });
  it('should be able to enable auth', () => {
    const inst = new _MongoInstance.default({
      instance: {
        port: 27555,
        dbPath: '/data',
        auth: true
      }
    });
    expect(inst.prepareCommandArgs()).toEqual(['--bind_ip', '127.0.0.1', '--port', '27555', '--dbpath', '/data']);
  });
  it('should be able to pass arbitrary args', () => {
    const args = ['--notablescan', '--nounixsocket'];
    const inst = new _MongoInstance.default({
      instance: {
        port: 27555,
        dbPath: '/data',
        args
      }
    });
    expect(inst.prepareCommandArgs()).toEqual(['--bind_ip', '127.0.0.1', '--port', '27555', '--dbpath', '/data', '--noauth'].concat(args));
  });
  it('should start instance on port 27333',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    const mongod = yield _MongoInstance.default.run({
      instance: {
        port: 27333,
        dbPath: tmpDir.name
      },
      binary: {
        version: 'latest'
      }
    });
    expect(mongod.getPid()).toBeGreaterThan(0);
    yield mongod.kill();
  }));
  it('should throw error if port is busy',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    const mongod = yield _MongoInstance.default.run({
      instance: {
        port: 27444,
        dbPath: tmpDir.name
      },
      binary: {
        version: 'latest'
      }
    });
    yield expect(_MongoInstance.default.run({
      instance: {
        port: 27444,
        dbPath: tmpDir.name
      },
      binary: {
        version: 'latest'
      }
    })).rejects.toBeDefined();
    yield mongod.kill();
  }));
  it('should await while mongo is killed',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    const mongod = yield _MongoInstance.default.run({
      instance: {
        port: 27445,
        dbPath: tmpDir.name
      },
      binary: {
        version: 'latest'
      }
    });
    const pid = mongod.getPid();
    expect(pid).toBeGreaterThan(0);

    function isPidRunning(p) {
      try {
        return process.kill(p, 0);
      } catch (e) {
        return e.code === 'EPERM';
      }
    }

    expect(isPidRunning(pid)).toBeTruthy();
    yield mongod.kill();
    expect(isPidRunning(pid)).toBeFalsy();
  }));
});