'use strict';

var _docsUrl = require('../docsUrl');

var _docsUrl2 = _interopRequireDefault(_docsUrl);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

module.exports = {
  meta: {
    type: 'suggestion',
    docs: {
      url: (0, _docsUrl2.default)('first')
    },
    fixable: 'code'
  },

  create: function (context) {
    function isPossibleDirective(node) {
      return node.type === 'ExpressionStatement' && node.expression.type === 'Literal' && typeof node.expression.value === 'string';
    }

    return {
      'Program': function (n) {
        const body = n.body,
              absoluteFirst = context.options[0] === 'absolute-first',
              message = 'Import in body of module; reorder to top.',
              sourceCode = context.getSourceCode(),
              originSourceCode = sourceCode.getText();
        let nonImportCount = 0,
            anyExpressions = false,
            anyRelative = false,
            lastLegalImp = null,
            errorInfos = [],
            shouldSort = true,
            lastSortNodesIndex = 0;
        body.forEach(function (node, index) {
          if (!anyExpressions && isPossibleDirective(node)) {
            return;
          }

          anyExpressions = true;

          if (node.type === 'ImportDeclaration') {
            if (absoluteFirst) {
              if (/^\./.test(node.source.value)) {
                anyRelative = true;
              } else if (anyRelative) {
                context.report({
                  node: node.source,
                  message: 'Absolute imports should come before relative imports.'
                });
              }
            }
            if (nonImportCount > 0) {
              for (let variable of context.getDeclaredVariables(node)) {
                if (!shouldSort) break;
                const references = variable.references;
                if (references.length) {
                  for (let reference of references) {
                    if (reference.identifier.range[0] < node.range[1]) {
                      shouldSort = false;
                      break;
                    }
                  }
                }
              }
              shouldSort && (lastSortNodesIndex = errorInfos.length);
              errorInfos.push({
                node,
                range: [body[index - 1].range[1], node.range[1]]
              });
            } else {
              lastLegalImp = node;
            }
          } else {
            nonImportCount++;
          }
        });
        if (!errorInfos.length) return;
        errorInfos.forEach(function (errorInfo, index) {
          const node = errorInfo.node,
                infos = {
            node,
            message
          };
          if (index < lastSortNodesIndex) {
            infos.fix = function (fixer) {
              return fixer.insertTextAfter(node, '');
            };
          } else if (index === lastSortNodesIndex) {
            const sortNodes = errorInfos.slice(0, lastSortNodesIndex + 1);
            infos.fix = function (fixer) {
              const removeFixers = sortNodes.map(function (_errorInfo) {
                return fixer.removeRange(_errorInfo.range);
              }),
                    range = [0, removeFixers[removeFixers.length - 1].range[1]];
              let insertSourceCode = sortNodes.map(function (_errorInfo) {
                const nodeSourceCode = String.prototype.slice.apply(originSourceCode, _errorInfo.range);
                if (/\S/.test(nodeSourceCode[0])) {
                  return '\n' + nodeSourceCode;
                }
                return nodeSourceCode;
              }).join(''),
                  insertFixer = null,
                  replaceSourceCode = '';
              if (!lastLegalImp) {
                insertSourceCode = insertSourceCode.trim() + insertSourceCode.match(/^(\s+)/)[0];
              }
              insertFixer = lastLegalImp ? fixer.insertTextAfter(lastLegalImp, insertSourceCode) : fixer.insertTextBefore(body[0], insertSourceCode);
              const fixers = [insertFixer].concat(removeFixers);
              fixers.forEach(function (computedFixer, i) {
                replaceSourceCode += originSourceCode.slice(fixers[i - 1] ? fixers[i - 1].range[1] : 0, computedFixer.range[0]) + computedFixer.text;
              });
              return fixer.replaceTextRange(range, replaceSourceCode);
            };
          }
          context.report(infos);
        });
      }
    };
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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