"use strict";

var _mongodb = require("mongodb");

var _MongoMemoryServer = _interopRequireDefault(require("../MongoMemoryServer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

jasmine.DEFAULT_TIMEOUT_INTERVAL = 60000;
let con1;
let con2;
let db1;
let db2;
let mongoServer1;
let mongoServer2;
beforeAll(
/*#__PURE__*/
_asyncToGenerator(function* () {
  mongoServer1 = new _MongoMemoryServer.default();
  const mongoUri = yield mongoServer1.getConnectionString();
  con1 = yield _mongodb.MongoClient.connect(mongoUri);
  db1 = con1.db((yield mongoServer1.getDbName()));
  mongoServer2 = new _MongoMemoryServer.default();
  const mongoUri2 = yield mongoServer2.getConnectionString();
  con2 = yield _mongodb.MongoClient.connect(mongoUri2);
  db2 = con2.db((yield mongoServer1.getDbName()));
}));
afterAll(() => {
  con1.close();
  con2.close();
  mongoServer1.stop();
  mongoServer2.stop();
});
describe('Multiple mongoServers', () => {
  it('should start several servers',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    expect(db1).toBeDefined();
    const col1 = db1.collection('test');
    const result1 = yield col1.insert([{
      a: 1
    }, {
      b: 1
    }]);
    expect(result1.result).toMatchSnapshot();
    expect((yield col1.count({}))).toBe(2);
    expect(db2).toBeDefined();
    const col2 = db2.collection('test');
    const result2 = yield col2.insert([{
      a: 2
    }, {
      b: 2
    }]);
    expect(result2.result).toMatchSnapshot();
    expect((yield col2.count({}))).toBe(2);
  }));
  it('should have different uri',
  /*#__PURE__*/
  _asyncToGenerator(function* () {
    const uri1 = yield mongoServer1.getConnectionString();
    const uri2 = yield mongoServer2.getConnectionString();
    expect(uri1).not.toEqual(uri2);
  }));
});