"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateDbName = generateDbName;
exports.getHost = getHost;
exports.getReplStatus = getReplStatus;
exports.default = void 0;

var _v = _interopRequireDefault(require("uuid/v4"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/**
 * Returns a database name string.
 * @param {string} dbName
 */
function generateDbName(dbName) {
  return dbName || (0, _v.default)();
}
/**
 * Extracts the host and port information from a mongodb URI string.
 * @param {string} uri mongodb URI
 */


function getHost(uri) {
  return uri.replace('mongodb://', '').replace(/\/.*/, '');
}
/**
 * Returns replica set status result.
 * @param {any} db db instance
 */


function getReplStatus(_x) {
  return _getReplStatus.apply(this, arguments);
}

function _getReplStatus() {
  _getReplStatus = _asyncToGenerator(function* (db) {
    const status = yield db.command({
      replSetGetStatus: 1
    });
    return status;
  });
  return _getReplStatus.apply(this, arguments);
}

var _default = generateDbName;
exports.default = _default;