/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
// flowlint ambiguous-object-type:error
'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var IRTransformer = require('../core/IRTransformer');

var _require = require('../core/CompilerError'),
    createUserError = _require.createUserError;

var SCHEMA_EXTENSION = "\ndirective @inline on FRAGMENT_DEFINITION\n";
/**
 * A transform that converts fragment spreads where the referenced fragment
 * is annotated with @inline to a InlineDataFragmentSpread.
 * InlineDataFragmentSpreads have the selections of the referenced fragment inlined.
 */

function inlineDataFragmentTransform(context) {
  return IRTransformer.transform(context, {
    // $FlowFixMe[prop-missing] - this visitor intentionally changes node types
    // $FlowFixMe[incompatible-call] - this visitor intentionally changes node types
    FragmentSpread: visitFragmentSpread,
    Fragment: visitFragment
  });
}

function visitFragment(fragment) {
  var transformedFragment = this.traverse(fragment);
  var inlineDirective = transformedFragment.directives.find(function (directive) {
    return directive.name === 'inline';
  });

  if (inlineDirective == null) {
    return transformedFragment;
  }

  return _objectSpread({}, transformedFragment, {
    directives: transformedFragment.directives.filter(function (directive) {
      return directive !== inlineDirective;
    }),
    metadata: _objectSpread({}, transformedFragment.metadata || {}, {
      inlineData: true
    })
  });
}

function visitFragmentSpread(fragmentSpread) {
  var transformedFragmentSpread = this.traverse(fragmentSpread);
  var context = this.getContext();
  var fragment = context.get(transformedFragmentSpread.name);

  if (!fragment || fragment.kind !== 'Fragment' || !fragment.directives.some(function (directive) {
    return directive.name === 'inline';
  })) {
    return transformedFragmentSpread;
  }

  if (fragment.argumentDefinitions.length > 0 || transformedFragmentSpread.args.length > 0) {
    throw createUserError('Variables are not yet supported inside @inline fragments.', [fragment.argumentDefinitions[0].loc]);
  }

  if (transformedFragmentSpread.directives.length > 0) {
    throw createUserError('Directives on fragment spreads for @inline fragments are not yet ' + 'supported', [transformedFragmentSpread.loc]);
  }

  var transformedFragment = this.visit(fragment);
  return {
    kind: 'InlineDataFragmentSpread',
    loc: transformedFragmentSpread.loc,
    metadata: transformedFragmentSpread.metadata,
    name: transformedFragmentSpread.name,
    selections: [{
      directives: [],
      kind: 'InlineFragment',
      loc: {
        kind: 'Derived',
        source: transformedFragmentSpread.loc
      },
      metadata: null,
      selections: transformedFragment.selections,
      typeCondition: transformedFragment.type
    }]
  };
}

module.exports = {
  SCHEMA_EXTENSION: SCHEMA_EXTENSION,
  transform: inlineDataFragmentTransform
};