import express from 'express';
import corsMiddleware from 'cors';
import { OptionsJson } from 'body-parser';
import { GraphQLOptions, ApolloServerBase, ContextFunction, Context, Config } from 'apollo-server-core';
import { ExecutionParams } from 'subscriptions-transport-ws';
export { GraphQLOptions, GraphQLExtension } from 'apollo-server-core';
export interface GetMiddlewareOptions {
    path?: string;
    cors?: corsMiddleware.CorsOptions | corsMiddleware.CorsOptionsDelegate | boolean;
    bodyParserConfig?: OptionsJson | boolean;
    onHealthCheck?: (req: express.Request) => Promise<any>;
    disableHealthCheck?: boolean;
}
export interface ServerRegistration extends GetMiddlewareOptions {
    app: express.Application;
}
export interface ExpressContext {
    req: express.Request;
    res: express.Response;
    connection?: ExecutionParams;
}
export interface ApolloServerExpressConfig extends Config {
    context?: ContextFunction<ExpressContext, Context> | Context;
}
export declare class ApolloServer extends ApolloServerBase {
    constructor(config: ApolloServerExpressConfig);
    createGraphQLServerOptions(req: express.Request, res: express.Response): Promise<GraphQLOptions>;
    protected supportsSubscriptions(): boolean;
    protected supportsUploads(): boolean;
    applyMiddleware({ app, ...rest }: ServerRegistration): void;
    getMiddleware({ path, cors, bodyParserConfig, disableHealthCheck, onHealthCheck, }?: GetMiddlewareOptions): express.Router;
}
//# sourceMappingURL=ApolloServer.d.ts.map